/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.validation;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.model.internal.CICWriter;
import com.ibm.cic.common.core.model.internal.IdAndVersion;
import com.ibm.cic.common.core.model.internal.validation.Messages;
import com.ibm.cic.common.core.model.utils.TwoTierMap;
import com.ibm.cic.common.core.model.validation.ValidationUtil;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MapListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public class InconsistentIUValidation {
    private static final String PLUGIN_ID = ComIbmCicCommonCorePlugin.getPluginId();
    protected IProgressMonitor progressMonitor;
    private final CicMultiStatus multiStatus;
    private static final int rule = 9;
    private TwoTierMap mapIuToParents;
    private CICWriter cicWriter;

    public InconsistentIUValidation(CicMultiStatus mainStatus, IProgressMonitor progress) {
        this.multiStatus = mainStatus;
        this.progressMonitor = progress;
    }

    private CICWriter getCICWriter() {
        if (this.cicWriter == null) {
            this.cicWriter = new CICWriter();
            this.cicWriter.setMode(9);
        }
        return this.cicWriter;
    }

    public void checkInconsistentIUs(Collection ius) {
        if (ValidationUtil.isRuleSuppressed(9)) {
            return;
        }
        this.progressMonitor.subTask(ValidationUtil.formatMessage(Messages.InconsistentIUValidation_TaskInconsistentIUs, ius.size()));
        this.mapIuToParents = new TwoTierMap(ius.size(), 3);
        Iterator it = ius.iterator();
        while (it.hasNext()) {
            if (this.progressMonitor.isCanceled()) {
                return;
            }
            IInstallableUnit iu = (IInstallableUnit)it.next();
            IdAndVersion idv = new IdAndVersion(iu.getIdentity(), iu.getVersion());
            IInstallableUnitContainer parent = iu.getParent();
            this.mapIuToParents.put(idv, parent, iu);
        }
        Iterator i = this.mapIuToParents.keySet().iterator();
        while (i.hasNext()) {
            if (this.progressMonitor.isCanceled()) {
                return;
            }
            IdAndVersion idv = (IdAndVersion)i.next();
            Collection parents = this.mapIuToParents.getAll(idv);
            if (parents.size() <= 1) continue;
            Collection duplicateIus = this.mapIuToParents.getAll(idv);
            this.checkInconsistentIUs(idv, duplicateIus);
        }
    }

    private void checkInconsistentIUs(IdAndVersion idv, final Collection duplicateIus) {
        HashMap map = new HashMap();
        Iterator iter = duplicateIus.iterator();
        while (iter.hasNext()) {
            if (this.progressMonitor.isCanceled()) {
                return;
            }
            IInstallableUnit iu = (IInstallableUnit)iter.next();
            ContentEquals ce = new ContentEquals(iu);
            MapListUtil.addMapList(map, new MapListUtil.ICollectionFactory(){

                @Override
                public Collection createCollection() {
                    return new ArrayList(duplicateIus.size());
                }
            }, ce, ce);
        }
        if (map.size() <= 1) {
            return;
        }
        String msg = ValidationUtil.formatMessage(Messages.InconsistentIUValidation_InconsistentIUs, idv.getIdentity().getId(), idv.getVersion().toString());
        msg = ValidationUtil.warning(msg, 9);
        MultiStatus msInconsistentIUs = new MultiStatus(PLUGIN_ID, 9, msg, null);
        int i = 1;
        Iterator iter2 = map.keySet().iterator();
        while (iter2.hasNext()) {
            if (this.progressMonitor.isCanceled()) {
                return;
            }
            ContentEquals key = (ContentEquals)iter2.next();
            Collection collection = MapListUtil.getMapList(map, key);
            String msg2 = ValidationUtil.formatMessage(Messages.InconsistentIUValidation_InconsistentIUsVariant, Integer.toString(i));
            MultiStatus msInconsistentVariant = new MultiStatus(PLUGIN_ID, 9, ValidationUtil.warning(key.toString(), 9), null);
            msg2 = ValidationUtil.warning(msg2, 9);
            msInconsistentVariant.add(ValidationUtil.newWarningStatus(msg2, PLUGIN_ID, 9));
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.progressMonitor.isCanceled()) {
                    return;
                }
                ContentEquals ce = (ContentEquals)iterator.next();
                IInstallableUnitContainer parent = ce.getIu().getParent();
                String msg3 = ValidationUtil.formatMessage(Messages.InconsistentIUValidation_InconsistentIUParent, parent.toString());
                msg3 = ValidationUtil.appendLineAndLocationToMessage(msg3, parent);
                msInconsistentVariant.add(ValidationUtil.newWarningStatus(msg3, PLUGIN_ID, 9));
            }
            msInconsistentIUs.add((IStatus)msInconsistentVariant);
            ++i;
        }
        this.multiStatus.add((IStatus)msInconsistentIUs);
    }

    class ContentEquals {
        private final IInstallableUnit iu;
        private final String content;

        public ContentEquals(IInstallableUnit iu) {
            this.iu = iu;
            this.content = CICWriter.toXML(InconsistentIUValidation.this.getCICWriter(), iu);
        }

        public int hashCode() {
            return this.content.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ContentEquals)) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            ContentEquals that = (ContentEquals)obj;
            return this.content.equals(that.content);
        }

        public IInstallableUnit getIu() {
            return this.iu;
        }

        public String toString() {
            return this.content;
        }
    }
}

