/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import com.ibm.cic.common.core.utils.MapMap;
import com.ibm.cic.common.core.utils.MapSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.Platform;

public class SupportedPlatforms {
    private static final SupportedPlatforms INSTANCE = new SupportedPlatforms();
    private final PlatformMap platforms = new PlatformMap();
    private final MapSet<String, String> osToArchSet = MapSet.newLinkedHash();

    public static SupportedPlatforms getInstance() {
        return INSTANCE;
    }

    private SupportedPlatforms() {
        this.add("motif", "aix", "ppc", "ppc64");
        this.add("gtk", "aix", "ppc", "ppc64");
        this.add("motif", "hpux", "ia64_32", "ia64");
        this.add("gtk", "hpux", "ia64_32", "ia64");
        this.add("motif", "hpux", "PA_RISC", "PA_RISC64");
        this.add("gtk", "linux", "x86", "x86_64");
        this.add("gtk", "linux", "ppc", "ppc64");
        this.add("gtk", "linux", "ppc64le");
        this.add("gtk", "linux", "s390", "s390x");
        this.add("cocoa", "macosx", "x86", "x86_64");
        this.add("cocoa", "macosx", "aarch64");
        this.add("motif", "os400", "ppc", "ppc64");
        this.add("gtk", "solaris", "sparc", "sparc64", "sparcv9");
        this.add("gtk", "solaris", "x86", "x86_64");
        this.add("win32", "win32", "x86", "x86_64");
        this.add("motif", "zos", "s390", "s390x");
    }

    private final void add(String ws, String os, String ... architectures) {
        List<String> architectureList = Arrays.asList(architectures);
        this.platforms.add(ws, os, architectureList);
        this.osToArchSet.addAll(os, architectureList);
    }

    public Set<String> getWsValues() {
        return this.platforms.keySet();
    }

    public Set<String> getWsValues(String os, String arch) {
        TreeSet<String> result = new TreeSet<String>();
        for (String ws : this.platforms.keySet()) {
            if (!this.platforms.contains(ws, os, arch)) continue;
            result.add(ws);
        }
        return result;
    }

    public String getLegacyWs(String os, String arch) {
        if ("aix".equals(os) && ("ppc".equals(arch) || "ppc64".equals(arch))) {
            return "motif";
        }
        if ("hpux".equals(os) && ("ia64_32".equals(arch) || "ia64".equals(arch))) {
            return "motif";
        }
        return Platform.getWS();
    }

    public Set<String> getOsValues() {
        return this.osToArchSet.keySet();
    }

    public Set<String> getOsValues(String arch) {
        TreeSet<String> result = new TreeSet<String>();
        for (String os : this.osToArchSet.keySet()) {
            if (!this.osToArchSet.contains(os, arch)) continue;
            result.add(os);
        }
        return result;
    }

    public Set<String> getArchValues() {
        TreeSet<String> result = new TreeSet<String>();
        for (String os : this.osToArchSet.keySet()) {
            result.addAll(this.osToArchSet.get(os));
        }
        return result;
    }

    public Set<String> getArchValues(String os) {
        return this.osToArchSet.get(os);
    }

    public String[][] getAllSupportedPlatforms() {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (String ws : this.platforms.keySet()) {
            Map map = this.platforms.get(ws);
            for (Map.Entry entry : map.entrySet()) {
                String os = (String)entry.getKey();
                Set set = (Set)entry.getValue();
                for (String arch : set) {
                    result.add(new String[]{ws, os, arch});
                }
            }
        }
        return (String[][])result.toArray((T[])new String[result.size()][]);
    }

    public boolean isSupported(String os, String arch) {
        return this.osToArchSet.contains(os, arch);
    }

    public boolean isSupported(String ws, String os, String arch) {
        return this.platforms.contains(ws, os, arch);
    }

    public String getAllSupportedPlatformsAsFilter() {
        String[][] allSupportedPlatforms = SupportedPlatforms.getInstance().getAllSupportedPlatforms();
        StringBuilder allSupportedPlatformsFilter = new StringBuilder("(|");
        String[][] stringArray = allSupportedPlatforms;
        int n = allSupportedPlatforms.length;
        int n2 = 0;
        while (n2 < n) {
            String[] platform = stringArray[n2];
            allSupportedPlatformsFilter.append(String.format("(& (os=%s) (arch=%s))", platform[1], platform[2]));
            ++n2;
        }
        return allSupportedPlatformsFilter.append(")").toString();
    }

    private static class PlatformMap
    extends MapMap<String, String, Set<String>> {
        public PlatformMap() {
            super(new LinkedHashMap(8));
        }

        @Override
        protected Map<String, Set<String>> createMap() {
            return new LinkedHashMap<String, Set<String>>(8);
        }

        public void add(String ws, String os, List<String> architectures) {
            Set set = (Set)this.get(ws, os);
            if (set == null) {
                this.put(ws, os, new LinkedHashSet<String>(architectures));
            } else {
                set.addAll(architectures);
            }
        }

        public boolean contains(String ws, String os, String arch) {
            Set set = (Set)this.get(ws, os);
            return set == null ? false : set.contains(arch);
        }
    }
}

