/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import com.ibm.cic.common.core.cmd.CmdRepositoryUtils;
import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.definitions.LanguageCode;
import com.ibm.cic.common.core.definitions.ProfileArch;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.model.BaseEvaluationContext;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IFixCategory;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IProblemResolved;
import com.ibm.cic.common.core.model.IProblemsResolved;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.PredefinedSelectors;
import com.ibm.cic.common.core.model.internal.IdAndVersion;
import com.ibm.cic.common.core.model.internal.SelectionExpression;
import com.ibm.cic.common.core.model.utils.ContentCollection;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.PlatformFilter;
import com.ibm.cic.common.core.model.utils.PredefinedSelectorsEvaluationContext;
import com.ibm.cic.common.core.model.utils.SupportedPlatforms;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.SliceUtils;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.MapSet;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.core.utils.VersionUtil;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.StringSearch;
import com.ibm.icu.text.Transliterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public final class OfferingUtil {
    private static final Logger log = Logger.getLogger(OfferingUtil.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    private static final Version MINIMUM_IM_VERSION_WHERE_INCLUDE_TOLERANCE_WIDENING_IS_PHASED_OUT = new Version(1, 3, 4000);
    private static Transliterator upperTransliterator = null;
    private static Transliterator removeTransliterator = null;

    public static <T extends IOfferingOrFix> List<T> filterAllButLatest(Collection<T> collection) {
        LinkedHashMap<IIdentity, IOfferingOrFix> idToOof = new LinkedHashMap<IIdentity, IOfferingOrFix>();
        for (IOfferingOrFix oof : collection) {
            IIdentity id;
            IOfferingOrFix prev;
            if (oof.compareVersion(prev = (IOfferingOrFix)idToOof.get(id = oof.getIdentity())) <= 0) continue;
            idToOof.put(id, oof);
        }
        return new ArrayList(idToOof.values());
    }

    public static Set getLocaleSet(String localesCSV) {
        HashSet<String> locales = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(localesCSV, ",");
        while (tokenizer.hasMoreTokens()) {
            locales.add(tokenizer.nextToken().trim());
        }
        if (locales.contains(LanguageCode.TRADITIONAL_CHINESE_1.getId()) || locales.contains(LanguageCode.TRADITIONAL_CHINESE_2.getId())) {
            locales.add(LanguageCode.TRADITIONAL_CHINESE_1.getId());
            locales.add(LanguageCode.TRADITIONAL_CHINESE_2.getId());
        }
        return locales;
    }

    public static IOffering[] toOfferingArray(Collection offerings) {
        return offerings.toArray(new IOffering[offerings.size()]);
    }

    public static List toOfferings(IOffering[] offerings) {
        ArrayList result = new ArrayList(offerings.length);
        Util.addAll(result, offerings);
        return result;
    }

    public static String getDisplayableVersion(IOfferingOrFix offeringOrFix) {
        Information info = offeringOrFix.getInformation();
        if (info != null && info.getVersion() != null) {
            return info.getVersion();
        }
        return offeringOrFix.getVersion().toString();
    }

    public static String getOfferingOrFixLabel(IOfferingOrFix offeringOrFix) {
        return OfferingUtil.getOfferingOrFixLabel(offeringOrFix, false);
    }

    public static String getOfferingOrFixLabel(IOfferingOrFix offeringOrFix, boolean showInternalVersion) {
        String displayableVersion = OfferingUtil.getDisplayableVersion(offeringOrFix);
        String internalVersion = offeringOrFix.getVersion().toString();
        if (!showInternalVersion || displayableVersion.equals(internalVersion)) {
            return NLS.bind(Messages.OfferingUtil_offeringOrFixLable1, (Object)offeringOrFix.getName(), (Object)displayableVersion);
        }
        return NLS.bind(Messages.OfferingUtil_offeringOrFixLable2, offeringOrFix.getName(), displayableVersion, internalVersion);
    }

    public static String getOfferingOrFixLabelA(IOfferingOrFix offeringOrFix, boolean showInternalVersion) {
        String displayableVersion = OfferingUtil.getDisplayableVersion(offeringOrFix);
        String internalVersion = offeringOrFix.getVersion().toString();
        if (!showInternalVersion || displayableVersion.equals(internalVersion)) {
            return NLS.bind(Messages.OfferingUtil_offeringOrFixLable1, (Object)offeringOrFix.getName(), (Object)displayableVersion);
        }
        return NLS.bind(Messages.OfferingUtil_offeringOrFixLable2a, offeringOrFix.getName(), displayableVersion, internalVersion);
    }

    public static String getOfferingOrFixVersion(IOfferingOrFix offeringOrFix, boolean showInternalVersion) {
        String displayableVersion = OfferingUtil.getDisplayableVersion(offeringOrFix);
        String internalVersion = offeringOrFix.getVersion().toString();
        if (!showInternalVersion || displayableVersion.equals(internalVersion)) {
            return displayableVersion;
        }
        return NLS.bind(Messages.OfferingUtil_offeringOrFixInternalVersion, (Object)displayableVersion, (Object)internalVersion);
    }

    public static String getOfferingOrFixVersionA(IOfferingOrFix offeringOrFix, boolean showInternalVersion) {
        String displayableVersion = OfferingUtil.getDisplayableVersion(offeringOrFix);
        String internalVersion = offeringOrFix.getVersion().toString();
        if (!showInternalVersion || displayableVersion.equals(internalVersion)) {
            return displayableVersion;
        }
        return NLS.bind(Messages.OfferingUtil_offeringOrFixInternalVersionA, (Object)displayableVersion, (Object)internalVersion);
    }

    public static String getFeatureName(IFeature feature) {
        String name;
        Information info = feature.getInformation();
        if (info != null && (name = info.getName()) != null && name.length() != 0) {
            return name;
        }
        return feature.getIdentity().getId();
    }

    public static String getFeatureNameId(IFeature feature) {
        String name;
        Information info = feature.getInformation();
        if (info != null && (name = info.getName()) != null && name.length() != 0) {
            return NLS.bind(Messages.OfferingUtil_Feature_NameId, (Object)name, (Object)feature.getSelectorIdentity().getId());
        }
        return feature.getIdentity().getId();
    }

    public static IStatus checkUniqueFeatureIds(IOffering offering) {
        final HashMap map = new HashMap(8);
        final CicMultiStatus status = Statuses.ST.createMultiStatus();
        FeatureTreeWalker walker = new FeatureTreeWalker(){

            @Override
            protected void feature(IFeature feature) {
                IFeature prev = map.put(feature.getIdentity(), feature);
                if (prev != null) {
                    status.add(Statuses.ERROR.get(Messages.OfferingUtil_Feature_And, prev, feature));
                }
            }
        };
        walker.walk(offering);
        if (!status.isOK()) {
            status.setMessage(NLS.bind(Messages.OfferingUtil_Offering_Contains_Features_With_Duplicate_Ids, (Object)offering.getIdentity(), (Object)offering.getVersion()));
        }
        return status;
    }

    public static Set getFeatureSet(IOffering offering) {
        return new LinkedHashSet<IFeature>(Arrays.asList(OfferingUtil.getAllFeatures(offering)));
    }

    public static Map getFeatureMap(IOffering offering) {
        final LinkedHashMap featureMap = new LinkedHashMap(8);
        FeatureTreeWalker walker = new FeatureTreeWalker(){

            @Override
            protected void feature(IFeature feature) {
                featureMap.put(feature.getIdentity().getId(), feature);
            }
        };
        walker.walk(offering);
        return featureMap;
    }

    public static IFeature[] getAllFeatures(IOffering offering) {
        FeatureCollector collector = new FeatureCollector(){

            @Override
            protected boolean include(IFeatureBase featureBase) {
                return true;
            }
        };
        collector.walk(offering);
        return collector.getFeatures();
    }

    public static IFeature[] getAllFeatures(IFeatureGroup featureGroup) {
        FeatureCollector collector = new FeatureCollector(){

            @Override
            protected boolean include(IFeatureBase featureBase) {
                return true;
            }
        };
        collector.walk(featureGroup);
        return collector.getFeatures();
    }

    private static String getSupportedOS(IOfferingOrFix offering) {
        if (offering instanceof IOffering) {
            return OfferingProperty.getSupportedOS((IOffering)offering);
        }
        return "";
    }

    public static boolean explicitSpecificationOfSupportedPlatform(IOfferingOrFix offeringOrFix) {
        if (OfferingProperty.getSupportedPlatforms(offeringOrFix) != null) {
            return true;
        }
        return !OfferingUtil.getSupportedOS(offeringOrFix).isEmpty();
    }

    public static MapSet<String, String> getAllSupportedPlatforms(IOfferingOrFix offeringOrFix) {
        MapSet<String, String> supportedPlatformsMap = MapSet.newLinkedHash();
        String supportedOS = OfferingUtil.getSupportedOS(offeringOrFix);
        Set<String> supportOSList = supportedOS.isEmpty() ? SupportedPlatforms.getInstance().getOsValues() : Arrays.asList(supportedOS.split(","));
        String supportedPlatforms = OfferingProperty.getSupportedPlatforms(offeringOrFix);
        PlatformFilter spFilter = supportedPlatforms != null ? new PlatformFilter(supportedPlatforms) : null;
        LazySupports64Bits supports64Bits = new LazySupports64Bits(offeringOrFix);
        for (String os : supportOSList) {
            Set<String> allArchsList = SupportedPlatforms.getInstance().getArchValues(os);
            TreeSet<String> supportedArchs = new TreeSet<String>();
            for (String arch : allArchsList) {
                if (supportedPlatforms != null) {
                    if (!spFilter.matchesPlatform(os, arch).isOK()) continue;
                    supportedArchs.add(arch);
                    continue;
                }
                if (ProfileArch.is64bitArch(arch)) {
                    if (!supports64Bits.matches(os, arch)) continue;
                    supportedArchs.add(arch);
                    continue;
                }
                supportedArchs.add(arch);
            }
            for (String arch : supportedArchs) {
                if (!SliceUtils.checkPlatform(offeringOrFix, os, arch).isOK()) continue;
                supportedPlatformsMap.add(os, arch);
            }
        }
        return supportedPlatformsMap;
    }

    public static IFeature[] getDefaultFeatures(IOffering offering) {
        return OfferingUtil.getDefaultFeatures(ISelectionExpression.NULL_EVALUATION_CONTEXT, offering);
    }

    public static IFeature[] getDefaultFeaturesIgnoreBundles(IOffering offering) {
        return OfferingUtil.getDefaultFeatures(new BaseEvaluationContext(false, true){}, offering);
    }

    public static IFeature[] getDefaultFeatures(final ISelectionExpression.EvaluationContext context, IOffering offering) {
        FeatureCollector collector = new FeatureCollector(){

            @Override
            protected boolean include(IFeatureBase featureBase) {
                return featureBase.isSelectedByDefault(context);
            }
        };
        collector.walk(offering);
        return collector.getFeatures();
    }

    public static IFeature[] getRequiredFeatures(IOffering offering) {
        FeatureCollector collector = new FeatureCollector(){

            @Override
            protected boolean include(IFeatureBase featureBase) {
                return featureBase.isRequired();
            }
        };
        collector.walk(offering);
        return collector.getFeatures();
    }

    public static IFeature[] getVisibleFeatures(IOffering offering) {
        FeatureCollector collector = new FeatureCollector(){

            @Override
            protected boolean include(IFeatureBase featureBase) {
                return featureBase.isVisible();
            }
        };
        collector.walk(offering);
        return collector.getFeatures();
    }

    public static Set getDirectSelectors(IOffering offering, IFeature[] features) {
        LinkedHashSet<IContentSelector> directSelectors = new LinkedHashSet<IContentSelector>(features.length);
        IFeature[] iFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IFeature feature = iFeatureArray[n2];
            IContentSelector selector = feature.getSelector();
            if (selector != null) {
                directSelectors.add(selector);
            }
            ++n2;
        }
        return directSelectors;
    }

    public static IFeature getFeatureBySelectorId(IFeature[] allFeatures, String selectorId) {
        IFeature[] iFeatureArray = allFeatures;
        int n = allFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            IFeature feature = iFeatureArray[n2];
            if (selectorId.equals(feature.getSelectorIdentity().getId())) {
                return feature;
            }
            ++n2;
        }
        return null;
    }

    public static IFeature getFeatureByFeatureId(IFeature[] allFeatures, String featureId) {
        IFeature[] iFeatureArray = allFeatures;
        int n = allFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            IFeature feature = iFeatureArray[n2];
            if (featureId.equals(feature.getIdentity().getId())) {
                return feature;
            }
            ++n2;
        }
        return null;
    }

    public static Set toFeatures(IOffering offering, Set featureIds) {
        LinkedHashSet<IFeature> features = new LinkedHashSet<IFeature>(featureIds.size());
        Map featureMap = OfferingUtil.getFeatureMap(offering);
        for (String id : featureIds) {
            IFeature feature = (IFeature)featureMap.get(id);
            if (feature == null) continue;
            features.add(feature);
        }
        return features;
    }

    public static IFeature[] toFeaturesAsArray(Collection features) {
        return features.toArray(new IFeature[features.size()]);
    }

    public static Set toFeatures(IFeature[] features) {
        LinkedHashSet result = new LinkedHashSet(features.length);
        Util.addAll(result, features);
        return result;
    }

    public static IFeature[] toFeatures(IOffering offering, String featureIds) {
        return OfferingUtil.toFeaturesAsArray(OfferingUtil.toFeatureSet(offering, featureIds));
    }

    public static Set toFeatureSet(IOffering offering, String featureIds) {
        Set featureIdSet = Util.toOrderedSet(featureIds, ',', null);
        return OfferingUtil.toFeatures(offering, featureIdSet);
    }

    public static IFeature[] toFeaturesAsArray(IOffering offering, Set featureIds) {
        return OfferingUtil.toFeaturesAsArray(OfferingUtil.toFeatures(offering, featureIds));
    }

    public static IFeature[] toFeaturesByFeatureIds(IOffering offering, String featureIds) {
        IFeature[] allFeatures = OfferingUtil.getAllFeatures(offering);
        String[] featureIdsArray = featureIds.split(",");
        ArrayList<IFeature> featureList = new ArrayList<IFeature>();
        String[] stringArray = featureIdsArray;
        int n = featureIdsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            IFeature feature = OfferingUtil.getFeatureByFeatureId(allFeatures, element.trim());
            if (feature != null && !featureList.contains(feature)) {
                featureList.add(feature);
            }
            ++n2;
        }
        return OfferingUtil.toFeaturesAsArray(featureList);
    }

    public static Set toFeatureIdsFromFeatures(Collection features) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(features.size());
        for (IFeature feature : features) {
            result.add(feature.getIdentity().getId());
        }
        return result;
    }

    public static Set toSelectorsFromFeatures(Collection features) {
        LinkedHashSet<IContentSelector> entitySelectors = new LinkedHashSet<IContentSelector>(features.size());
        for (IFeature feature : features) {
            IContentSelector selector = feature.getSelector();
            if (selector == null) continue;
            entitySelectors.add(selector);
        }
        return entitySelectors;
    }

    public static IShareableEntity findOfferingShareableEntity(IOffering offering, String seId) {
        IAssembly assembly = offering.getAssembly();
        if (assembly == null) {
            return null;
        }
        ContentCollection shareableEntities = new ContentCollection(assembly);
        for (IContent o : shareableEntities) {
            IShareableEntity se;
            if (!(o instanceof IShareableEntity) || !seId.equals((se = (IShareableEntity)o).getIdentity().getId())) continue;
            return se;
        }
        return null;
    }

    public static boolean isMinimumAgentToleranceLessThan(IOfferingOrFix oof, Version version) {
        LinkedProperties properties = oof.getProperties();
        String tolerance = properties.getProperty("im.tolerance");
        if (tolerance == null && (tolerance = properties.getProperty("agent.tolerance")) == null) {
            return true;
        }
        VersionRange range = new VersionRange(tolerance);
        return range.getMinimum().compareTo(version) < 0;
    }

    public static boolean areIncludeTolerancesWidened(IOfferingOrFix oof) {
        return UserOptions.CIC_TOLERANCE_WORKAROUND.isSet() && OfferingUtil.isMinimumAgentToleranceLessThan(oof, MINIMUM_IM_VERSION_WHERE_INCLUDE_TOLERANCE_WIDENING_IS_PHASED_OUT);
    }

    public static String getDisplayableAgentMinTolerance(IOfferingOrFix offeringOrFix) {
        VersionRange agentTolerance = new VersionRange(OfferingUtil.getAgentTolerance(offeringOrFix));
        Version minimumTolerance = OfferingUtil.toExternalAgentVersion(agentTolerance.getMinimum());
        String displayableAgentMinTolerance = OfferingUtil.getDisplayableAgentTolerance(offeringOrFix, minimumTolerance);
        return displayableAgentMinTolerance;
    }

    private static String getDisplayableAgentTolerance(IOfferingOrFix offeringOrFix, Version defaultToleranceVersion) {
        LinkedProperties properties = offeringOrFix.getProperties();
        String tolerance = properties.getProperty("displayable.im.tolerance");
        if (tolerance == null && (tolerance = properties.getProperty("displayable.agent.tolerance")) == null) {
            return defaultToleranceVersion.toString();
        }
        return tolerance;
    }

    public static String getAgentTolerance(IOfferingOrFix offeringOrFix) {
        LinkedProperties properties = offeringOrFix.getProperties();
        String tolerance = properties.getProperty("im.tolerance");
        if (tolerance == null && (tolerance = properties.getProperty("agent.tolerance")) == null && (tolerance = properties.getProperty("agent.version")) == null) {
            tolerance = "[0.0,999.0)";
        }
        return tolerance;
    }

    public static Version toExternalAgentVersion(Version internal) {
        if (internal == null) {
            return internal;
        }
        return new Version(VersionUtil.toExternalVersion(internal));
    }

    private OfferingUtil() {
        assert (false) : "No instances of OfferingUtil";
    }

    public static ISelectionExpression.ISelectedByBundle[] getPrecheckBundles(IOfferingOrFix offeringOrFix, Version runningAgentVersion) {
        List versionBundles = OfferingUtil.getBundlesFromVersionBundleListStr(OfferingProperty.getPrecheckBundlesProperty(offeringOrFix));
        return OfferingUtil.getBundles(versionBundles, runningAgentVersion);
    }

    public static ISelectionExpression.ISelectedByBundle[] getPrereqBundles(IOfferingOrFix offeringOrFix) {
        List versionBundles = OfferingUtil.getBundlesFromBundleListStr(OfferingProperty.getPrereqBundlesProperty(offeringOrFix));
        return OfferingUtil.getBundles(versionBundles, null);
    }

    public static IBundleIdAndClassName[] getDependenciesBundles(IOfferingOrFix offeringOrFix) {
        String value = OfferingProperty.getDependenciesBundlesProperty(offeringOrFix);
        List versionBundles = OfferingUtil.getBundlesFromBundleListStr(value, true);
        return versionBundles.toArray(new IBundleIdAndClassName[versionBundles.size()]);
    }

    public static IBundleIdAndClassName[] getUniqueBundles(IBundleIdAndClassName[] bundles) {
        LinkedHashSet<IBundleIdAndClassName> set = new LinkedHashSet<IBundleIdAndClassName>(bundles.length);
        IBundleIdAndClassName[] iBundleIdAndClassNameArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleIdAndClassName bundle = iBundleIdAndClassNameArray[n2];
            set.add(bundle);
            ++n2;
        }
        return set.toArray(new IBundleIdAndClassName[set.size()]);
    }

    public static String[] getUniqueBundleIds(IBundleIdAndClassName[] bundles) {
        if (bundles.length == 0) {
            return CommonDef.EmptyStringArray;
        }
        LinkedHashSet<String> bundleIds = new LinkedHashSet<String>(bundles.length);
        IBundleIdAndClassName[] iBundleIdAndClassNameArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleIdAndClassName bundle = iBundleIdAndClassNameArray[n2];
            bundleIds.add(bundle.getBundleId());
            ++n2;
        }
        return bundleIds.toArray(new String[bundleIds.size()]);
    }

    private static ISelectionExpression.ISelectedByBundle[] getBundles(List versionBundles, Version runningAgentVersion) {
        ArrayList<ISelectionExpression.ISelectedByBundle> bundles = new ArrayList<ISelectionExpression.ISelectedByBundle>();
        for (VersionBundle versionBundle : versionBundles) {
            VersionRange versionRange = versionBundle.getImVersionRange();
            if (versionRange != null && !versionRange.isIncluded(runningAgentVersion)) continue;
            bundles.add(SelectionExpression.createSelectedByBundle(versionBundle.getBundleId(), versionBundle.getClassName()));
        }
        return bundles.toArray(new ISelectionExpression.ISelectedByBundle[bundles.size()]);
    }

    private static List getBundlesFromVersionBundleListStr(String str) {
        ArrayList versionBundles = new ArrayList();
        if (str != null) {
            String[] versionBundleStrs;
            String[] stringArray = versionBundleStrs = str.split(";");
            int n = versionBundleStrs.length;
            int n2 = 0;
            while (n2 < n) {
                String versionBundleStr2 = stringArray[n2];
                String versionBundleStr = versionBundleStr2.trim();
                if (versionBundleStr.length() != 0) {
                    versionBundles.addAll(OfferingUtil.getBundlesFromVersionBundleStr(versionBundleStr));
                }
                ++n2;
            }
        }
        return versionBundles;
    }

    private static List getBundlesFromVersionBundleStr(String versionBundleStr) {
        List versionBundles;
        int pos = versionBundleStr.indexOf(":");
        if (pos > 0 && pos < versionBundleStr.length()) {
            String versionRangeStr = versionBundleStr.substring(0, pos).trim();
            VersionRange imVersionRange = new VersionRange(versionRangeStr);
            if (versionRangeStr.charAt(0) != '[' && versionRangeStr.charAt(0) != '(') {
                imVersionRange = new VersionRange(imVersionRange.getMinimum(), true, imVersionRange.getMinimum(), true);
            }
            versionBundles = OfferingUtil.getBundlesFromBundleListStr(versionBundleStr.substring(pos + 1));
            for (VersionBundle versionBundle : versionBundles) {
                versionBundle.setImVersionRange(imVersionRange);
            }
        } else {
            log.error("Invalid format:" + versionBundleStr);
            versionBundles = new ArrayList();
        }
        return versionBundles;
    }

    private static List getBundlesFromBundleListStr(String bundleListStr) {
        return OfferingUtil.getBundlesFromBundleListStr(bundleListStr, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static List getBundlesFromBundleListStr(String bundleListStr, boolean requireClassName) {
        String[] bundleStrs;
        ArrayList<VersionBundle> bundles = new ArrayList<VersionBundle>();
        String[] stringArray = bundleStrs = bundleListStr.split(",");
        int n = bundleStrs.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                String bundleStr2 = stringArray[n2];
                String bundleStr = bundleStr2.trim();
                if (bundleStr.length() != 0) {
                    String[] bundleSegments = bundleStr.split(":");
                    String bundleId = null;
                    String className = null;
                    switch (bundleSegments.length) {
                        case 1: {
                            if (requireClassName) {
                                log.error("Invalid format, class name required:" + bundleStr);
                                break block8;
                            } else {
                                bundleId = bundleSegments[0];
                                break;
                            }
                        }
                        case 2: {
                            bundleId = bundleSegments[0];
                            className = bundleSegments[1];
                            break;
                        }
                        default: {
                            log.error("Invalid format:" + bundleStr);
                            break block8;
                        }
                    }
                    bundles.add(new VersionBundle(bundleId, className));
                }
            }
            ++n2;
        }
        return bundles;
    }

    public static IOffering getBaseOffering(IRepositoryGroup group, IOffering offering) {
        IOffering baseOfferingIterator = offering;
        IOffering baseOffering = null;
        while (baseOfferingIterator != null && baseOffering != baseOfferingIterator) {
            baseOffering = baseOfferingIterator;
            baseOfferingIterator = UpdateOfferingUtils.getBaseOffering(baseOfferingIterator, group, (IProgressMonitor)new NullProgressMonitor());
        }
        return baseOffering;
    }

    public static IStatus supportsConsoleMode(IOffering offering) {
        if (OfferingProperty.supportsConsoleMode(offering)) {
            return Status.OK_STATUS;
        }
        return Statuses.ERROR.get(6551, Messages.Offering_DoesNotSupportConsoleMode, offering.getName(), OfferingUtil.getDisplayableVersion(offering), offering.getVersion().toString());
    }

    public static boolean offeringMatchesIdVersion(IOffering offering, String offeringIdVersion) {
        IdAndVersion iav = CmdRepositoryUtils.splitPackageIdVersion(offeringIdVersion);
        if (!iav.getIdentity().getId().equals(offering.getIdentity().getId())) {
            return false;
        }
        return iav.getVersion() == null || offering.getVersion().equals((Object)iav.getVersion());
    }

    public static boolean isFeatureRequired(IFeatureBase fBase) {
        IFeatureGroup parent = fBase.getParent();
        if (parent == null) {
            return fBase.isRequired();
        }
        return fBase.isRequired() && OfferingUtil.isFeatureRequired(parent);
    }

    public static String getPackageIdVersion(IOfferingOrFix offeringOrFix) {
        return String.valueOf(offeringOrFix.getIdentity().getId()) + "_" + offeringOrFix.getVersion().toString();
    }

    public static Collection<IInstallableUnit> getOfferingIUs(IOfferingOrFix offering, LinkedProperties predefines) {
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>();
        List children = offering.getChildren();
        Map overridesMap = PredefinedSelectors.makeOverridesMap(predefines, true);
        for (Object child : children) {
            IInstallableUnit iu;
            ISelectionExpression expr;
            IStatus s;
            if (!(child instanceof IInstallableUnit) || !(s = (expr = (iu = (IInstallableUnit)child).getExpression()).evaluate(new PredefinedSelectorsEvaluationContext(overridesMap))).isOK() && s.getSeverity() != 1) continue;
            ius.add(iu);
        }
        return ius;
    }

    private static Transliterator getUpperTransliterator() {
        if (upperTransliterator == null) {
            upperTransliterator = Transliterator.getInstance((String)"Any-Upper");
        }
        return upperTransliterator;
    }

    private static Transliterator getRemoveTransliterator() {
        if (removeTransliterator == null) {
            removeTransliterator = Transliterator.getInstance((String)"[:Punctuation:] Remove");
        }
        return removeTransliterator;
    }

    private static boolean searchTextIn(String targetString, String searchText) {
        if (targetString == null || targetString.length() == 0) {
            return false;
        }
        if (searchText == null) {
            return false;
        }
        if (searchText.length() == 0) {
            return true;
        }
        if (targetString.toUpperCase().indexOf(searchText.toUpperCase()) >= 0) {
            return true;
        }
        String normalizedTargetString = OfferingUtil.getUpperTransliterator().transform(targetString);
        normalizedTargetString = OfferingUtil.getRemoveTransliterator().transform(normalizedTargetString);
        String normalizedSearchText = OfferingUtil.getUpperTransliterator().transform(searchText);
        normalizedSearchText = OfferingUtil.getRemoveTransliterator().transform(normalizedSearchText);
        StringCharacterIterator target = new StringCharacterIterator(normalizedTargetString);
        try {
            RuleBasedCollator rbc = (RuleBasedCollator)Collator.getInstance();
            if (Locale.getDefault().getLanguage().equalsIgnoreCase(Locale.GERMAN.getLanguage())) {
                rbc = new RuleBasedCollator(String.valueOf(rbc.getRules()) + "& \u00dc, UE");
            }
            rbc.setStrength(0);
            StringSearch search = new StringSearch(normalizedSearchText, (CharacterIterator)target, rbc);
            if (search.first() >= 0) {
                return true;
            }
        }
        catch (Exception e) {
            ExceptionUtil.debugLogToReview(e);
        }
        return false;
    }

    public static boolean isOfferingOrFixWithString(IOfferingOrFix offeringOrFix, String searchText) {
        return OfferingUtil.isOfferingOrFixWithString(offeringOrFix, searchText, false);
    }

    public static boolean isOfferingOrFixWithString(IOfferingOrFix offeringOrFix, String searchText, boolean searchInternalVersion) {
        if (OfferingUtil.searchTextIn(offeringOrFix.getName(), searchText)) {
            return true;
        }
        Information info = offeringOrFix.getInformation();
        if (info != null) {
            if (OfferingUtil.searchTextIn(info.getDescription(), searchText)) {
                return true;
            }
            if (OfferingUtil.searchTextIn(info.getVersion(), searchText)) {
                return true;
            }
        }
        if (searchInternalVersion && OfferingUtil.searchTextIn(offeringOrFix.getVersion().toString(), searchText)) {
            return true;
        }
        if (offeringOrFix instanceof IFix) {
            IFix fix = (IFix)offeringOrFix;
            List fixProblemsResolvedList = fix.getProblemsResolvedList();
            if (fixProblemsResolvedList.size() > 0) {
                IProblemsResolved problemsResolved = (IProblemsResolved)fixProblemsResolvedList.get(0);
                if (OfferingUtil.searchTextIn(problemsResolved.getDescription(), searchText)) {
                    return true;
                }
                List problems = problemsResolved.getProblems();
                int j = 0;
                while (j < problems.size()) {
                    IProblemResolved problem = (IProblemResolved)problems.get(j);
                    if (OfferingUtil.searchTextIn(problem.getDisplayId(), searchText)) {
                        return true;
                    }
                    if (OfferingUtil.searchTextIn(problem.getDescription(), searchText)) {
                        return true;
                    }
                    ++j;
                }
            }
            List categories = fix.getCategories();
            int i = 0;
            while (i < categories.size()) {
                IFixCategory category = (IFixCategory)categories.get(i);
                if (OfferingUtil.searchTextIn(category.getName(), searchText)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static abstract class FeatureCollector
    extends FeatureTreeWalker {
        private final List features = new ArrayList();

        @Override
        protected abstract boolean include(IFeatureBase var1);

        @Override
        protected void feature(IFeature feature) {
            this.features.add(feature);
        }

        public IFeature[] getFeatures() {
            return OfferingUtil.toFeaturesAsArray(this.features);
        }
    }

    private static abstract class FeatureTreeWalker {
        private FeatureTreeWalker() {
        }

        public void walk(IOffering offering) {
            this.featureGroup(offering.getFeatureGroup());
        }

        public void walk(IFeatureGroup featureGroup) {
            this.featureGroup(featureGroup);
        }

        protected boolean include(IFeatureBase featureBase) {
            return true;
        }

        protected void featureGroup(IFeatureGroup featureGroup) {
            for (IFeatureBase child : featureGroup.getChildren()) {
                if (!this.include(child)) continue;
                if (child instanceof IFeature) {
                    this.feature((IFeature)child);
                    continue;
                }
                if (child instanceof IFeatureGroup) {
                    this.featureGroup((IFeatureGroup)child);
                    continue;
                }
                assert (false) : "Bad child: " + child;
            }
        }

        protected abstract void feature(IFeature var1);
    }

    public static interface IBundleIdAndClassName {
        public String getBundleId();

        public String getClassName();
    }

    private static class LazySupports64Bits {
        IOffering offering = null;
        private boolean initialized = false;
        private String supports64bits;
        PlatformFilter s64Filter;

        LazySupports64Bits(IOfferingOrFix offeringOrFix) {
            if (offeringOrFix instanceof IOffering) {
                this.offering = (IOffering)offeringOrFix;
            }
        }

        private void initialize() {
            if (!this.initialized) {
                if (this.offering != null) {
                    this.supports64bits = OfferingProperty.getSupports64bits(this.offering);
                    this.s64Filter = this.supports64bits != null ? new PlatformFilter(this.supports64bits) : null;
                }
                this.initialized = true;
            }
        }

        boolean matches(String os, String arch) {
            this.initialize();
            return this.supports64bits != null && !CommonDef.False.equalsIgnoreCase(this.supports64bits) && (CommonDef.True.equalsIgnoreCase(this.supports64bits) || this.s64Filter.matchesPlatform(os, arch).isOK());
        }
    }

    private static class VersionBundle
    implements IBundleIdAndClassName {
        private VersionRange imVersionRange = null;
        private final String bundleId;
        private final String className;

        VersionBundle(String bundleId, String className) {
            this.bundleId = bundleId;
            this.className = className;
        }

        public void setImVersionRange(VersionRange imVersionRange) {
            this.imVersionRange = imVersionRange;
        }

        public VersionRange getImVersionRange() {
            return this.imVersionRange;
        }

        @Override
        public String getBundleId() {
            return this.bundleId;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bundleId == null ? 0 : this.bundleId.hashCode());
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            result = 31 * result + (this.imVersionRange == null ? 0 : this.imVersionRange.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VersionBundle other = (VersionBundle)obj;
            if (this.bundleId == null ? other.bundleId != null : !this.bundleId.equals(other.bundleId)) {
                return false;
            }
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            return !(this.imVersionRange == null ? other.imVersionRange != null : !this.imVersionRange.equals((Object)other.imVersionRange));
        }
    }
}

