/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import com.ibm.cic.common.core.artifactrepo.impl.ArtifactFormatterUtil;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.IInstallSizeInfo;
import com.ibm.cic.common.core.model.internal.Messages;
import com.ibm.cic.common.core.model.utils.InstallableUnitUtil;
import com.ibm.cic.common.core.model.utils.MaxInstallSizeInfo;
import com.ibm.cic.common.downloads.SizeInfo;
import com.ibm.cic.common.logging.Logger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Plugin;

public class MaxInstallSizeUtil {
    private static final Logger log = Logger.getLogger(MaxInstallSizeUtil.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());

    public static MaxInstallSizeInfo getMaxInstallSizeInfo(IInstallableUnit[] ius) {
        SizeInfo profileSize = new SizeInfo();
        MaxInstallSizeInfo cacheSize = new MaxInstallSizeInfo();
        MaxInstallSizeUtil.getSizeInfo(Arrays.asList(ius), profileSize, cacheSize);
        MaxInstallSizeInfo totalSize = new MaxInstallSizeInfo(profileSize);
        totalSize.add(cacheSize);
        return totalSize;
    }

    public static void getSizeInfo(Collection ius, SizeInfo profileSize, MaxInstallSizeInfo cacheSize) {
        MaxInstallSizeUtil.getSizeInfo(Collections.EMPTY_LIST, ius, profileSize, cacheSize);
    }

    public static void getSizeInfo(List haveArtifacts, Collection ius, SizeInfo profileSize, MaxInstallSizeInfo cacheSize) {
        HashSet<IArtifactKey> keys = new HashSet<IArtifactKey>(haveArtifacts.size() + 50);
        for (IArtifact artifact : haveArtifacts) {
            keys.add(artifact.getKey());
        }
        profileSize.setSizes(0L, 0L);
        cacheSize.setSizes(0L, 0L, 0L);
        TraceSizes traceSizes = new TraceSizes(profileSize, cacheSize);
        long extraActive = 0L;
        for (IInstallableUnit iu : ius) {
            IAdapterData adapterData = iu.getAdapterData();
            for (IInstallSizeInfo isi : adapterData.getInstallSizes()) {
                IArtifact artifact = isi.getArtifact();
                long installSize = MaxInstallSizeUtil.checkAndFixInstallSize(adapterData, iu, isi);
                if (artifact == null) {
                    if (!adapterData.isActive(isi)) {
                        profileSize.addInstallSize(installSize);
                        continue;
                    }
                    cacheSize.addInstallSize(installSize);
                    continue;
                }
                IArtifactKey key = artifact.getKey();
                long downloadSize = artifact.getContentInfo().getSizeInfo().getDownloadSize();
                if (!adapterData.isActive(isi) || InstallableUnitUtil.getOrderDependencies(iu).size() > 0) {
                    profileSize.addInstallSize(installSize);
                    if (!keys.contains(key)) {
                        profileSize.addDownloadSize(downloadSize);
                        cacheSize.addMaxSize(downloadSize);
                    }
                } else if (!keys.contains(key)) {
                    cacheSize.addInstallSize(installSize);
                    cacheSize.addDownloadSize(downloadSize);
                    cacheSize.addMaxSize(installSize);
                    if (adapterData.isExploded(isi) && downloadSize > extraActive) {
                        extraActive = downloadSize;
                    }
                }
                keys.add(key);
                traceSizes.logDeltas(key);
            }
        }
        cacheSize.addMaxSize(extraActive);
        traceSizes.logTotals(extraActive);
    }

    public static void subtractSizeInfo(List<IInstallableUnit> allFromIUs, SizeInfo profileSize) {
        for (IInstallableUnit iu : allFromIUs) {
            IAdapterData adapterData = iu.getAdapterData();
            for (IInstallSizeInfo isi : adapterData.getInstallSizes()) {
                long installSize = MaxInstallSizeUtil.checkAndFixInstallSize(adapterData, iu, isi);
                if (adapterData.isActive(isi)) continue;
                profileSize.subtractInstallSize(installSize);
            }
        }
        if (profileSize.getInstallSize() < 0L) {
            profileSize.setInstallSize(0L);
        }
    }

    private static long checkAndFixInstallSize(IAdapterData adapterData, IInstallableUnit iu, IInstallSizeInfo isi) {
        long installSize = isi.getInstallSize();
        if (installSize == 0L || installSize == Long.MIN_VALUE) {
            IArtifact artifact = isi.getArtifact();
            if (artifact == null) {
                log.warning(Messages.NoInternalSize2, iu, adapterData.installSizeIndexOf(isi));
                installSize = 0L;
            } else {
                IArtifactKey key = artifact.getKey();
                log.warning(Messages.NoInternalSize1, ArtifactFormatterUtil.toUserString(key));
                installSize = artifact.getContentInfo().getSizeInfo().getDownloadSize();
            }
        }
        return installSize;
    }

    private MaxInstallSizeUtil() {
    }

    private static class TraceSizes {
        private final SizeInfo profileSize;
        private final MaxInstallSizeInfo cacheSize;
        private final SizeInfo profileSizePrev;
        private final MaxInstallSizeInfo cacheSizePrev;

        public TraceSizes(SizeInfo profileSize, MaxInstallSizeInfo cacheSize) {
            this.profileSize = profileSize;
            this.cacheSize = cacheSize;
            if (log.isDebugLoggable()) {
                this.profileSizePrev = new SizeInfo(0L, 0L);
                this.cacheSizePrev = new MaxInstallSizeInfo(0L, 0L, 0L);
            } else {
                this.profileSizePrev = null;
                this.cacheSizePrev = null;
            }
        }

        public void logDeltas(IArtifactKey artifactKey) {
            if (log.isDebugLoggable()) {
                if (this.profileSizePrev.getDownloadSize() == 0L && this.cacheSizePrev.getDownloadSize() == 0L) {
                    log.debug("Artifact sizes: profile(download, install), cache(download, install, max)");
                }
                this.logSizes("Artifact " + ArtifactFormatterUtil.toUserString(artifactKey));
            }
        }

        public void logTotals(long extraActive) {
            if (log.isDebugLoggable()) {
                if (extraActive > 0L) {
                    log.debug("Extra active: {0}", Long.toString(extraActive));
                }
                this.profileSizePrev.setSizes(0L, 0L);
                this.cacheSizePrev.setSizes(0L, 0L, 0L);
                this.logSizes("Totals");
            }
        }

        private void logSizes(String name) {
            log.debug("profile({1}, {2}), cache({3}, {4}, {5}) - {0}", name, this.getProfileDownloadDelta(), this.getProfileInstallDelta(), this.getCacheDownloadDelta(), this.getCacheInstallDelta(), this.getCacheMaxDelta());
        }

        private long getProfileDownloadDelta() {
            long downloadSize = this.profileSize.getDownloadSize();
            long result = downloadSize - this.profileSizePrev.getDownloadSize();
            this.profileSizePrev.setDownloadSize(downloadSize);
            return result;
        }

        private long getProfileInstallDelta() {
            long installSize = this.profileSize.getInstallSize();
            long result = installSize - this.profileSizePrev.getInstallSize();
            this.profileSizePrev.setInstallSize(installSize);
            return result;
        }

        private long getCacheDownloadDelta() {
            long downloadSize = this.cacheSize.getDownloadSize();
            long result = downloadSize - this.cacheSizePrev.getDownloadSize();
            this.cacheSizePrev.setDownloadSize(downloadSize);
            return result;
        }

        private long getCacheInstallDelta() {
            long installSize = this.cacheSize.getInstallSize();
            long result = installSize - this.cacheSizePrev.getInstallSize();
            this.cacheSizePrev.setInstallSize(installSize);
            return result;
        }

        private long getCacheMaxDelta() {
            long maxSize = this.cacheSize.getMaxSize();
            long result = maxSize - this.cacheSizePrev.getMaxSize();
            this.cacheSizePrev.setMaxSize(maxSize);
            return result;
        }
    }
}

