/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.proxy;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingIncludes;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.proxy.IOfferingReference;
import com.ibm.cic.common.core.model.proxy.OfferingOrFixReference;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestBaseOfferingData;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestOfferingData;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestOfferingOrFixData;
import com.ibm.cic.common.core.utils.RuntimeStatusException;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.List;
import org.osgi.framework.Version;

public class OfferingReference
extends OfferingOrFixReference
implements IOfferingReference {
    private IOffering modelOffering;
    private RepositoryDigestOfferingData offeringData;

    @Override
    protected IOfferingOrFix getContentElementOrNull() {
        return this.modelOffering;
    }

    @Override
    protected IOfferingOrFix getModel() {
        return this.getModelOffering();
    }

    @Override
    public RepositoryDigestOfferingOrFixData getContentData() {
        return this.offeringData;
    }

    public OfferingReference(RepositoryDigestOfferingData offeringData) {
        this.offeringData = offeringData;
        this.modelOffering = null;
    }

    public OfferingReference(IOffering theModelOffering) {
        this.modelOffering = theModelOffering;
        this.offeringData = RepositoryDigestOfferingData.NULL;
    }

    private IOffering getModelOffering() {
        if (this.modelOffering == null) {
            IContentRepository conRep = RepositoryUtils.getContentRepository(this);
            if (conRep != null) {
                this.modelOffering = (IOffering)conRep.getElement();
                this.modelOffering.setLocation(this.offeringData.getLocation());
                conRep.performNLSupdate(this.modelOffering);
            } else {
                throw new RuntimeStatusException(Statuses.ERROR.get(Messages.Repo_OfferingContentElementCantBeFound, OfferingUtil.getOfferingOrFixLabelA(this, true), this.getRepository().getLocationStr(), this.offeringData.toString()));
            }
        }
        return this.modelOffering;
    }

    @Override
    public List<IOfferingIncludes> getIncludes() {
        return this.getModelOffering().getIncludes();
    }

    public List getFilteredFeatures(IOffering.FeatureFilter filter) {
        return this.getModelOffering().getFilteredFeatures(filter);
    }

    @Override
    public IFeatureGroup getFeatureGroup() {
        return this.getModelOffering().getFeatureGroup();
    }

    @Override
    public void setFeatureGroup(IFeatureGroup featureGroup) {
        this.getModelOffering().setFeatureGroup(featureGroup);
    }

    public boolean equals(Object obj) {
        return obj instanceof IOfferingReference && this.equalsImpl(obj);
    }

    public int hashCode() {
        return this.hashCodeImpl();
    }

    @Override
    public String getBaseOfferingDisplayVersion() {
        return this.offeringData.getBaseOfferingData().getDisplayVersion();
    }

    @Override
    public IIdentity getBaseOfferingId() {
        return this.offeringData.getBaseOfferingData().getId();
    }

    @Override
    public Version getBaseOfferingVersion() {
        return this.offeringData.getBaseOfferingData().getVersion();
    }

    @Override
    public boolean isUpdate() {
        return this.offeringData.isUpdate();
    }

    @Override
    public void setUpdate(IIdentity identity, Version baseOfferingVersion, String baseOfferingDisplayVersion) {
        this.setUpdate(new RepositoryDigestBaseOfferingData(identity, baseOfferingVersion, baseOfferingDisplayVersion));
    }

    public void setUpdate(RepositoryDigestBaseOfferingData baseOffering) {
        this.initContentData();
        this.offeringData.setBaseOfferingInfo(baseOffering);
    }

    @Override
    public void unsetUpdate() {
        this.initContentData();
        this.offeringData.setBaseOfferingInfo(RepositoryDigestBaseOfferingData.NULL);
    }

    @Override
    void initContentData() {
        if (this.offeringData == RepositoryDigestOfferingData.NULL) {
            this.offeringData = new RepositoryDigestOfferingData(this.modelOffering.getIdentity(), this.modelOffering.getVersion());
        }
    }
}

