/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.internal.BaseUnit;
import com.ibm.cic.common.core.model.internal.SelExprHelper;
import com.ibm.cic.common.core.utils.IdentityUtil;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.downloads.SizeInfo;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class InstallableUnit
extends BaseUnit
implements IInstallableUnit {
    private IInstallableUnitContainer parent;
    private VersionRange updateRange;
    private String adapterId;
    private IAdapterData adapterData;
    private SizeInfo sizeInfo;
    private ISelectionExpression expression;

    public InstallableUnit(IIdentity id, Version version) {
        super(id, version);
    }

    @Override
    public IIdentity getQualifiedId() {
        return IdentityUtil.createQualifiedId(this);
    }

    @Override
    public IInstallableUnitContainer getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IInstallableUnitContainer parent) {
        this.parent = parent;
    }

    @Override
    public String getAdapterId() {
        return this.adapterId;
    }

    @Override
    public void setAdapterId(String adapterId) {
        this.adapterId = adapterId;
    }

    @Override
    public IAdapterData getAdapterData() {
        return this.adapterData;
    }

    @Override
    public void setAdapterData(IAdapterData adapterData) {
        if (adapterData != this.adapterData) {
            if (this.adapterData != null) {
                assert (this.adapterData.getParent() == this);
                this.adapterData.setParent(null);
            }
            this.adapterData = adapterData;
            if (this.adapterData != null) {
                this.adapterData.setParent(this);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        InstallableUnit result = (InstallableUnit)super.clone();
        result.parent = null;
        if (this.adapterData != null) {
            result.adapterData = null;
            result.setAdapterData((IAdapterData)this.adapterData.clone());
        }
        if (this.properties != null) {
            result.properties = new LinkedProperties();
            result.properties.putAll(this.properties);
        }
        return result;
    }

    @Override
    public VersionRange getUpdateRange() {
        return this.updateRange;
    }

    @Override
    public void setUpdateRange(VersionRange updateRange) {
        this.updateRange = updateRange;
    }

    @Override
    public SizeInfo getSizeInfo() {
        return this.sizeInfo;
    }

    @Override
    public void setSizeInfo(SizeInfo sizeInfo) {
        this.sizeInfo = sizeInfo;
    }

    @Override
    public IContent getContent() {
        return this;
    }

    @Override
    public void setContent(IContent content) {
        Assert.isTrue((content == this ? 1 : 0) != 0, (String)"Setting content of an installable unit.");
    }

    @Override
    public ISelectionExpression getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(ISelectionExpression expr) {
        this.expression = expr;
    }

    @Override
    public boolean isExpressionReferencing(IContentSelector selector) {
        return SelExprHelper.isExpressionReferencing(this, selector);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InstallableUnit)) {
            return false;
        }
        InstallableUnit that = (InstallableUnit)obj;
        return this.getIdentity().equals(that.getIdentity()) && this.getVersion().equals((Object)that.getVersion()) && Util.equals(this.getParentId(), that.getParentId());
    }

    @Override
    public int hashCode() {
        return this.getIdentity().hashCode() ^ this.getVersion().hashCode() ^ Util.hashCode((Object)this.getParentId());
    }

    private IIdentity getParentId() {
        return this.getParent() == null ? null : this.getParent().getIdentity();
    }

    @Override
    public int compareVersion(IContent other) {
        assert (other == null || other instanceof IInstallableUnit);
        int compare = super.compareVersion(other);
        if (compare != 0 && other != null) {
            IInstallableUnitContainer thisParent = this.getParent();
            IInstallableUnitContainer otherParent = ((InstallableUnit)other).getParent();
            assert (thisParent != null && otherParent != null);
            compare = thisParent.compareVersion(otherParent);
        }
        return compare;
    }
}

