/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.downloads.IMutableContentInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.Attributes;

public class DigestAttributes {
    public static final String MD2 = "MD2";
    public static final String MD5 = "MD5";
    public static final String SHA_1 = "SHA-1";
    public static final String SHA_256 = "SHA-256";
    public static final String SHA_384 = "SHA-384";
    public static final String SHA_512 = "SHA-512";
    public static final Set<String> DIGEST_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("MD2", "MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512")));

    private DigestAttributes() {
    }

    public static boolean isDigest(String name) {
        return DIGEST_NAMES.contains(name.toUpperCase());
    }

    public static void setDigestValues(Attributes attributes, boolean useLocalName, IMutableContentInfo info) {
        int i = 0;
        while (i < attributes.getLength()) {
            String name;
            String string = name = useLocalName ? attributes.getLocalName(i) : attributes.getQName(i);
            if (DigestAttributes.isDigest(name)) {
                String value = attributes.getValue(i).trim();
                info.setDigestValue(name, value);
            }
            ++i;
        }
    }

    public static void setDigestValues(Attributes attributes, boolean useLocalName, IMutableContentInfo info, String postfix) {
        int i = 0;
        while (i < attributes.getLength()) {
            String name;
            String string = name = useLocalName ? attributes.getLocalName(i) : attributes.getQName(i);
            if (postfix != null && name.endsWith(postfix) && DigestAttributes.isDigest(name = name.substring(0, name.length() - postfix.length()))) {
                String value = attributes.getValue(i).trim();
                info.setDigestValue(name, value);
            }
            ++i;
        }
    }
}

