/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.ICicResolver;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IIncludedShareableEntity;
import com.ibm.cic.common.core.model.IIncludedSuFragment;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.adapterdata.IAdapterDataParser;
import com.ibm.cic.common.core.model.adapterdata.IAdapterDataResolver;
import com.ibm.cic.common.core.model.internal.CICParser;
import com.ibm.cic.common.core.model.internal.Feature;
import com.ibm.cic.common.core.model.internal.Messages;
import com.ibm.cic.common.core.model.internal.Util;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.Comparators;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.VersionUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class CicResolver
implements ICicResolver {
    private final CICParser parser;
    private Version metadataVersion;
    private IContent content = null;
    private final Map offerings = new TreeMap();
    private final Map fixes = new TreeMap();
    private final Map asms = new TreeMap();
    private final Map sus = new TreeMap();
    private final Map suFragments = new TreeMap();
    private final Map ius = new TreeMap();
    private final List unresolved = new LinkedList();
    private boolean adjustIncludeTolerances = false;

    public static IStatus resolve(IOfferingOrFix unresolved, List entities) {
        CicResolver resolver = new CicResolver();
        resolver.addContentCollection(entities);
        resolver.addUnresolved(unresolved);
        if (unresolved instanceof IOffering) {
            IOffering offering = (IOffering)unresolved;
            resolver.addOffering(offering);
        } else {
            IFix fix = (IFix)unresolved;
            resolver.addFix(fix);
        }
        IStatus status = resolver.resolve(false);
        if (status.matches(12)) {
            return status;
        }
        return CicResolver.resolveIUAdapterData(unresolved);
    }

    public static IStatus resolveIUAdapterData(IContent root) {
        for (String adapterId : Util.getAdapterIds()) {
            IStatus status;
            IAdapterDataParser p = Util.getAdapterDataParser(adapterId);
            IAdapterDataResolver r = (IAdapterDataResolver)p.getAdapter(IAdapterDataResolver.class);
            if (r == null || !(status = r.resolveIUAdapterData(root, (IProgressMonitor)new NullProgressMonitor())).matches(12)) continue;
            return status;
        }
        if (root instanceof IFix) {
            IFix fix = (IFix)root;
            fix.setResolved(true);
        }
        return Status.OK_STATUS;
    }

    public CicResolver(CICParser parser) {
        this.parser = parser;
    }

    public CicResolver() {
        this(null);
    }

    @Override
    public void addOffering(IOffering offering) {
        this.addUnit(this.offerings, offering);
        this.setAdjustIncludeTolerances(offering);
    }

    @Override
    public void addFix(IFix fix) {
        this.addUnit(this.fixes, fix);
        this.setAdjustIncludeTolerances(fix);
    }

    @Override
    public void addAssembly(IAssembly asm) {
        this.addUnit(this.asms, asm);
    }

    @Override
    public void addSU(IShareableUnit su) {
        this.addUnit(this.sus, su);
    }

    @Override
    public void addSuFragment(ISuFragment fragment) {
        this.addUnit(this.suFragments, fragment);
    }

    @Override
    public void addIU(IInstallableUnit iu) {
        this.content = iu;
        String key = CicResolver.getKey(iu.getQualifiedId(), iu.getVersion());
        this.ius.put(key, iu);
    }

    private void addUnit(Map map, IContent unit) {
        this.content = unit;
        String key = CicResolver.getKey(unit.getIdentity(), unit.getVersion());
        IContent old = map.put(key, unit);
        if (old != null) {
            this.addError(true, NLS.bind(Messages.CICParser_two_units_with_the_same_id, (Object)old, (Object)unit));
        }
    }

    @Override
    public Version getMetadataVersion() {
        return this.metadataVersion;
    }

    @Override
    public void setMetadataVersion(Version metadataVersion) {
        this.metadataVersion = metadataVersion;
    }

    @Override
    public Collection getOfferings() {
        return this.offerings.values();
    }

    @Override
    public Collection getFixes() {
        return this.fixes.values();
    }

    @Override
    public Collection getAssemblies() {
        return this.asms.values();
    }

    @Override
    public Collection getSUs() {
        return this.sus.values();
    }

    @Override
    public Collection getSuFragments() {
        return this.suFragments.values();
    }

    @Override
    public Collection getIUs() {
        return this.ius.values();
    }

    private Collection getAssemblies(IIdentity id, Version version) {
        LinkedList<IAssembly> result = new LinkedList<IAssembly>();
        for (IAssembly asm : this.getAssemblies()) {
            if (!asm.getIdentity().equals(id) || !asm.getVersion().equals((Object)version)) continue;
            result.add(asm);
        }
        return result;
    }

    private static Object getUnit(Map map, IIdentity id, Version version) {
        return map.get(CicResolver.getKey(id, version));
    }

    @Override
    public void addUnresolved(Object o) {
        this.unresolved.add(o);
    }

    @Override
    public IStatus resolve(boolean reportErrors) {
        for (Object o : this.unresolved) {
            if (o instanceof IIncludedShareableEntity) {
                IIncludedShareableEntity ise = (IIncludedShareableEntity)o;
                IShareableEntity se = (IShareableUnit)CicResolver.getUnit(this.sus, ise.getIdentity(), ise.getVersion());
                if (se == null) {
                    se = (IAssembly)CicResolver.getUnit(this.asms, ise.getIdentity(), ise.getVersion());
                }
                ise.setShareableEntity(se);
                this.adjustIncludeTolerances(ise);
                continue;
            }
            if (o instanceof IOfferingOrFix) {
                IOfferingOrFix offeringOrFix = (IOfferingOrFix)o;
                Collection assemblies = this.getAssemblies(offeringOrFix.getAssemblyId(), offeringOrFix.getAssemblyVersion());
                if (assemblies.size() == 0) {
                    this.addError(reportErrors, NLS.bind(Messages.CICParser_cannot_find_assembly_of, (Object)offeringOrFix.getIdentity(), (Object)offeringOrFix.getAssemblyId()));
                    continue;
                }
                if (assemblies.size() > 1) {
                    this.addError(reportErrors, NLS.bind(Messages.CICParser_found_more_than_one_match_for_assembly, (Object)offeringOrFix.getIdentity(), (Object)assemblies));
                    continue;
                }
                IContent u = (IContent)assemblies.iterator().next();
                if (!(u instanceof IAssembly)) {
                    this.addError(reportErrors, NLS.bind(Messages.CICParser_non_assembly_referenced, (Object)offeringOrFix.getIdentity(), (Object)u));
                    continue;
                }
                IAssembly asm = (IAssembly)u;
                offeringOrFix.setAssembly(asm);
                if (!(offeringOrFix instanceof IOffering)) continue;
                IOffering offering = (IOffering)offeringOrFix;
                this.resolveFeatureGroup(offering.getFeatureGroup(), asm, reportErrors);
                continue;
            }
            if (o instanceof IIncludedSuFragment) {
                IIncludedSuFragment isuf = (IIncludedSuFragment)o;
                ISuFragment fragment = (ISuFragment)CicResolver.getUnit(this.suFragments, isuf.getIdentity(), isuf.getVersion());
                if (fragment == null) {
                    this.addError(reportErrors, NLS.bind(Messages.CicResolver_errMissingSuFragment, (Object)isuf.getIdentity(), (Object)isuf.getVersion()));
                    continue;
                }
                isuf.setSuFragment(fragment);
                continue;
            }
            throw new AssertionError((Object)("don't know how to resolve: " + o));
        }
        return reportErrors && this.parser != null ? this.parser.getStatus() : Status.OK_STATUS;
    }

    private void resolveFeatureGroup(IFeatureGroup featureGroup, IAssembly assembly, boolean reportErrors) {
        if (featureGroup == null) {
            return;
        }
        this.resolveFeatureSelections(featureGroup.getFeatures(), assembly, reportErrors);
        for (IFeatureGroup group : featureGroup.getGroups()) {
            this.resolveFeatureGroup(group, assembly, reportErrors);
        }
    }

    private void resolveFeatureSelections(List features, IAssembly assembly, boolean reportErrors) {
        for (Feature feature : features) {
            IContentSelector selection = assembly.getSelector(feature.getSelectorIdentity(), false);
            if (selection != null) {
                feature.setSelector(selection);
                continue;
            }
            this.addError(reportErrors, NLS.bind(Messages.CICParser_cannot_find_selector_for_feature, (Object)feature));
        }
    }

    private static String getKey(IIdentity id, Version version) {
        return String.valueOf(id.toString()) + ' ' + (version == null ? "" : version.toString());
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        CicResolver.append(result, "offerings:", this.getOfferings());
        CicResolver.append(result, "fixes:", this.getFixes());
        CicResolver.append(result, "assemblies:", this.getAssemblies());
        CicResolver.append(result, "SUs:", this.getSUs());
        CicResolver.append(result, "IUs:", this.getIUs());
        return result.toString();
    }

    private static void append(StringBuffer sb, String label, Collection units) {
        if (units.size() > 0) {
            sb.append(label).append('\n');
            for (Object unit : units) {
                sb.append(' ').append(unit).append('\n');
            }
        }
    }

    private void addError(boolean reportErrors, String msg) {
        if (reportErrors && this.parser != null) {
            this.parser.addError(msg);
        }
    }

    @Override
    public IContent getContent() {
        return this.content;
    }

    private void addContentCollection(Collection c) {
        for (IContent element : c) {
            if (element instanceof IAssembly) {
                IAssembly asm = (IAssembly)element;
                this.addAssembly(asm);
                Iterator j = asm.getChildren().iterator();
                while (j.hasNext()) {
                    this.addUnresolved(j.next());
                }
                continue;
            }
            if (element instanceof IShareableUnit) {
                this.addSU((IShareableUnit)element);
                continue;
            }
            if (element instanceof ISuFragment) {
                this.addSuFragment((ISuFragment)element);
                continue;
            }
            if (element instanceof IInstallableUnit) {
                this.addIU((IInstallableUnit)element);
                continue;
            }
            if (element instanceof IOffering) {
                this.addOffering((IOffering)element);
                this.addUnresolved(element);
                continue;
            }
            if (!(element instanceof IFix)) continue;
            this.addFix((IFix)element);
            this.addUnresolved(element);
        }
    }

    private void setAdjustIncludeTolerances(IOfferingOrFix oof) {
        if (OfferingUtil.areIncludeTolerancesWidened(oof)) {
            this.adjustIncludeTolerances = true;
        }
    }

    private void adjustIncludeTolerances(IIncludedShareableEntity ise) {
        if (!this.adjustIncludeTolerances) {
            return;
        }
        Version version = ise.getVersion();
        VersionRange tolerance = ise.getTolerance();
        if (VersionUtil.UNSPECIFIED_TOLERANCE.equals((Object)tolerance)) {
            return;
        }
        Version minimum = Version.emptyVersion.equals((Object)version) ? tolerance.getMinimum() : version;
        VersionRange defaultTolerance = this.computeDefaultTolerance(minimum);
        if (Comparators.compare(defaultTolerance.getRight(), tolerance.getRight()) >= 0) {
            ise.setTolerance(defaultTolerance);
        }
    }

    private VersionRange computeDefaultTolerance(Version version) {
        return new VersionRange(new Version(version.getMajor(), 0, 0), true, new Version(version.getMajor() + 1, 0, 0), false);
    }
}

