/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.FeatureKind;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IBuildDataElement;
import com.ibm.cic.common.core.model.IBuilderData;
import com.ibm.cic.common.core.model.IBuilderDataOwner;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IFixApplicableOffering;
import com.ibm.cic.common.core.model.IFixCategory;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IIncludedShareableEntity;
import com.ibm.cic.common.core.model.IIncludedSuFragment;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallationContext;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingIncludes;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IProblemResolved;
import com.ibm.cic.common.core.model.IProblemsResolved;
import com.ibm.cic.common.core.model.IRequiredShareableEntity;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.ISelectionExpressionContainer;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.ISuFragmentSelector;
import com.ibm.cic.common.core.model.IncludedShareableEntitySelector;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.InstallationContextScope;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.internal.AbstractFeatureBase;
import com.ibm.cic.common.core.model.internal.ContentSelector;
import com.ibm.cic.common.core.model.internal.IFixInternal;
import com.ibm.cic.common.core.model.internal.IXMLConstants;
import com.ibm.cic.common.core.model.utils.ContentCollection;
import com.ibm.cic.common.core.model.utils.FilterCollectionUtil;
import com.ibm.cic.common.core.utils.Comparators;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.MetaInfo;
import com.ibm.cic.common.core.utils.XMLWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class CICWriter
implements IXMLConstants {
    private static final String XMLNS = "xmlns:";
    private XMLWriter xmlWriter;
    public static final int MODE_DEFAULT = 0;
    public static final int MF_NO_PIS = 1;
    public static final int MF_SE_EQUIVALENT = 2;
    public static final int MF_RELAXED_VALIDATION = 4;
    public static final int MF_INCONSISTENT_IU_VALIDATION = 8;
    private static final XMLWriter.ProcessingInstruction PI_RELAXED = new XMLWriter.ProcessingInstruction("nonstrict");
    private static final XMLWriter.ProcessingInstruction PI_METADATA_VERSION = new XMLWriter.ProcessingInstruction("metadata", MetaInfo.formatVersion(MetaInfo.METADATA_VERSION));
    private static final XMLWriter.ProcessingInstruction[] PIS_NONE = new XMLWriter.ProcessingInstruction[0];
    private static final XMLWriter.ProcessingInstruction[] PIS_DEFAULT = new XMLWriter.ProcessingInstruction[]{PI_METADATA_VERSION};
    private static final XMLWriter.ProcessingInstruction[] PIS_RELAXED = new XMLWriter.ProcessingInstruction[]{PI_METADATA_VERSION, PI_RELAXED};
    private int mode = 0;
    private boolean discardBuildData;

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setDiscardBuildData(boolean value) {
        this.discardBuildData = value;
    }

    private boolean modeMatches(int modeMask) {
        return (this.mode & modeMask) != 0;
    }

    private boolean modeMatchesNot(int modeMask) {
        return (this.mode & modeMask) == 0;
    }

    private XMLWriter.ProcessingInstruction[] getProcessingInstructions() {
        if (this.mode == 0) {
            return PIS_DEFAULT;
        }
        if (this.modeMatches(1)) {
            return PIS_NONE;
        }
        if (this.modeMatches(4)) {
            return PIS_RELAXED;
        }
        return PIS_DEFAULT;
    }

    public void write(IContent unit, File output) throws IOException {
        if (unit instanceof IInstallableUnit) {
            return;
        }
        this.writeAnyContent(unit, output);
    }

    private void writeAnyContent(IContent unit, File output) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(output);){
            this.xmlWriter = new XMLWriter((OutputStream)fos, this.getProcessingInstructions(), this.modeMatchesNot(1));
            this.write(unit);
            this.xmlWriter.flush();
        }
    }

    public void write(IContent unit, OutputStream output) {
        if (unit instanceof IInstallableUnit) {
            return;
        }
        this.writeAnyContent(unit, output);
    }

    public void writeAnyContent(IContent unit, OutputStream output) {
        this.xmlWriter = new XMLWriter(output, this.getProcessingInstructions(), this.modeMatchesNot(1));
        this.write(unit);
        this.xmlWriter.flush();
    }

    public static String toXML(CICWriter cicw, IContent content) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(250);
        cicw.xmlWriter = new XMLWriter((OutputStream)output, cicw.getProcessingInstructions(), cicw.modeMatchesNot(1));
        if (content instanceof IInstallableUnit) {
            IInstallableUnit iu = (IInstallableUnit)content;
            cicw.write(iu);
        } else if (content instanceof IOffering) {
            IOffering offering = (IOffering)content;
            cicw.write(offering, true);
        } else if (content instanceof IFix) {
            IFix fix = (IFix)content;
            cicw.write(fix, true);
        } else {
            cicw.write(content);
        }
        cicw.xmlWriter.flush();
        return Encodings.UTF8.toString(output);
    }

    public static String toXML(CICWriter cicw, IContentSelector sel) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(250);
        cicw.xmlWriter = new XMLWriter((OutputStream)output, cicw.getProcessingInstructions(), cicw.modeMatchesNot(1));
        cicw.write(sel);
        cicw.xmlWriter.flush();
        return Encodings.UTF8.toString(output);
    }

    public static String toXML(CICWriter cicw, IRequiredShareableEntity rse) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(250);
        cicw.xmlWriter = new XMLWriter((OutputStream)output, cicw.getProcessingInstructions(), cicw.modeMatchesNot(1));
        cicw.write(rse);
        cicw.xmlWriter.flush();
        return Encodings.UTF8.toString(output);
    }

    public static String toXML(CICWriter cicw, IIncludedShareableEntity ise) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(250);
        cicw.xmlWriter = new XMLWriter((OutputStream)output, cicw.getProcessingInstructions(), cicw.modeMatchesNot(1));
        cicw.write(ise);
        cicw.xmlWriter.flush();
        return Encodings.UTF8.toString(output);
    }

    public static String toXML(CICWriter cicw, ISelectionExpression expr) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(250);
        cicw.xmlWriter = new XMLWriter((OutputStream)output, cicw.getProcessingInstructions(), cicw.modeMatchesNot(1));
        cicw.write(expr);
        cicw.xmlWriter.flush();
        return Encodings.UTF8.toString(output);
    }

    public static String toXMLIncludedSelectors(CICWriter cicw, IIncludedShareableEntity ise) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(250);
        cicw.xmlWriter = new XMLWriter((OutputStream)output, cicw.getProcessingInstructions(), cicw.modeMatchesNot(1));
        cicw.writeIncludedShareableEntitySelectors(ise);
        cicw.xmlWriter.flush();
        return Encodings.UTF8.toString(output);
    }

    public void writeOffering(IOffering offering, File outputFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            this.writeOffering(offering, fos);
        }
    }

    public void writeOffering(IOffering offering, OutputStream fos) {
        this.xmlWriter = new XMLWriter(fos, this.getProcessingInstructions(), this.modeMatchesNot(1));
        this.write(offering, true);
        this.xmlWriter.flush();
    }

    public void writeFix(IFix fix, File outputFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            this.writeFix(fix, fos);
        }
    }

    public void writeFix(IFix fix, OutputStream fos) {
        this.xmlWriter = new XMLWriter(fos, this.getProcessingInstructions(), this.modeMatchesNot(1));
        this.write(fix, true);
        this.xmlWriter.flush();
    }

    private void write(IContent unit) {
        if (unit instanceof IOffering) {
            this.write((IOffering)unit, false);
        } else if (unit instanceof IFix) {
            this.write((IFix)unit, true);
        } else if (unit instanceof IAssembly) {
            this.write((IAssembly)unit);
        } else if (unit instanceof IInstallationContext) {
            this.write((IInstallationContext)unit);
        } else if (unit instanceof IShareableUnit) {
            this.write((IShareableUnit)unit);
        } else if (unit instanceof ISuFragment) {
            this.write((ISuFragment)unit);
        } else {
            if (unit instanceof IInstallableUnit) {
                return;
            }
            throw new AssertionError((Object)("unexpected unit type: " + unit));
        }
    }

    private void write(IOffering x, boolean includeChildren) {
        IFeatureGroup featureGroup;
        this.start("offering");
        this.attribute("id", x.getIdentity());
        this.attribute("version", x.getVersion());
        this.attribute("assemblyId", x.getAssemblyId());
        this.attribute("assemblyVersion", x.getAssemblyVersion());
        if (x.hasChildren() && x.getChildren().size() > 0) {
            this.attribute("iuCount", x.getChildren().size());
        }
        if ((featureGroup = x.getFeatureGroup()) != null) {
            this.write(featureGroup);
        }
        this.writeIncludes(x.getIncludes());
        this.writeOfferingOrFix(x, includeChildren);
        this.end();
    }

    private void writeIncludes(List<IOfferingIncludes> includesList) {
        if (includesList.isEmpty()) {
            return;
        }
        this.start("includes");
        for (IOfferingIncludes includes : includesList) {
            this.start("profile");
            this.attribute("id", includes.getProfileId());
            this.attribute("dir", includes.getProfileDir());
            for (IOfferingIncludes.IOfferingInProfile include : includes.getOfferingsInProfile()) {
                this.start("offering");
                this.attribute("kind", (Object)include.getKind());
                this.attribute("id", include.getIdentity());
                this.attribute("minVersion", include.getMinVersion());
                this.attribute("maxVersion", include.getMaxVersion());
                this.start("information");
                this.attribute("name", include.getName());
                this.attribute("minVersion", include.getMinUserVersion());
                this.attribute("maxVersion", include.getMaxUserVersion());
                this.end();
                this.end();
            }
            this.end();
        }
        this.end();
    }

    private void write(IFix x, boolean includeChildren) {
        this.start("fix");
        this.attribute("id", x.getIdentity());
        this.attribute("version", x.getVersion());
        if (!x.isEnhancedFix()) {
            this.attribute("offeringId", ((IFixInternal)((Object)x)).getInternalOfferingId());
            this.attribute("offeringVersion", ((IFixInternal)((Object)x)).getInternalOfferingVersion());
        }
        this.attribute("assemblyId", x.getAssemblyId());
        this.attribute("assemblyVersion", x.getAssemblyVersion());
        if (x.hasChildren() && x.getChildren().size() > 0) {
            this.attribute("iseCount", x.getChildren().size());
        }
        if (x.isEnhancedFix()) {
            this.writeApplicability(x);
            this.writeCategories(x);
        }
        this.writeOfferingOrFix(x, includeChildren);
        this.end();
    }

    private void writeApplicability(IFix x) {
        this.start("applicability");
        List list = x.getApplicableOfferings();
        for (IFixApplicableOffering ao : list) {
            this.start("offering");
            this.attribute("id", ao.getIdentity());
            this.attribute("tolerance", ao.getTolerance());
            this.end();
        }
        this.end();
    }

    private void writeCategories(IFix x) {
        this.start("categories");
        List categories = x.getCategories();
        for (IFixCategory category : categories) {
            this.start("category");
            this.attribute("id", category.getId());
            this.attribute("name", category.getNameKey());
            this.end();
        }
        this.end();
    }

    private void writeOfferingOrFix(IOfferingOrFix x, boolean includeChildren) {
        this.checkWriteBuildData(x);
        this.write(x.getInformation());
        this.write(x.getProperties(), x.getPropertyKeys());
        this.writeAll(x.getInstallableUnits());
        this.writeResolves(x);
        IAssembly assembly = x.getAssembly();
        if (includeChildren && assembly != null) {
            this.writeAll(new ContentCollection(assembly, x.getProperties(), false, null));
        }
    }

    private void writeResolves(IOfferingOrFix x) {
        List list = x.getProblemsResolvedList();
        if (list.isEmpty()) {
            return;
        }
        IProblemsResolved problemsResolved = (IProblemsResolved)list.get(0);
        if (x instanceof IFix) {
            this.writeResolvedProblemsByFix(problemsResolved);
        } else if (x instanceof IOffering) {
            this.writeResolvedProblemsByOffering(problemsResolved);
        }
    }

    private void writeResolvedProblemsByOffering(IProblemsResolved problemsResolved) {
        this.start("resolves");
        List problems = problemsResolved.getProblems();
        this.attribute("problemCount", problems.size());
        for (IProblemResolved problem : problems) {
            this.writeProblem(problem);
        }
        this.end();
    }

    private void writeResolvedProblemsByFix(IProblemsResolved problemsResolved) {
        this.start("resolves");
        List problems = problemsResolved.getProblems();
        this.attribute("problemCount", problems.size());
        this.attribute("description", problemsResolved.getDescriptionKey());
        this.attribute("showList", problemsResolved.showList(), false);
        for (IProblemResolved problem : problems) {
            this.writeProblem(problem);
        }
        this.end();
    }

    private void writeProblem(IProblemResolved problem) {
        this.start("problem");
        this.attribute("id", problem.getId());
        this.attribute("displayId", problem.getDisplayId());
        this.attribute("description", problem.getDescriptionKey());
        this.attribute("hide", problem.isHidden(), false);
        this.end();
    }

    private Collection sortIfFixMode(Collection collection, Comparator cmp) {
        if (this.modeMatches(2)) {
            ArrayList sorted = new ArrayList(collection);
            if (cmp != null) {
                Collections.sort(sorted, cmp);
            } else {
                Collections.sort(sorted);
            }
            return sorted;
        }
        return collection;
    }

    private Version getVersionByMode(Version v) {
        if (this.modeMatches(2)) {
            return new Version(v.getMajor(), v.getMinor(), v.getMicro(), "qualifier");
        }
        return v;
    }

    private VersionRange getToleranceByMode(VersionRange r) {
        if (this.modeMatches(2)) {
            return new VersionRange(this.getVersionByMode(r.getMinimum()), r.getIncludeMinimum(), r.getRight(), r.getIncludeMaximum());
        }
        return r;
    }

    private void writeAll(Collection units) {
        for (Object unit : units) {
            if (unit instanceof IInstallableUnit) {
                this.write((IInstallableUnit)unit);
                continue;
            }
            if (unit instanceof IContent) {
                this.write((IContent)unit);
                continue;
            }
            if (unit instanceof IContentSelector) {
                this.write((IContentSelector)unit);
                continue;
            }
            if (unit instanceof IFeature) {
                this.write((IFeature)unit);
                continue;
            }
            if (unit instanceof IFeatureGroup) {
                this.write((IFeatureGroup)unit);
                continue;
            }
            if (unit instanceof IncludedShareableEntitySelector) {
                this.write((IncludedShareableEntitySelector)unit);
                continue;
            }
            if (unit instanceof IIncludedShareableEntity) {
                this.write((IIncludedShareableEntity)unit);
                continue;
            }
            if (unit instanceof IRequiredShareableEntity) {
                this.write((IRequiredShareableEntity)unit);
                continue;
            }
            if (unit instanceof IIncludedSuFragment) {
                this.write((IIncludedSuFragment)unit);
                continue;
            }
            if (unit instanceof ISuFragmentSelector) {
                this.write((ISuFragmentSelector)unit);
                continue;
            }
            assert (false) : unit;
        }
    }

    private void write(IAssembly x) {
        this.start("assembly");
        this.attribute("id", x.getIdentity());
        this.attribute("version", this.getVersionByMode(x.getVersion()));
        this.attribute("visible", x.isVisible(), true);
        if (x.hasChildren() && x.getChildren().size() > 0) {
            this.attribute("seCount", x.getChildren().size());
        }
        this.checkWriteBuildData(x);
        this.write(x.getInformation());
        this.write(x.getProperties());
        this.writeAll(this.sortIfFixMode(x.getSelectors(), Comparators.CONTENT_SELECTOR));
        List children = x.getChildren();
        this.writeAll(this.sortIfFixMode(FilterCollectionUtil.filter((Collection)children, IIncludedShareableEntity.class), Comparators.ISE_COMPARATOR));
        this.writeAll(this.sortIfFixMode(FilterCollectionUtil.filter((Collection)children, IIncludedSuFragment.class), Comparators.ISUF_COMPARATOR));
        this.end();
    }

    private void write(IInstallationContext ic) {
        this.write((IShareableUnit)ic);
    }

    private void writeInstallContextSpecific(IInstallationContext ic) {
        this.attribute("installContext", true, false);
        this.attribute("shareable", ic.isShareable(), true);
        this.attribute("qualifiable", ic.isQualifiable(), false);
        if (ic.getScope() != InstallationContextScope.NONE_SCOPE) {
            this.attribute("scope", ic.getScope());
        }
        if (ic.getAdaptorTypes().length > 0) {
            this.attribute("adapters", ic.getAdaptorTypesImage());
        }
    }

    private void write(IShareableUnit x) {
        this.start("su");
        this.attribute("id", x.getIdentity());
        this.attribute("version", this.getVersionByMode(x.getVersion()));
        this.attribute("visible", x.isVisible(), true);
        if (x.hasChildren() && x.getChildren().size() > 0) {
            this.attribute("iuCount", x.getChildren().size());
        }
        if (x.definesAnInstallationContext() && x instanceof IInstallationContext) {
            this.writeInstallContextSpecific((IInstallationContext)x);
        }
        this.checkWriteBuildData(x);
        this.write(x.getInformation());
        this.write(x.getProperties());
        this.writeAll(this.sortIfFixMode(x.getSelectors(), Comparators.CONTENT_SELECTOR));
        this.writeAll(this.sortIfFixMode(x.getChildren(), Comparators.CONTENT_COMPARATOR));
        this.end();
    }

    private void write(ISuFragment x) {
        this.start("suFragment");
        this.attribute("id", x.getIdentity());
        this.attribute("version", this.getVersionByMode(x.getVersion()));
        this.attribute("targetSuId", x.getTargetId());
        this.attribute("targetSuTolerance", this.getToleranceByMode(x.getTargetTolerance()));
        this.attribute("strict", x.isStrict(), false);
        if (x.hasChildren() && x.getChildren().size() > 0) {
            this.attribute("iuCount", x.getChildren().size());
        }
        this.checkWriteBuildData(x);
        this.write(x.getInformation());
        this.write(x.getProperties());
        this.writeAll(this.sortIfFixMode(x.getSelectors(), Comparators.SU_FRAGMENT_SELECTOR));
        this.writeAll(this.sortIfFixMode(x.getInstallableUnits(), Comparators.CONTENT_COMPARATOR));
        this.end();
    }

    private void write(IInstallableUnit x) {
        this.start("iu");
        this.attribute("id", x.getIdentity());
        this.attribute("version", x.getVersion());
        this.attribute("adapterId", x.getAdapterId());
        VersionRange updateRange = x.getUpdateRange();
        if (updateRange != null) {
            this.attribute("updateRange", updateRange);
        }
        this.checkWriteBuildData(x);
        this.write(x.getInformation());
        this.write(x.getProperties());
        this.write(x.getExpression());
        this.start("adapterSpecificData");
        IAdapterData data = x.getAdapterData();
        if (data != null) {
            this.xmlWriter.cdataLines(data.toXML(this.modeMatches(10)), false);
        }
        this.end();
        this.end();
    }

    private void write(Information x) {
        if (x == null) {
            return;
        }
        this.start("information");
        this.attribute("name", x.getNameKey());
        this.attribute("version", x.getVersionKey());
        this.attribute("provider", x.getProviderKey());
        String description = x.getDescriptionKey();
        if (description != null) {
            this.xmlWriter.cdataLines(description, true);
        }
        this.end();
    }

    private void write(IContentSelector x) {
        this.start("selector");
        this.attribute("id", x.getIdentity());
        if (x.isInternal()) {
            this.attribute("internal", x.isInternal());
        }
        this.checkWriteBuildData(x);
        this.write(x.getInformation());
        this.write(x.getExpression());
        Collection sorted = this.sortIfFixMode(x.getInternalSelections(), Comparators.CONTENT_SELECTOR);
        for (ContentSelector contentSelector : sorted) {
            this.start("internalSelection");
            this.attribute("id", contentSelector.getIdentity());
            this.end();
        }
        this.writeAll(this.sortIfFixMode(x.getRequiredShareableEntities(), Comparators.RSE_COMPARATOR));
        this.end();
    }

    private void write(ISuFragmentSelector x) {
        this.start("selector");
        this.attribute("id", x.getIdentity());
        this.checkWriteBuildData(x);
        this.write(x.getInformation());
        this.write(x.getExpression());
        Collection sorted = this.sortIfFixMode(x.getInternalSelections(), Comparators.CONTENT_SELECTOR);
        for (ISuFragmentSelector selector : sorted) {
            this.start("internalSelection");
            this.attribute("id", selector.getIdentity());
            this.end();
        }
        this.end();
    }

    private void write(IRequiredShareableEntity x) {
        this.start("requiredShareableEntity");
        this.attribute("shareableId", x.getShareableId());
        this.attribute("tolerance", x.getTolerance());
        this.attribute("installContext", x.requiresInstallationContext(), false);
        this.checkWriteBuildData(x);
        Collection sorted = this.sortIfFixMode(x.getSelectorIds(), Comparators.IDENTITY);
        for (IIdentity id : sorted) {
            this.start("requiredSelector");
            this.attribute("selectorId", id);
            this.end();
        }
        this.end();
    }

    private void write(ISelectionExpression expr) {
        if (expr == null) {
            return;
        }
        this.write(expr, true);
    }

    private void write(ISelectionExpression expr, boolean isRoot) {
        if (expr instanceof ISelectionExpression.ISelectedById) {
            ISelectionExpression.ISelectedById e = (ISelectionExpression.ISelectedById)expr;
            this.start("selectedBy");
            this.attribute("id", e.getId());
            this.end();
        } else if (expr instanceof ISelectionExpression.ISelectedByPredefinedId) {
            ISelectionExpression.ISelectedByPredefinedId e = (ISelectionExpression.ISelectedByPredefinedId)expr;
            this.start("selectedBy");
            this.attribute("id", e.getId());
            String value = e.getValue();
            if (value != null && value.length() > 0) {
                this.attribute("value", value);
            }
            this.end();
        } else if (expr instanceof ISelectionExpression.ISelectedByBundle) {
            ISelectionExpression.ISelectedByBundle e = (ISelectionExpression.ISelectedByBundle)expr;
            this.start("selectedByBundle");
            this.attribute("id", e.getBundleId());
            this.attribute("class", e.getClassName());
            this.end();
        } else if (expr instanceof ISelectionExpression.ISelectedByTarget) {
            ISelectionExpression.ISelectedByTarget e = (ISelectionExpression.ISelectedByTarget)expr;
            this.start("selectedByTarget");
            this.attribute("id", e.getTargetId());
            this.end();
        } else if (expr instanceof ISelectionExpression.ISelectedByOperator) {
            if (isRoot) {
                this.start("selectedByExpression");
            }
            ISelectionExpression.ISelectedByOperator e = (ISelectionExpression.ISelectedByOperator)expr;
            ISelectionExpression.ISelectionOperator operator = e.getOperator();
            this.start(operator.getOpImage());
            if (operator instanceof ISelectionExpression.IUnarySelectionOperator) {
                ISelectionExpression.IUnarySelectionOperator op = (ISelectionExpression.IUnarySelectionOperator)operator;
                this.write(op.getOperand(), false);
            } else if (operator instanceof ISelectionExpression.IBinarySelectionOperator) {
                ISelectionExpression[] operands;
                ISelectionExpression.IBinarySelectionOperator op = (ISelectionExpression.IBinarySelectionOperator)operator;
                this.attribute("shortCircuit", op.isShortCircuit(), true);
                ISelectionExpression[] iSelectionExpressionArray = operands = op.getOperands();
                int n = operands.length;
                int n2 = 0;
                while (n2 < n) {
                    ISelectionExpression operand = iSelectionExpressionArray[n2];
                    this.write(operand, false);
                    ++n2;
                }
            } else {
                throw new AssertionError(operator);
            }
            this.end();
            if (isRoot) {
                this.end();
            }
        } else if (expr != ISelectionExpression.TRUE && expr != ISelectionExpression.FALSE) {
            throw new AssertionError(expr);
        }
    }

    private void write(IIncludedSuFragment suFragment) {
        this.start("includedSuFragment");
        this.attribute("id", suFragment.getIdentity());
        this.attribute("version", this.getVersionByMode(suFragment.getVersion()));
        this.checkWriteBuildData(suFragment);
        this.write(suFragment.getExpression());
        this.end();
    }

    private void write(IIncludedShareableEntity x) {
        this.start("includedShareableEntity");
        this.attribute("id", x.getIdentity());
        if (!this.modeMatches(2)) {
            this.attribute("version", x.getVersion());
        }
        this.attribute("tolerance", this.getToleranceByMode(x.getTolerance()));
        this.checkWriteBuildData(x);
        this.writeIncludedShareableEntitySelectors(x);
        this.end();
    }

    private void writeIncludedShareableEntitySelectors(IIncludedShareableEntity x) {
        this.writeAll(this.sortIfFixMode(x.getIncludedShareableEntitySelectors(), Comparators.ISES_COMPARATOR));
    }

    private void write(IncludedShareableEntitySelector x) {
        this.start("includedSelector");
        this.attribute("selectorId", x.getSelectorId());
        this.checkWriteBuildData(x);
        this.write(x.getExpression());
        this.end();
    }

    private void write(IFeatureGroup x) {
        this.start("featureGroup");
        this.attribute("kind", x.getKind().getName());
        this.attribute("exclusive", x.hasMutuallyExclusiveChildren(), false);
        this.checkWriteBuildData(x);
        this.write(x.getInformation());
        this.writeFeatureApplicabiltyExpr(x);
        this.writeFeatureKindExpr(x);
        this.writeAll(x.getChildren());
        this.end();
    }

    private void write(IFeature x) {
        this.start("feature");
        this.attribute("id", x.getIdentity());
        this.attribute("selectionId", x.getSelectorIdentity());
        this.attribute("kind", x.getKind().getName());
        this.checkWriteBuildData(x);
        this.write(x.getInformation());
        this.writeFeatureApplicabiltyExpr(x);
        this.writeFeatureKindExpr(x);
        this.end();
    }

    private void writeFeatureApplicabiltyExpr(IFeatureBase x) {
        if (x instanceof ISelectionExpressionContainer) {
            this.write(((ISelectionExpressionContainer)((Object)x)).getExpression());
        }
    }

    private void writeFeatureKindExpr(IFeatureBase x) {
        AbstractFeatureBase featureOrGroup;
        if (FeatureKind.DYNAMICALLY_SELECTED.equals(x.getKind()) && x instanceof AbstractFeatureBase && (featureOrGroup = (AbstractFeatureBase)x).hasKindExpression()) {
            this.start("kind");
            this.checkWriteBuildData(x);
            this.write(featureOrGroup.getKindExpression());
            this.end();
        }
    }

    private void checkWriteBuildData(Object cicObject) {
        IBuilderData[] data;
        if (!this.discardBuildData && cicObject instanceof IBuilderDataOwner && (data = ((IBuilderDataOwner)cicObject).getBuilderData()) != null) {
            IBuilderData[] iBuilderDataArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                IBuilderData element = iBuilderDataArray[n2];
                this.writeBuilderData(element);
                ++n2;
            }
        }
    }

    private void writeBuilderData(IBuildDataElement data) {
        if (!this.discardBuildData) {
            IBuildDataElement[] children;
            String[] attrs;
            this.start(data.getPersistedName());
            if (data instanceof IBuilderData) {
                this.attribute("xmlns:build", "http://www.ibm.com/cic/build");
            }
            String[] stringArray = attrs = data.getAttributeNames();
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                String val = data.getAttribute(attr);
                if (val != null) {
                    this.attribute(attr, val);
                }
                ++n2;
            }
            IBuildDataElement[] iBuildDataElementArray = children = data.getChildren();
            int n3 = children.length;
            n = 0;
            while (n < n3) {
                IBuildDataElement element = iBuildDataElementArray[n];
                this.writeBuilderData(element);
                ++n;
            }
            this.end();
        }
    }

    private void start(String name) {
        this.xmlWriter.start(name);
    }

    private void end() {
        this.xmlWriter.end();
    }

    private void attribute(String name, boolean value, boolean defaultValue) {
        this.xmlWriter.attribute(name, value, defaultValue);
    }

    private void attribute(String name, int value) {
        this.xmlWriter.attribute(name, value);
    }

    private void attribute(String name, Object value) {
        this.xmlWriter.attribute(name, value);
    }

    private void write(LinkedProperties x, Map xKeys) {
        this.xmlWriter.write(x, xKeys);
    }

    private void write(LinkedProperties x) {
        this.xmlWriter.write(x);
    }
}

