/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model;

import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;

public class PredefinedSelectors {
    public static final String OS = "os";
    public static final String OS_VERSION = "os_version";
    public static final String ARCH = "arch";
    public static final String WS = "ws";
    public static final String NL = "nl";
    public static final String ACCESS_RIGHTS = "accessRights";
    public static final String IS_BETA = "isBeta";
    public static final String PORTABLE = "portable";
    public static final String[] SEL_IDs = new String[]{"os", "os_version", "arch", "ws", "nl", "accessRights", "isBeta", "portable"};
    private static final String PROP_NAME_PREFIX = "cic.selector.";
    public static final String PROP_NAME_OS = "cic.selector.os";
    public static final String PROP_NAME_OS_VERSION = "cic.selector.os_version";
    public static final String PROP_NAME_ARCH = "cic.selector.arch";
    public static final String PROP_NAME_WS = "cic.selector.ws";
    public static final String PROP_NAME_NL = "cic.selector.nl";
    public static final String PROP_NAME_ACCESS_RIGHTS = "cic.selector.accessRights";
    public static final String PROP_NAME_IS_BETA = "cic.selector.isBeta";
    public static final String PROP_NAME_PORTABLE = "cic.selector.portable";
    private static final String[] PROP_NAMES = new String[]{"cic.selector.os", "cic.selector.os_version", "cic.selector.arch", "cic.selector.ws", "cic.selector.nl", "cic.selector.accessRights", "cic.selector.isBeta", "cic.selector.portable"};
    public static final String OS_VERSION_WIN32_VISTA = "win32_vista";
    public static final String MATCH_ANY_VALUE = "*";
    public static final String DONT_MATCH_VALUE = "";
    public static final String VARIABLE_PREFIX = "${";
    private static Map predefineds;
    private static final char VALUE_SEP = ',';

    static {
        HashMap<String, String> map = new HashMap<String, String>(SEL_IDs.length, 1.0f);
        map.put(OS, CicCommonSettings.getOs());
        map.put(OS_VERSION, CicCommonSettings.isWindowsVista() ? OS_VERSION_WIN32_VISTA : DONT_MATCH_VALUE);
        map.put(ARCH, CicCommonSettings.getArch());
        map.put(WS, CicCommonSettings.getWs());
        map.put(NL, CicCommonSettings.getNl());
        map.put(ACCESS_RIGHTS, CicCommonSettings.getAccessRightsMode().toString());
        map.put(IS_BETA, Boolean.toString(CicCommonSettings.isBeta()));
        map.put(PORTABLE, Boolean.toString(CicCommonSettings.isPortable()));
        Assert.isTrue((map.size() == SEL_IDs.length ? 1 : 0) != 0, (String)"Wrong number of predefineds");
        predefineds = Collections.unmodifiableMap(map);
    }

    public static boolean contains(String selIdStr) {
        return predefineds.containsKey(selIdStr);
    }

    public static boolean matches(String selIdStr, String selValStr) {
        String value = PredefinedSelectors.valueOf(selIdStr);
        if (selIdStr.equals(IS_BETA) && selValStr == null) {
            return value != null && value.equals("true");
        }
        if (selIdStr.equals(ARCH) && value != null && value.equals("sparcv9") && selValStr.equals("sparc64")) {
            return true;
        }
        if (selIdStr.equals(ARCH) && value != null && value.equals("sparc64") && selValStr.equals("sparcv9")) {
            return true;
        }
        return value != null && value.equals(selValStr) || NL.equals(selIdStr) && PredefinedSelectors.matchesNL(value, selValStr);
    }

    private static boolean matchesNL(String expected, String given) {
        return expected != null && given != null && expected.startsWith(given);
    }

    public static boolean matchesNL(String selIdStr, Set values, String given) {
        if (NL.equals(selIdStr)) {
            for (String expected : values) {
                if (!PredefinedSelectors.matchesNL(expected, given)) continue;
                return true;
            }
        }
        return false;
    }

    public static Collection getIDs() {
        return predefineds.keySet();
    }

    public static String valueOf(String selIdStr) {
        return (String)predefineds.get(selIdStr);
    }

    public static LinkedProperties collectOverrides(LinkedProperties owned, LinkedProperties inherited) {
        LinkedProperties base = new LinkedProperties();
        LinkedProperties overridden = new LinkedProperties();
        String[] stringArray = PROP_NAMES;
        int n = PROP_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String value = owned.getProperty(element);
            if (value != null) {
                overridden.setProperty(element, value);
            } else {
                value = inherited.getProperty(element);
                if (value != null) {
                    base.setProperty(element, value);
                }
            }
            ++n2;
        }
        if (overridden.isEmpty()) {
            if (base.isEmpty()) {
                return null;
            }
            return base;
        }
        for (Map.Entry entry : base.entrySet()) {
            if (overridden.containsKey(entry.getKey())) continue;
            overridden.put(entry.getKey(), entry.getValue());
        }
        overridden.putAll(base);
        return overridden;
    }

    public static Map makeOverridesMap(Map map) {
        if (map.isEmpty() || map.equals(predefineds)) {
            return null;
        }
        return map;
    }

    public static Map makeOverridesMap(Map properties, boolean enableIfNotOverridden) {
        if (properties == null) {
            if (enableIfNotOverridden) {
                properties = new LinkedProperties();
            } else {
                return null;
            }
        }
        int overridesCount = 0;
        HashMap<String, Set> map = new HashMap<String, Set>(predefineds.size(), 1.0f);
        int i = 0;
        while (i < PROP_NAMES.length) {
            String overrides;
            String defaultValue = enableIfNotOverridden ? MATCH_ANY_VALUE : PredefinedSelectors.valueOf(SEL_IDs[i]);
            Object value = properties.get(PROP_NAMES[i]);
            String string = overrides = value == null ? defaultValue : value;
            if (!defaultValue.equals(overrides)) {
                ++overridesCount;
            }
            map.put(SEL_IDs[i], PredefinedSelectors.makeSet(overrides, defaultValue));
            ++i;
        }
        if (overridesCount == 0 && !enableIfNotOverridden) {
            return null;
        }
        return map;
    }

    private static Set makeSet(String overrides, String defaultValue) {
        if ((overrides = overrides.trim()).equals(MATCH_ANY_VALUE)) {
            return Collections.singleton(MATCH_ANY_VALUE);
        }
        boolean includeDefaultValue = false;
        String plus = "+";
        if (overrides.startsWith("+")) {
            if ((overrides = overrides.substring(1)).length() == 0) {
                return Collections.singleton(defaultValue);
            }
            includeDefaultValue = true;
        }
        Set set = null;
        set = "solaris".equals(Platform.getOS()) && (overrides.equals("sparcv9") || overrides.equals("sparc64")) ? Util.toOrderedSet("sparcv9,sparc64", ',', includeDefaultValue ? defaultValue : null) : Util.toOrderedSet(overrides, ',', includeDefaultValue ? defaultValue : null);
        return set;
    }

    public static Map elements() {
        return predefineds;
    }

    public static Map fixMap(Map map) {
        LinkedHashMap result = new LinkedHashMap(map);
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            result.put(entry.getKey(), Collections.singleton(value));
        }
        return result;
    }

    public static boolean isVariable(String idStr) {
        return idStr != null && idStr.startsWith(VARIABLE_PREFIX);
    }
}

