/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model;

import com.ibm.cic.common.core.model.internal.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FeatureKind {
    private static final int TRAIT_NONE = 0;
    private static final int TRAIT_REQUIRED = 1;
    private static final int TRAIT_VISIBLE = 2;
    private static final int TRAIT_SELECTED_BY_DEFAULT = 4;
    private static final ArrayList featureKinds = new ArrayList();
    private static int nextOrdinal = 0;
    public static final FeatureKind NOT_A_FEATURE_KIND = new FeatureKind("NotAValidFeatureKind", Messages.FeatureKind_NotAFeatureKind, 0);
    public static final FeatureKind REQUIRED_VISIBLE = new FeatureKind("RequiredAndVisible", Messages.FeatureKind_RequiredAndVisible, 7);
    public static final FeatureKind REQUIRED_NOT_VISIBLE = new FeatureKind("RequiredAndNotVisible", Messages.FeatureKind_RequiredAndNotVisible, 5);
    public static final FeatureKind OPTIONAL_SELECTED = new FeatureKind("SelectedByDefault", Messages.FeatureKind_SelectedByDefault, 6);
    public static final FeatureKind OPTIONAL_NOT_SELECTED = new FeatureKind("NotSelectedByDefault", Messages.FeatureKind_NotSelectedByDefault, 2);
    public static final FeatureKind DYNAMICALLY_SELECTED = new FeatureKind("SelectedByExpression", Messages.FeatureKind_SelectedByExpression, 2);
    public static final FeatureKind OPTIONAL_SELECTED_NOT_VISIBLE = new FeatureKind("SelectedAndNotVisible", Messages.FeatureKind_SelectedAndNotVisible, 4);
    private final transient String displayName;
    private final transient String name;
    private final int ordinal;
    private final int traits;

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public final int getOrdinal() {
        return this.ordinal;
    }

    public boolean isRequired() {
        return this.hasTrait(1);
    }

    public boolean isVisible() {
        return this.hasTrait(2);
    }

    public boolean isSelectedByDefault() {
        return this.hasTrait(4);
    }

    public String toString() {
        return this.getName();
    }

    public static FeatureKind nameToFeatureKind(String s) {
        for (FeatureKind nextFeature : FeatureKind.getFeatureKinds()) {
            if (!nextFeature.name.equals(s)) continue;
            return nextFeature;
        }
        return NOT_A_FEATURE_KIND;
    }

    public static FeatureKind valueToFeatureKind(int value) {
        return value >= 0 && value < featureKinds.size() ? (FeatureKind)featureKinds.get(value) : NOT_A_FEATURE_KIND;
    }

    public static List getFeatureKinds() {
        return Collections.unmodifiableList(featureKinds);
    }

    private boolean hasTrait(int trait) {
        return (this.traits & trait) == trait;
    }

    protected FeatureKind(String name, String displayName, int traits) {
        this.name = name;
        this.displayName = displayName;
        this.ordinal = nextOrdinal++;
        this.traits = traits;
        featureKinds.add(this.ordinal, this);
    }
}

