/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.volrepo;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationUtil;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.DiskUtil;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactGet;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.internal.volrepo.Messages;
import com.ibm.cic.common.core.internal.volrepo.VolumeAtocUtil;
import com.ibm.cic.common.core.internal.volrepo.VolumeSetReader;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.volrepo.VolumesArtifactTableOfContents;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class VolumeArtifactRepository
implements IReadArtifactRepo,
IArtifactGet,
IVolumeAccessByDisk {
    private final String location;

    public VolumeArtifactRepository(String location) {
        this.location = location;
    }

    @Override
    public abstract IRepository getRepository();

    public abstract VolumeSetReader getVolumeSetReader();

    private VolumeAtocUtil.OrderedDisks determineUsedDisks(IArtifactSession session, final IVolumeAccessByDisk.IDiskOperation diskOperation, IMultiArtifactOperationArguments artifactArgs, IProgressMonitor monitor) {
        VolumeAtocUtil.OrderedDisks usedDisks;
        VolumeSetReader vsr = this.getVolumeSetReader();
        try {
            usedDisks = vsr.getUsedDisks(session, new ArtifactArgsCollection(new ArtifactArgsCollection.IGetArtifactAdapter(){

                @Override
                public IArtifact getArtifact(IArtifactOperation.IArtifactOperationRecord record) {
                    return diskOperation.getArtifact(record);
                }
            }, artifactArgs), monitor);
        }
        catch (CoreException e) {
            artifactArgs.setFailedOperationStatus(e.getStatus());
            return null;
        }
        catch (IOException e) {
            IStatus status = AbstractReadArtifactRepo.createGetArtifactFilesFailedOperationError(this.getLocation(), null, (Exception)e);
            artifactArgs.setFailedOperationStatus(status);
            return null;
        }
        return usedDisks;
    }

    @Override
    public IVolumeAccessByDisk.IDiskSet[] getDiskSets(IArtifactSession session, IProgressMonitor monitor) throws CoreException, IOException {
        IVolumeAccessByDisk.IDiskSet[] diskSetsWithCount = DiskUtil.getDiskSetsWithCount(this, session, monitor);
        return diskSetsWithCount;
    }

    public static boolean hasPackage(IRepository repo, IArtifactSession session, IOfferingOrFix pkg, IProgressMonitor monitor) {
        IFix fix;
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (pkg instanceof IOffering) {
            IOffering offering = repo.findOffering(pkg.getIdentity(), pkg.getVersion(), (IProgressMonitor)sm.newChild(1));
            if (offering != null) {
                return true;
            }
            offering = repo.findUpdate(pkg.getIdentity(), pkg.getVersion(), (IProgressMonitor)sm.newChild(1));
            if (offering != null) {
                return true;
            }
        } else if (pkg instanceof IFix && (fix = repo.findFix(pkg.getIdentity(), pkg.getVersion(), (IProgressMonitor)sm.newChild(1))) != null) {
            return true;
        }
        sm.setWorkRemaining(0);
        return false;
    }

    @Override
    public IVolumeAccessByDisk.IDiskSet[] getPackageDiskSets(IArtifactSession session, IOfferingOrFix pkg, IProgressMonitor monitor) throws CoreException, IOException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (VolumeArtifactRepository.hasPackage(this.getRepository(), session, pkg, (IProgressMonitor)sm.newChild(1))) {
            return this.getDiskSets(session, (IProgressMonitor)sm.newChild(1));
        }
        sm.setWorkRemaining(0);
        return new IVolumeAccessByDisk.IDiskSet[0];
    }

    private String getDiskSetId() {
        VolumeSetReader vsr = this.getVolumeSetReader();
        String id = vsr.getDiskTagProperties().getProperty("diskSetId");
        return id;
    }

    public void visitArtifactsOnDisk(IArtifactSession session, IVolumeAccessByDisk.IDiskSet[] diskSets, Collection artifacts, IVolumeAccessByDisk.IArtifactOnDiskCallback aodCallback, IProgressMonitor monitor) throws CoreException, IOException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            String diskSetId = this.getDiskSetId();
            boolean doIterate = true;
            if (diskSets != null) {
                doIterate = false;
                IVolumeAccessByDisk.IDiskSet[] iDiskSetArray = diskSets;
                int n = diskSets.length;
                int n2 = 0;
                while (n2 < n) {
                    IVolumeAccessByDisk.IDiskSet diskSetToConsider = iDiskSetArray[n2];
                    if (diskSetToConsider.getId().equals(diskSetId)) {
                        doIterate = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!doIterate) {
                return;
            }
            VolumeSetReader vsr = this.getVolumeSetReader();
            VolumeAtocUtil datoc = vsr.getVolumeArtifactToc(session, (IProgressMonitor)sm.newChild(1));
            ArrayList outArtifactsNotOnDisks = new ArrayList();
            datoc.artifactsOnDisks(session, artifacts, aodCallback, outArtifactsNotOnDisks, (IProgressMonitor)sm.newChild(1));
            for (IArtifact artifact : outArtifactsNotOnDisks) {
                aodCallback.notOnAnyDisk(artifact);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean disksAvailable(IArtifactSession session, IVolumeAccessByDisk.IDiskSetDisks idisks, IProgressMonitor monitor) {
        VolumeSetReader vsr = this.getVolumeSetReader();
        try {
            IVolumeAccessByDisk.IDisk disk;
            List<IVolumeAccessByDisk.IDisk> disks = idisks.getDisks();
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, disks.size());
            Iterator<IVolumeAccessByDisk.IDisk> iterator = disks.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (vsr.isDiskAvailable(disk = iterator.next(), spm.next()));
            return false;
        }
        catch (CoreException e) {
            return false;
        }
    }

    @Override
    public boolean canFindAvailableDisks() {
        VolumeSetReader vsr = this.getVolumeSetReader();
        return vsr.canFindAvailableDisks();
    }

    @Override
    public void useArtifactLocatorsInOrder(IArtifactSession session, IVolumeAccessByDisk.IDiskOperation diskOperation, IMultiArtifactOperationArguments artifactArgs, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)130);
        try {
            VolumeAtocUtil.OrderedDisks usedDisks = this.determineUsedDisks(session, diskOperation, artifactArgs, (IProgressMonitor)sm.newChild(20));
            if (usedDisks == null || usedDisks.size() == 0) {
                return;
            }
            VolumeSetReader vsr = this.getVolumeSetReader();
            IMultiArtifactOperationArguments records = artifactArgs;
            int subRepoIndex = 0;
            sm.setWorkRemaining(usedDisks.size());
            Iterator iter = usedDisks.iterator();
            while (iter.hasNext()) {
                IVolumeAccessByDisk.IDisk disk = (IVolumeAccessByDisk.IDisk)iter.next();
                IMultiArtifactOperationArguments artifactsOnDisk = this.determineArtifactsOnDisk(session, diskOperation, usedDisks, artifactArgs, disk, (IProgressMonitor)sm.newChild(2));
                vsr.useArtifactLocatorsOnDisk(session, diskOperation, artifactsOnDisk, options, usedDisks, disk, subRepoIndex, (IProgressMonitor)sm.newChild(1));
                artifactArgs.setFailedOperationStatus(artifactsOnDisk.getFailedOperationStatus());
                if (artifactArgs.getFailedOperationStatus().matches(12)) {
                    return;
                }
                IMultiArtifactOperationArguments outstandingRecords = MultiArtifactOperationUtil.returnOutstanding(diskOperation.getOperation(), records, iter.hasNext());
                if (outstandingRecords.getRecords().isEmpty()) {
                    return;
                }
                records = outstandingRecords;
                ++subRepoIndex;
            }
        }
        finally {
            monitor.done();
        }
    }

    private IMultiArtifactOperationArguments determineArtifactsOnDisk(IArtifactSession session, IVolumeAccessByDisk.IDiskOperation diskOperation, VolumeAtocUtil.OrderedDisks usedDisks, IMultiArtifactOperationArguments records, IVolumeAccessByDisk.IDisk disk, IProgressMonitor monitor) {
        VolumeSetReader vsr = this.getVolumeSetReader();
        monitor.beginTask("", records.getRecordCount());
        String task_determine_artifacts_on_disk = NLS.bind((String)Messages.task_determine_artifacts_on_disk, (Object)disk.getDiskNumber());
        monitor.subTask(task_determine_artifacts_on_disk);
        try {
            IMultiArtifactOperationArguments artifactsOnDisk = diskOperation.getOperation().createArguments();
            for (IArtifactOperation.IArtifactOperationRecord element : records.getRecords()) {
                VolumesArtifactTableOfContents.DiskInfo diskInfo;
                IArtifactOperation.IArtifactOperationRecord dlRecord = element;
                IArtifact artifact = diskOperation.getArtifact(dlRecord);
                if (artifact == null) continue;
                try {
                    diskInfo = vsr.getDiskInfo(session, artifact, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                }
                catch (CoreException e) {
                    monitor.worked(1);
                    continue;
                }
                catch (IOException e) {
                    monitor.worked(1);
                    continue;
                }
                try {
                    if (diskInfo == null || diskInfo.getDiskNum() != disk.getDiskNumber()) continue;
                    artifactsOnDisk.addRecord(dlRecord);
                }
                finally {
                    monitor.worked(1);
                }
            }
            IMultiArtifactOperationArguments iMultiArtifactOperationArguments = artifactsOnDisk;
            return iMultiArtifactOperationArguments;
        }
        finally {
            monitor.done();
        }
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public boolean canGetLocatorsFromDisk1(IProgressMonitor monitor) {
        VolumeSetReader vsr = this.getVolumeSetReader();
        return vsr.assumeAllDisksAvailable();
    }

    @Override
    public IStatus existsArtifact(IArtifactSession session, IArtifact artifact, IProgressMonitor monitor) {
        VolumeSetReader vsr = this.getVolumeSetReader();
        return vsr.existsArtifact(session, artifact, monitor);
    }

    @Override
    public IStatus getArtifactLocator(IArtifactSession session, IArtifact artifact, IProgressMonitor monitor, IArtifactLocator[] result) {
        VolumeSetReader vsr = this.getVolumeSetReader();
        return vsr.getArtifactLocator(session, artifact, monitor, result);
    }

    @Override
    public IStatus getArtifactFile(IArtifactSession session, IArtifact artifact, IPath destination, IProgressMonitor monitor) {
        VolumeSetReader vsr = this.getVolumeSetReader();
        return vsr.getArtifactFile(session, artifact, destination, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readCachedArtifactToc(IArtifactSession session, IPath tocCache, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IReadArtifactRepo.IArtifactTocCapabilities getArtifactTocCapabilities() {
        return IReadArtifactRepo.IArtifactTocCapabilities.NOT_SUPPORTED;
    }

    @Override
    public boolean hasArtifactToc(IArtifactSession session, IProgressMonitor monitor) {
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IReadArtifactRepo.class) {
            return this;
        }
        if (adapter == IArtifactGet.class) {
            return this;
        }
        if (adapter == IVolumeAccessByDisk.class) {
            return this;
        }
        return null;
    }

    static class ArtifactArgsCollection
    extends AbstractCollection {
        IGetArtifactAdapter getArtifactAdapter;
        IMultiArtifactOperationArguments args;

        ArtifactArgsCollection(IGetArtifactAdapter getArtifactAdapter, IMultiArtifactOperationArguments args) {
            this.getArtifactAdapter = getArtifactAdapter;
            this.args = args;
        }

        @Override
        public Iterator iterator() {
            return new Iter(this.getArtifactAdapter, this.args.getRecords().iterator());
        }

        @Override
        public int size() {
            return this.args.getRecordCount();
        }

        static interface IGetArtifactAdapter {
            public IArtifact getArtifact(IArtifactOperation.IArtifactOperationRecord var1);
        }

        static class Iter
        implements Iterator {
            IGetArtifactAdapter getArtifactAdapter;
            Iterator recordIterator;

            Iter(IGetArtifactAdapter getArtifactAdapter, Iterator recordIterator) {
                this.getArtifactAdapter = getArtifactAdapter;
                this.recordIterator = recordIterator;
            }

            @Override
            public boolean hasNext() {
                return this.recordIterator.hasNext();
            }

            public Object next() {
                Object obj = this.recordIterator.next();
                if (obj instanceof IArtifactOperation.IArtifactOperationRecord) {
                    IArtifactOperation.IArtifactOperationRecord record = (IArtifactOperation.IArtifactOperationRecord)obj;
                    return this.getArtifactAdapter.getArtifact(record);
                }
                throw new AssertionError();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class DiskSetDisks
    implements IVolumeAccessByDisk.IDiskSetDisks {
        private final IVolumeAccessByDisk.IDiskSet diskSet;
        private final VolumeAtocUtil.OrderedDisks used;
        private DiskSetDisks notUsedDisks;

        public DiskSetDisks(IVolumeAccessByDisk.IDiskSet diskSet, VolumeAtocUtil.OrderedDisks used) {
            assert (diskSet != null);
            assert (used != null);
            this.diskSet = diskSet;
            this.used = used;
            this.notUsedDisks = null;
        }

        @Override
        public IVolumeAccessByDisk.IDiskSet getDiskSet() {
            return this.diskSet;
        }

        @Override
        public List<IVolumeAccessByDisk.IDisk> getDisks() {
            return this.used;
        }

        @Override
        public void addDisk(IVolumeAccessByDisk.IDisk disk) {
            this.used.addDisk(disk);
            this.notUsedDisks = null;
        }

        @Override
        public int[] getDiskNumbers() {
            return this.used.getDiskNumbers();
        }

        @Override
        public boolean isAllDisks() {
            return this.used.size() == this.diskSet.getDiskCount();
        }

        @Override
        public IVolumeAccessByDisk.IDiskSetDisks getOtherDisks() {
            if (this.notUsedDisks == null) {
                VolumeAtocUtil.OrderedDisks disks = this.used.getOthers(this.diskSet);
                this.notUsedDisks = new DiskSetDisks(this.diskSet, disks);
            }
            return this.notUsedDisks;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("disks=");
            sb.append(VolumeAtocUtil.OrderedDisks.arraysToString(this.used.getDiskNumbers()));
            sb.append(" on diskSet=");
            sb.append(this.diskSet);
            return sb.toString();
        }
    }
}

