/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.volrepo;

import com.ibm.cic.common.core.downloads.TransferUtils;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.volrepo.IDiskMounter;
import com.ibm.cic.common.core.internal.volrepo.Messages;
import com.ibm.cic.common.core.internal.volrepo.MountedDisk;
import com.ibm.cic.common.core.internal.volrepo.SimulatedRemoveableMountPoint;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.volrepo.DiskTagFile;
import com.ibm.cic.common.core.volrepo.IVolumeRepositoryStatusCodes;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class DiskMountUtil
implements IVolumeRepositoryStatusCodes {
    private static String pluginId = ComIbmCicCommonCorePlugin.getPluginId();
    public static final Logger log = Logger.getLogger(IDiskMounter.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());

    private static IStatus createStatusBadDiskTagFile(ICicLocation crootDir) {
        String msg = NLS.bind(Messages.DiskMount_bad_disk_tag_file, (Object)crootDir);
        return new Status(4, pluginId, 13, msg, null);
    }

    /*
     * Loose catch block
     */
    private static IStatus doMountDisk(ICicLocation crootDir, IDiskMounter.IMountedDisk[] out) {
        int diskNumber;
        DiskTagFile.DiskTagProperties dtp;
        InputStream is = null;
        try {
            URL url = crootDir.append("diskTag.inf").toURL();
            is = TransferUtils.getValidatedStreamForURLDirectForFiles(url, null);
            dtp = DiskTagFile.load(is);
        }
        catch (FileNotFoundException e) {
            String msg = NLS.bind(Messages.DiskMount_failed_no_disk_tag_file, (Object)crootDir);
            Status status = new Status(4, pluginId, 12, msg, (Throwable)e);
            FileUtil.close(is);
            return status;
        }
        catch (CoreException e) {
            block17: {
                if (!e.getStatus().matches(8)) break block17;
                IStatus iStatus = e.getStatus();
                FileUtil.close(is);
                return iStatus;
            }
            String msg = NLS.bind(Messages.DiskMount_reading_disk_tag_file_failed, (Object)crootDir);
            CicMultiStatus cicMultiStatus = Statuses.ST.createMultiStatus(13, e.getStatus(), msg, new Object[0]);
            FileUtil.close(is);
            return cicMultiStatus;
        }
        catch (IOException e) {
            String msg = NLS.bind(Messages.DiskMount_reading_disk_tag_file_failed, (Object)crootDir);
            ICicStatus iCicStatus = Statuses.ERROR.get(13, e, msg, new Object[0]);
            {
                catch (Throwable throwable) {
                    FileUtil.close(is);
                    throw throwable;
                }
            }
            FileUtil.close(is);
            return iCicStatus;
        }
        FileUtil.close(is);
        String foundDiskSetId = dtp.getProperty("diskSetId");
        if (foundDiskSetId == null || foundDiskSetId.length() == 0) {
            String id = dtp.getProperty("diskSetOfferingId");
            if (id == null || id.length() == 0) {
                return DiskMountUtil.createStatusBadDiskTagFile(crootDir);
            }
            String v = dtp.getProperty("diskSetOfferingVersion");
            if (v == null || v.length() == 0) {
                return DiskMountUtil.createStatusBadDiskTagFile(crootDir);
            }
            dtp.setProperty("diskSetId", String.valueOf(id) + '_' + v);
        }
        try {
            diskNumber = dtp.getDiskNumber();
        }
        catch (NumberFormatException nfe) {
            return DiskMountUtil.createStatusBadDiskTagFile(crootDir);
        }
        catch (Throwable t) {
            ExceptionUtil.log.error(t);
            throw new AssertionError();
        }
        if (diskNumber <= 0) {
            return DiskMountUtil.createStatusBadDiskTagFile(crootDir);
        }
        if (out != null) {
            out[0] = new MountedDisk(dtp, crootDir);
        }
        return Status.OK_STATUS;
    }

    public static IStatus mountNextDisk(ICicLocation diskLocation, IDiskMounter.IMountedDisk lastDisk, Integer expectedDiskIndex, IDiskMounter.IMountedDisk[] refMountedDisk, boolean[] refIsNewDisk) {
        IDiskMounter.IMountedDisk[] out = new IDiskMounter.IMountedDisk[1];
        IStatus status = DiskMountUtil.doMountDisk(diskLocation, out);
        if (status.matches(12)) {
            return status;
        }
        status = DiskMountUtil.validateDisk(diskLocation, lastDisk, out[0], expectedDiskIndex, refIsNewDisk);
        if (status.isOK() && refMountedDisk != null) {
            refMountedDisk[0] = out[0];
        }
        return status;
    }

    public static IStatus mountInitialDisk(ICicLocation diskLocation, String expectedDiskSetId, Integer expectedDiskIndex, IDiskMounter.IMountedDisk[] refMountedDisk) {
        IDiskMounter.IMountedDisk[] out = new IDiskMounter.IMountedDisk[1];
        IStatus status = DiskMountUtil.doMountDisk(diskLocation, out);
        if (status.matches(12)) {
            return status;
        }
        status = DiskMountUtil.validateDisk(diskLocation, out[0], expectedDiskSetId, expectedDiskIndex);
        if (status.isOK() && refMountedDisk != null) {
            refMountedDisk[0] = out[0];
        }
        return status;
    }

    public static IStatus ensureMountedDisk(IDiskMounter.IMountedDisk previousDisk, Integer expectedDiskIndex, IDiskMounter.IMountedDisk[] refMountedDisk, boolean[] refIsNewDisk) {
        assert (refMountedDisk != null && refMountedDisk.length == 1);
        IStatus status = DiskMountUtil.doMountDisk(previousDisk.getRoot(), refMountedDisk);
        if (status.matches(12)) {
            return status;
        }
        return DiskMountUtil.validateDisk(previousDisk.getRoot(), previousDisk, refMountedDisk[0], expectedDiskIndex, refIsNewDisk);
    }

    public static IStatus validateDisk(ICicLocation diskLocation, IDiskMounter.IMountedDisk lastDisk, IDiskMounter.IMountedDisk newDisk, Integer expectedDiskIndex, boolean[] refIsNewDisk) {
        String foundVersion;
        String expectedVersion;
        String string = expectedVersion = lastDisk != null ? lastDisk.getDiskLayoutVersion() : null;
        if (expectedVersion != null && !expectedVersion.equals(foundVersion = newDisk.getDiskLayoutVersion())) {
            String msg = NLS.bind(Messages.DiskMount_wrong_disk_layout_version, newDisk.getRoot(), expectedVersion, foundVersion);
            return new Status(4, pluginId, 16, msg, null);
        }
        String expectedDiskSetId = lastDisk != null ? lastDisk.getDiskSetId() : null;
        IStatus status = DiskMountUtil.validateDisk(diskLocation, newDisk, expectedDiskSetId, expectedDiskIndex);
        if (!status.isOK()) {
            return status;
        }
        if (lastDisk == null || expectedDiskIndex != null && lastDisk.getDiskIndex() != expectedDiskIndex.intValue()) {
            log.debug(newDisk);
            if (refIsNewDisk != null) {
                refIsNewDisk[0] = true;
            }
        } else if (refIsNewDisk != null) {
            refIsNewDisk[0] = false;
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateDisk(ICicLocation diskLocation, IDiskMounter.IMountedDisk newDisk, String expectedDiskSetId, Integer expectedDiskIndex) {
        int foundDiskIndex;
        String foundDiskSetId;
        if (expectedDiskSetId != null && !expectedDiskSetId.equals(foundDiskSetId = newDisk.getDiskSetId())) {
            String msg = NLS.bind(Messages.DiskMount_wrong_disk_set_id, (Object)expectedDiskSetId, (Object)foundDiskSetId);
            return new Status(4, pluginId, 15, msg, null);
        }
        if (expectedDiskIndex != null && (foundDiskIndex = newDisk.getDiskIndex()) != expectedDiskIndex) {
            String msg = NLS.bind(Messages.DiskMount_wrong_disk_num, (Object)(expectedDiskIndex + 1), (Object)(foundDiskIndex + 1));
            return new Status(4, pluginId, 15, msg, null);
        }
        return Status.OK_STATUS;
    }

    public static boolean isSimulatedMountPoint(ICicLocation currentRoot) {
        boolean onRemovableMedia;
        SimulatedRemoveableMountPoint.ISimulatedRemoveableMountPoint smp = SimulatedRemoveableMountPoint.getCallback();
        return smp != null && (onRemovableMedia = smp.isSimultatedRemoveableMountPoint(currentRoot));
    }
}

