/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.repository;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.IRepositoryRef;
import com.ibm.cic.common.core.repository.RepositorySiteProperties;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestRepositoryData;
import com.ibm.cic.common.core.repository.listeners.IRepositoryPropertyEventListener;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.UserNames;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class RepositoryRef
implements IRepositoryRef {
    private IRepository referredRepository;
    private int referenceCount = 0;

    public RepositoryRef(IRepository repo) {
        this.setReferencedRepository(repo);
    }

    @Override
    public String getName() {
        return this.referredRepository.getName();
    }

    @Override
    public String getType() {
        return this.referredRepository.getType();
    }

    @Override
    public String getVersion() {
        return this.referredRepository.getVersion();
    }

    @Override
    public boolean isWritable() {
        return this.referredRepository.isWritable();
    }

    @Override
    public void setName(String name) {
        this.referredRepository.setName(name);
    }

    @Override
    public void refresh() {
        this.referredRepository.refresh();
    }

    @Override
    public IContent refreshContent(IContent content) {
        return this.referredRepository.refreshContent(content);
    }

    @Override
    public IRepository getRepository() {
        return this.referredRepository;
    }

    @Override
    public List getAllOfferings(IProgressMonitor progressMonitor) {
        return this.referredRepository.getAllOfferings(progressMonitor);
    }

    @Override
    public List getAllOfferings(boolean includeUnavailable, IProgressMonitor progressMonitor) {
        return this.referredRepository.getAllOfferings(includeUnavailable, progressMonitor);
    }

    @Override
    public List getAllUpdates(IIdentity offeringId, Version offeringVersion, IProgressMonitor progressMonitor) {
        return this.referredRepository.getAllUpdates(offeringId, offeringVersion, progressMonitor);
    }

    @Override
    public List getAllUpdates(boolean includeUnavailable, IIdentity offeringId, Version offeringVersion, IProgressMonitor progressMonitor) {
        return this.referredRepository.getAllUpdates(includeUnavailable, offeringId, offeringVersion, progressMonitor);
    }

    @Override
    public IStatus unsetUpdateOffering(IOffering updateOffering) {
        return this.referredRepository.unsetUpdateOffering(updateOffering);
    }

    @Override
    public List getAllFixes(IProgressMonitor progressMonitor) {
        return this.referredRepository.getAllFixes(progressMonitor);
    }

    @Override
    public List getAllFixes(boolean includeUnavailable, IProgressMonitor progressMonitor) {
        return this.referredRepository.getAllFixes(includeUnavailable, progressMonitor);
    }

    @Override
    public boolean isOpen() {
        return this.referredRepository.isOpen();
    }

    @Override
    public IStatus getStatus(boolean forceReEvaluation, IProgressMonitor progressMonitor) {
        return this.referredRepository.getStatus(forceReEvaluation, progressMonitor);
    }

    @Override
    public List getAllAssemblies(IProgressMonitor progressMonitor) {
        return this.referredRepository.getAllAssemblies(progressMonitor);
    }

    @Override
    public List getAllSus(IProgressMonitor progressMonitor) {
        return this.referredRepository.getAllSus(progressMonitor);
    }

    @Override
    public List getAllSuFragments(IProgressMonitor progressMonitor) {
        return this.referredRepository.getAllSuFragments(progressMonitor);
    }

    @Override
    public List getAllIus(IProgressMonitor progressMonitor) {
        return this.referredRepository.getAllIus(progressMonitor);
    }

    @Override
    public List getAllContentElements(IProgressMonitor progressMonitor) {
        return this.referredRepository.getAllContentElements(progressMonitor);
    }

    @Override
    public IOffering findOffering(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return this.referredRepository.findOffering(id, version, progressMonitor);
    }

    @Override
    public IOffering findOffering(boolean includeUnavailable, IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return this.referredRepository.findOffering(includeUnavailable, id, version, progressMonitor);
    }

    @Override
    public IOffering findUpdate(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return this.referredRepository.findUpdate(id, version, progressMonitor);
    }

    @Override
    public IOffering findUpdate(boolean includeUnavailable, IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return this.referredRepository.findUpdate(includeUnavailable, id, version, progressMonitor);
    }

    @Override
    public IFix findFix(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return this.referredRepository.findFix(id, version, progressMonitor);
    }

    @Override
    public IFix findFix(boolean includeUnavailable, IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return this.referredRepository.findFix(includeUnavailable, id, version, progressMonitor);
    }

    @Override
    public IShareableEntity findShareableEntity(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return this.referredRepository.findShareableEntity(id, version, progressMonitor);
    }

    @Override
    public List getShareableEntities(IIdentity id, Version version, VersionRange tolerance, IProgressMonitor progressMonitor) {
        return this.referredRepository.getShareableEntities(id, version, tolerance, progressMonitor);
    }

    @Override
    public IInstallableUnit findInstallableUnit(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return this.referredRepository.findInstallableUnit(id, version, progressMonitor);
    }

    @Override
    public IRepositoryInfo getRepositoryInfo() {
        return this.referredRepository.getRepositoryInfo();
    }

    @Override
    public String serializeRepositoryInfo() {
        return this.referredRepository.serializeRepositoryInfo();
    }

    @Override
    public void setOpen(boolean isOpened) {
        this.referredRepository.setOpen(isOpened);
    }

    @Override
    public List getAllShareableEntities(IProgressMonitor progressMonitor) {
        return this.referredRepository.getAllShareableEntities(progressMonitor);
    }

    @Override
    public IAssembly findAssembly(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return this.referredRepository.findAssembly(id, version, progressMonitor);
    }

    @Override
    public IShareableUnit findShareableUnit(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return this.referredRepository.findShareableUnit(id, version, progressMonitor);
    }

    @Override
    public ISuFragment findSuFragment(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return this.referredRepository.findSuFragment(id, version, progressMonitor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RepositoryRef) {
            return this.referredRepository.equals(((RepositoryRef)obj).getRepository());
        }
        return false;
    }

    public int hashCode() {
        return this.referredRepository.hashCode();
    }

    @Override
    public void registerListener(IRepositoryPropertyEventListener listener) {
        this.referredRepository.registerListener(listener);
    }

    @Override
    public void unregisterListener(IRepositoryPropertyEventListener listener) {
        this.referredRepository.unregisterListener(listener);
    }

    public Object getAdapter(Class adapter) {
        return this.referredRepository.getAdapter(adapter);
    }

    @Override
    public boolean hasArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return this.referredRepository.hasArtifactToc(session, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return this.referredRepository.readArtifactToc(session, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readCachedArtifactToc(IArtifactSession session, IPath tocCache, IProgressMonitor monitor) throws CoreException {
        return this.referredRepository.readCachedArtifactToc(session, tocCache, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactTocCapabilities getArtifactTocCapabilities() {
        return this.referredRepository.getArtifactTocCapabilities();
    }

    @Override
    public IContent addContent(IContent content) throws IOException {
        return this.referredRepository.addContent(content);
    }

    @Override
    public IStatus saveContent(IContent content) throws IOException {
        return this.referredRepository.saveContent(content);
    }

    @Override
    public IContent moveContent(IContent content) throws IOException {
        return this.referredRepository.moveContent(content);
    }

    @Override
    public IStatus deleteContent(IContent content) throws IOException {
        return this.referredRepository.deleteContent(content);
    }

    @Override
    public IStatus addContent(List contentList) throws IOException {
        return this.referredRepository.addContent(contentList);
    }

    @Override
    public IAssembly createAssembly(IIdentity id, Version version) throws IOException {
        return this.referredRepository.createAssembly(id, version);
    }

    @Override
    public IOffering createOffering(IIdentity id, Version version) throws IOException {
        return this.referredRepository.createOffering(id, version);
    }

    @Override
    public IFix createFix(IIdentity id, Version version) throws IOException {
        return this.referredRepository.createFix(id, version);
    }

    @Override
    public IShareableUnit createSu(IIdentity id, Version version) throws IOException {
        return this.referredRepository.createSu(id, version);
    }

    @Override
    public ISuFragment createSuFragment(IIdentity id, Version version) throws IOException {
        return this.referredRepository.createSuFragment(id, version);
    }

    @Override
    public IInstallableUnit createIu(IIdentity id, Version version) throws IOException {
        return this.referredRepository.createIu(id, version);
    }

    @Override
    public IStatus clear() {
        return this.referredRepository.clear();
    }

    @Override
    public IStatus delete(boolean removeContents) {
        if (this.referenceCount <= 1) {
            return this.getRepository().delete(removeContents);
        }
        return RepositoryStatus.createErrorStatus(Messages.Repo_CantCreateDeleteRepository, this.getLocationStr(), 6018, null);
    }

    @Override
    public void dispose() {
        this.referredRepository.dispose();
    }

    @Override
    public boolean containsMetadata() {
        return this.referredRepository.containsMetadata();
    }

    @Override
    public boolean containsArtifacts() {
        return this.referredRepository.canStoreArtifacts();
    }

    @Override
    public InputStream getContentInputStream(IContent content) throws IOException {
        return this.getRepository().getContentInputStream(content);
    }

    @Override
    public InputStream getInputStream(String relativePath) throws IOException {
        return this.referredRepository.getInputStream(relativePath);
    }

    @Override
    public IRepository getRepositoryReference() {
        return this.referredRepository.getRepositoryReference();
    }

    @Override
    public boolean canStoreArtifacts() {
        return this.referredRepository.canStoreArtifacts();
    }

    @Override
    public boolean canStoreMetadata() {
        return this.referredRepository.canStoreMetadata();
    }

    @Override
    public void setReferencedRepository(IRepository repository) {
        this.referredRepository = repository;
    }

    @Override
    public void setRepositoryReference(IRepository repository) {
        this.referredRepository.setRepositoryReference(repository);
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    protected void increaseReferenceCount() {
        ++this.referenceCount;
    }

    protected void decreaseReferenceCount() {
        --this.referenceCount;
    }

    @Override
    public IStatus canAddExistingRepository(IProgressMonitor progressMonitor) {
        return this.referredRepository.canAddExistingRepository(progressMonitor);
    }

    @Override
    public IStatus isRepInfoMatchingRepositoryObject(IRepositoryInfo repInfo) {
        return this.referredRepository.isRepInfoMatchingRepositoryObject(repInfo);
    }

    @Override
    public IStatus canCreateRepository() {
        return this.referredRepository.canCreateRepository();
    }

    @Override
    public IStatus resolve(IOfferingOrFix element, IProgressMonitor progressMonitor) {
        return this.referredRepository.resolve(element, progressMonitor);
    }

    @Override
    public IContentRepository getContentRepository(IContent element) {
        return this.referredRepository.getContentRepository(element);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RepRef cnt=");
        sb.append(this.referenceCount);
        sb.append("; --> ");
        if (this.referredRepository == null) {
            sb.append("null");
        } else {
            sb.append(this.referredRepository.toString());
        }
        return sb.toString();
    }

    @Override
    public UserNames getUserNames() {
        return this.referredRepository.getUserNames();
    }

    @Override
    public RepositorySiteProperties getSiteProperties() {
        return this.referredRepository.getSiteProperties();
    }

    @Override
    public ICicLocation getLocation() {
        return this.referredRepository.getLocation();
    }

    @Override
    public String getLocationStr() {
        return this.referredRepository.getLocationStr();
    }

    @Override
    public IStatus updateRepositoryDigest(int a_request, IProgressMonitor progressMonitor) {
        return this.referredRepository.updateRepositoryDigest(a_request, progressMonitor);
    }

    @Override
    public RepositoryDigestRepositoryData generateRepositoryDigestData(CicMultiStatus status, IProgressMonitor pm) {
        return this.referredRepository.generateRepositoryDigestData(status, pm);
    }

    @Override
    public RepositoryDigestRepositoryData getRepositoryDigestData() {
        return this.referredRepository.getRepositoryDigestData();
    }

    @Override
    public IStatus importP2Repository(File p2RepositoryFile, IProgressMonitor monitor) {
        return this.referredRepository.importP2Repository(p2RepositoryFile, monitor);
    }

    @Override
    public IStatus deleteP2Repository(IProgressMonitor monitor) {
        return this.referredRepository.deleteP2Repository(monitor);
    }

    @Override
    public IStatus exportP2Repository(File destinationFile, IProgressMonitor monitor) {
        return this.referredRepository.exportP2Repository(destinationFile, monitor);
    }

    @Override
    public boolean containsP2Repository(IProgressMonitor monitor) {
        return this.referredRepository.containsP2Repository(monitor);
    }

    @Override
    public IStatus addNLSFile(String fileName, InputStream source) throws IOException {
        return this.referredRepository.addNLSFile(fileName, source);
    }

    @Override
    public IStatus deleteNLSFile(String fileName) throws IOException {
        return this.referredRepository.deleteNLSFile(fileName);
    }

    @Override
    public String[] getNLSFileList() {
        return this.referredRepository.getNLSFileList();
    }

    @Override
    public InputStream openNLSFileStream(String fileName) throws IOException {
        return this.referredRepository.openNLSFileStream(fileName);
    }
}

