/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.repository;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.repository.RepositoryInfo;
import com.ibm.cic.common.core.internal.repository.RepositoryList;
import com.ibm.cic.common.core.internal.repository.RepositoryRef;
import com.ibm.cic.common.core.repository.AbstractBaseRepository;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryCollection;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.IRepositoryPool;
import com.ibm.cic.common.core.repository.RepositoryDescriptor;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.FileCacheManager;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class RepositoryPool
implements IRepositoryPool {
    static final Logger log = Logger.getLogger(RepositoryPool.class);
    private static final String DEFAULT_POOL_NAME = "defaultPoolName";
    private final String m_poolName;
    private final IRepositoryCollection m_repositories;
    protected List m_managedRepositoryDescriptors;
    private static RepositoryPool m_instance;
    public static final String EXT_POINT_ID = "RepositoryAccessService";
    private final FileCacheManager m_fileCacheManager;

    protected RepositoryPool(String name, IRepositoryCollection a_collection) {
        assert (name != null);
        this.m_poolName = name;
        this.m_repositories = a_collection;
        this.m_managedRepositoryDescriptors = new ArrayList();
        this.m_fileCacheManager = FileCacheManager.getInstance();
    }

    public RepositoryPool(String name) {
        this(name, new RepositoryList());
        IExtensionRegistry er = Platform.getExtensionRegistry();
        if (er != null) {
            this.configureProviders(er.getExtensionPoint(ComIbmCicCommonCorePlugin.getPluginId(), EXT_POINT_ID).getConfigurationElements());
        }
    }

    public String toString() {
        return this.m_poolName;
    }

    public static RepositoryPool getDefault() {
        if (m_instance == null) {
            m_instance = new RepositoryPool(DEFAULT_POOL_NAME);
        }
        return m_instance;
    }

    private final void configureProviders(IConfigurationElement[] elements) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            RepositoryDescriptor newDescriptor = new RepositoryDescriptor(element);
            if (!this.m_managedRepositoryDescriptors.contains(newDescriptor)) {
                this.m_managedRepositoryDescriptors.add(newDescriptor);
            }
            ++n2;
        }
    }

    @Override
    public IRepository addExistingRepository(String serializedRepInfo, boolean findPriorityBasedLocation) {
        IRepository return_value = null;
        RepositoryInfo repInfo = new RepositoryInfo(serializedRepInfo);
        repInfo.setRepositoryDescriptor(this.findRepositoryDescriptor(repInfo));
        try {
            return_value = this.addExistingRepository(repInfo, findPriorityBasedLocation);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return return_value;
    }

    @Override
    public IRepository addExistingRepository(IRepositoryInfo repInfo, boolean findPriorityBasedLocation) throws CoreException, IOException {
        return this.addRepository(repInfo, false, findPriorityBasedLocation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized IStatus canAddExistingRepository(IRepositoryInfo repInfo, IProgressMonitor progressMonitor) {
        ICicStatus return_status = Statuses.ERROR.get(6001, Messages.Repo_CantAddExistingRepository, new Object[0]);
        if (repInfo == null) return return_status;
        if (this.m_repositories.findRepository(repInfo) != null) return Status.OK_STATUS;
        SplitProgressMonitor pm = null;
        try {
            try {
                RepositoryDescriptor rd = repInfo.getRepositoryDescriptor();
                RepositoryGroup.getDefault().getFileCacheManager().resetPathTreeWithNoTimout(repInfo.getLocation());
                CicMultiStatus ms = RepositoryStatus.createSpecificMultiStatus(Statuses.ERROR.get(6001, Messages.Repo_CantAddExistingRepository, new Object[0]), null);
                if (rd == null) {
                    ICicStatus statusCanAddProvided = Statuses.ERROR.get(6001, Messages.Repo_CantAddExistingRepository, new Object[0]);
                    pm = new SplitProgressMonitor(progressMonitor, this.m_managedRepositoryDescriptors.size());
                    Iterator I = this.m_managedRepositoryDescriptors.iterator();
                    while (I.hasNext() && !statusCanAddProvided.isOK()) {
                        rd = (RepositoryDescriptor)I.next();
                        AbstractBaseRepository ar = rd.createRepositoryObject(repInfo, null);
                        if (ar != null) {
                            statusCanAddProvided = ar.canAddExistingRepository(pm.next());
                            ar.dispose();
                        } else {
                            statusCanAddProvided = repInfo.getLastOperationStatus();
                        }
                        if (statusCanAddProvided.isOK()) continue;
                        Throwable t = statusCanAddProvided.getException();
                        if (t instanceof CoreException) {
                            CoreException ce = (CoreException)t;
                            ms.add(ce.getStatus());
                            continue;
                        }
                        ms.add(statusCanAddProvided);
                    }
                    return_status = statusCanAddProvided.isOK() ? statusCanAddProvided : ms;
                    return return_status;
                }
                AbstractBaseRepository ar = rd.createRepositoryObject(repInfo, null);
                if (ar != null) {
                    return_status = ar.canAddExistingRepository(null);
                    ar.dispose();
                    return return_status;
                }
                ms.add(repInfo.getLastOperationStatus());
                return_status = ms;
                return return_status;
            }
            catch (CoreException e) {
                e.printStackTrace();
                if (pm == null) return return_status;
                pm.done();
            }
            return return_status;
        }
        finally {
            if (pm != null) {
                pm.done();
            }
        }
    }

    @Override
    public IRepository createRepository(IRepositoryInfo repInfo) throws CoreException, IOException {
        return this.addRepository(repInfo, true, true);
    }

    @Override
    public synchronized IStatus canCreateRepository(IRepositoryInfo repInfo) {
        RepositoryStatus return_value = RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY;
        if (repInfo != null) {
            if (repInfo.getType() == null) {
                return_value = new RepositoryStatus(RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY_NO_ENOUGH_INFO, repInfo.getLocationStr(), "Type");
            } else if (repInfo.getVersion() == null) {
                return_value = new RepositoryStatus(RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY_NO_ENOUGH_INFO, repInfo.getLocationStr(), "Version");
            } else {
                IRepository existingRep = this.m_repositories.findRepository(repInfo);
                if (existingRep == null) {
                    try {
                        RepositoryDescriptor rd = repInfo.getRepositoryDescriptor();
                        if (rd == null) {
                            Iterator I = this.m_managedRepositoryDescriptors.iterator();
                            while (I.hasNext() && !return_value.isOK()) {
                                rd = (RepositoryDescriptor)I.next();
                                AbstractBaseRepository ar = rd.createRepositoryObject(repInfo, null);
                                if (ar == null) continue;
                                return_value = ar.canCreateRepository();
                            }
                        } else {
                            AbstractBaseRepository ar = rd.createRepositoryObject(repInfo, null);
                            if (ar != null) {
                                return_value = ar.canCreateRepository();
                            }
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                } else {
                    return_value = new RepositoryStatus(RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY_ALREADY_EXISTS, existingRep.getLocationStr());
                }
            }
        }
        return return_value;
    }

    private synchronized IRepository addRepository(IRepositoryInfo repInfo, boolean create, boolean findPriorityBasedLocation) throws CoreException, IOException {
        IRepository return_value = null;
        if (repInfo != null) {
            if (!create) {
                return_value = this.m_repositories.findRepository(repInfo);
            }
            if (return_value == null) {
                RepositoryDescriptor descr = repInfo.getRepositoryDescriptor();
                if (descr == null) {
                    if (!create) {
                        RepositoryDescriptor rd = null;
                        Iterator I = this.m_managedRepositoryDescriptors.iterator();
                        while (I.hasNext() && return_value == null) {
                            rd = (RepositoryDescriptor)I.next();
                            repInfo.setRepositoryDescriptor(rd);
                            return_value = rd.createInitializedExistingRepositoryObject(repInfo);
                            if (return_value == null) {
                                repInfo.setRepositoryDescriptor(null);
                                continue;
                            }
                            log.debug("RepositoryPool, {0} associated with repository type {1}", repInfo.getLocationStr(), return_value.getType());
                        }
                    }
                } else {
                    IRepository iRepository = return_value = create ? descr.createInitializedNewRepositoryObject(repInfo) : descr.createInitializedExistingRepositoryObject(repInfo);
                }
                if (return_value != null) {
                    this.m_repositories.addRepository(return_value, findPriorityBasedLocation);
                } else {
                    log.debug("RepositoryPool, {0} could not be associated with a repository type", repInfo.getLocationStr());
                }
            }
        }
        if (return_value != null) {
            IRepository ref = return_value.getRepositoryReference();
            if (ref instanceof RepositoryRef) {
                ((RepositoryRef)ref).increaseReferenceCount();
            } else {
                Assert.isTrue((boolean)false);
            }
            return_value = ref;
        }
        return return_value;
    }

    @Override
    public synchronized IRepository addExistingRepository(IRepository repo, boolean findPriorityBasedLocation) {
        IRepository return_value = null;
        if (repo != null) {
            IRepository ref;
            IRepositoryInfo repInfo = repo.getRepositoryInfo();
            return_value = this.m_repositories.findRepository(repInfo);
            if (return_value == null) {
                return_value = repo;
                RepositoryDescriptor descr = repInfo.getRepositoryDescriptor();
                if (descr != null) {
                    this.m_repositories.addRepository(return_value, findPriorityBasedLocation);
                }
            }
            if ((ref = return_value.getRepositoryReference()) instanceof RepositoryRef) {
                ((RepositoryRef)ref).increaseReferenceCount();
            } else {
                Assert.isTrue((boolean)false);
            }
            return_value = ref;
        }
        return return_value;
    }

    @Override
    public synchronized IStatus deleteRepository(IRepository repository, boolean mustClear) {
        IStatus return_value = null;
        IRepository ref = repository.getRepositoryReference();
        if (ref instanceof RepositoryRef) {
            ((RepositoryRef)ref).decreaseReferenceCount();
            if (((RepositoryRef)ref).getReferenceCount() == 0) {
                return_value = repository.delete(mustClear);
                this.m_repositories.removeRepository(repository);
                return_value = Status.OK_STATUS;
            }
        }
        if (return_value == null) {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_RepositoryInfoDoesNotMatch, 6018, log);
        }
        return return_value;
    }

    @Override
    public synchronized IRepository removeRepository(IRepository repository) {
        IRepository ref;
        if (repository != null && (ref = repository.getRepositoryReference()) instanceof RepositoryRef) {
            ((RepositoryRef)ref).decreaseReferenceCount();
            if (((RepositoryRef)ref).getReferenceCount() <= 0) {
                repository.dispose();
                this.m_repositories.removeRepository(repository);
                return null;
            }
            return repository;
        }
        return null;
    }

    @Override
    public IRepositoryInfo createRepositoryInfo(String name, String type, String version, ICicLocation location, String extraSettings) {
        RepositoryInfo return_value = new RepositoryInfo(name, type, version, location, extraSettings);
        return_value.setRepositoryDescriptor(this.findRepositoryDescriptor(return_value));
        return return_value;
    }

    @Override
    public RepositoryDescriptor findRepositoryDescriptor(IRepositoryInfo rpInfo) {
        RepositoryDescriptor return_value = null;
        String type = rpInfo.getType();
        String version = rpInfo.getVersion();
        if (type != null || version != null) {
            Iterator I = this.m_managedRepositoryDescriptors.iterator();
            while (I.hasNext() && return_value == null) {
                return_value = (RepositoryDescriptor)I.next();
                if (return_value.getType().equals(type) && return_value.getVersion().equals(version)) continue;
                return_value = null;
            }
        }
        return return_value;
    }

    @Override
    public RepositoryDescriptor[] getRepositoryDescriptors() {
        return this.m_managedRepositoryDescriptors.toArray(new RepositoryDescriptor[this.m_managedRepositoryDescriptors.size()]);
    }

    @Override
    public boolean setManagedRepositoryGroupCaching(boolean enablePersistenceCache, boolean enableMemoryCache) {
        return false;
    }

    @Override
    public boolean setRepositoryCaching(IRepositoryInfo repositoryInfo, boolean enablePersistenceCache, boolean enableMemoryCache) {
        return false;
    }

    @Override
    public Collection getRepositories() {
        return this.m_repositories.getAssignedRepositories();
    }

    @Override
    public FileCacheManager getFileCacheManager() {
        return this.m_fileCacheManager;
    }
}

