/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.downloads;

import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IFileContentInfo;
import com.ibm.cic.common.downloads.SimpleContentInfo;

public class FileContentInfo
extends SimpleContentInfo
implements IFileContentInfo {
    ICicLocation m_name = null;
    ICicLocation m_path = null;
    ICicLocation m_location = null;

    public FileContentInfo(ICicLocation path, ICicLocation name) {
        this.m_path = path;
        this.m_name = name;
    }

    public FileContentInfo(IContentInfo ci) {
        super(ci);
        if (ci instanceof FileContentInfo) {
            this.m_path = ((FileContentInfo)ci).getFilePath();
            this.m_name = ((FileContentInfo)ci).getFileName();
        }
    }

    public FileContentInfo(ICicLocation location) {
        this.m_location = location;
    }

    @Override
    public ICicLocation getFileLocation() {
        if (this.m_location == null) {
            this.m_location = this.getFilePath().append(this.m_name);
        }
        return this.m_location;
    }

    @Override
    public ICicLocation getFileName() {
        if (this.m_name == null) {
            this.m_name = this.m_location != null ? new CicFileLocation(this.m_location.getName()) : CicConstants.EMPTY_LOCATION;
        }
        return this.m_name;
    }

    @Override
    public ICicLocation getFilePath() {
        if (this.m_path == null) {
            this.m_path = this.m_location != null ? new CicFileLocation(this.m_location.getPathSegments()) : CicConstants.EMPTY_LOCATION;
        }
        return this.m_path;
    }

    @Override
    public void setFileName(ICicLocation name) {
        this.m_name = name;
        this.getFilePath();
        this.m_location = null;
    }

    @Override
    public void setFileLocation(ICicLocation location) {
        this.m_location = location;
        this.m_name = null;
        this.m_path = null;
    }

    @Override
    public void setFilePath(ICicLocation path) {
        this.m_path = path;
        this.getFileName();
        this.m_location = null;
    }

    @Override
    public String toString() {
        return "location:'" + this.getFileLocation().toString() + "' >" + super.toString();
    }
}

