/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.extensions;

import com.ibm.cic.common.core.extensions.IExtensionFilter;
import com.ibm.cic.common.core.extensions.IExtensionFilterFactory;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.internal.Messages;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class ExtensionManager {
    private static ExtensionManager instance;
    private final DeclaredExtensionFilters declaredExtensionFilters = new DeclaredExtensionFilters();
    private static final Logger log;

    static {
        log = Logger.getLogger(ExtensionManager.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    }

    public static ExtensionManager getInstance() {
        if (instance == null) {
            instance = new ExtensionManager();
        }
        return instance;
    }

    public IConfigurationElement[] getConfigurationElements(String namespace, String extensionPointName) {
        return this.getConfigurationElements(namespace, extensionPointName, true, null);
    }

    public IConfigurationElement[] getConfigurationElements(String namespace, String extensionPointName, IExtensionFilter[] additionalFilters) {
        return this.getConfigurationElements(namespace, extensionPointName, true, additionalFilters);
    }

    private IConfigurationElement[] getConfigurationElements(String namespace, String extensionPointName, boolean useDeclaredFilters, IExtensionFilter[] additionalfilters) {
        ArrayList<IConfigurationElement> returnElements = new ArrayList<IConfigurationElement>();
        String extensionPointId = this.getExtensionPointId(namespace, extensionPointName);
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(extensionPointId);
        if (point != null) {
            int n;
            IExtension[] extensions = point.getExtensions();
            ArrayList<IExtensionFilter> filters = new ArrayList<IExtensionFilter>();
            if (useDeclaredFilters) {
                IExtensionFilter[] currentFilters;
                IExtensionFilter[] iExtensionFilterArray = currentFilters = this.declaredExtensionFilters.getExtensionFilters();
                int n2 = currentFilters.length;
                n = 0;
                while (n < n2) {
                    IExtensionFilter currentFilter = iExtensionFilterArray[n];
                    filters.add(currentFilter);
                    ++n;
                }
            }
            if (additionalfilters != null) {
                IExtensionFilter[] iExtensionFilterArray = additionalfilters;
                n = additionalfilters.length;
                int n3 = 0;
                while (n3 < n) {
                    IExtensionFilter additionalfilter = iExtensionFilterArray[n3];
                    filters.add(additionalfilter);
                    ++n3;
                }
            }
            IExtension[] iExtensionArray = extensions;
            n = extensions.length;
            int n4 = 0;
            while (n4 < n) {
                IExtension extension = iExtensionArray[n4];
                boolean extensionExcluded = false;
                for (IExtensionFilter filter : filters) {
                    if (!filter.exclude(extension)) continue;
                    extensionExcluded = true;
                    break;
                }
                if (!extensionExcluded) {
                    IConfigurationElement[] elements;
                    IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                    int n5 = elements.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement element = iConfigurationElementArray[n6];
                        boolean elementExcluded = false;
                        for (IExtensionFilter filter : filters) {
                            if (!filter.exclude(element)) continue;
                            elementExcluded = true;
                            break;
                        }
                        if (!elementExcluded) {
                            returnElements.add(element);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
        }
        return returnElements.toArray(new IConfigurationElement[returnElements.size()]);
    }

    private String getExtensionPointId(String namespace, String extensionPointName) {
        return String.valueOf(namespace) + '.' + extensionPointName;
    }

    private class DeclaredExtensionFilters {
        private static final String PT_ATTR_CLASS = "class";
        private static final String PT_NAME = "extensionFilters";
        private final List allFilters = new ArrayList();

        public DeclaredExtensionFilters() {
            this.retrieveDeclaredFilters();
        }

        public IExtensionFilter[] getExtensionFilters() {
            ArrayList<IExtensionFilter> extensionFilters = new ArrayList<IExtensionFilter>();
            for (ExtensionFilterHolder filterHolder : this.allFilters) {
                IExtensionFilter extensionFilter = filterHolder.getExtensionFilter();
                if (extensionFilter == null) continue;
                extensionFilters.add(extensionFilter);
            }
            return extensionFilters.toArray(new IExtensionFilter[extensionFilters.size()]);
        }

        private void addExtensionFilterHolder(ExtensionFilterHolder filter) {
            this.allFilters.add(filter);
        }

        private void retrieveDeclaredFilters() {
            IConfigurationElement[] extensionFilterConfigurationElements;
            IConfigurationElement[] iConfigurationElementArray = extensionFilterConfigurationElements = ExtensionManager.this.getConfigurationElements(ComIbmCicCommonCorePlugin.getPluginId(), PT_NAME, false, null);
            int n = extensionFilterConfigurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement extensionFilterConfigurationElement = iConfigurationElementArray[n2];
                ExtensionFilterHolder filterHolder = new ExtensionFilterHolder(extensionFilterConfigurationElement);
                this.addExtensionFilterHolder(filterHolder);
                ++n2;
            }
        }

        private class ExtensionFilterHolder {
            private IConfigurationElement extensionFilterConfigurationElement = null;
            private IExtensionFilterFactory extensionFilterFactory = null;
            private boolean classCreated = false;

            public ExtensionFilterHolder(IConfigurationElement configurationElement) {
                this.extensionFilterConfigurationElement = configurationElement;
            }

            public IExtensionFilter getExtensionFilter() {
                IExtensionFilter extensionFilter = null;
                if (!this.classCreated) {
                    try {
                        try {
                            Object clazz = this.extensionFilterConfigurationElement.createExecutableExtension(DeclaredExtensionFilters.PT_ATTR_CLASS);
                            if (clazz instanceof IExtensionFilterFactory) {
                                this.extensionFilterFactory = (IExtensionFilterFactory)clazz;
                                extensionFilter = this.extensionFilterFactory.getExtensionFilter();
                            }
                            log.status((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, NLS.bind(Messages.ExtensionManager_class_for_extension_point_does_not_implement, this.extensionFilterConfigurationElement.getAttribute(DeclaredExtensionFilters.PT_ATTR_CLASS), DeclaredExtensionFilters.PT_NAME, IExtensionFilterFactory.class.getName()), null));
                        }
                        catch (CoreException e) {
                            log.error(e);
                            this.classCreated = true;
                        }
                    }
                    finally {
                        this.classCreated = true;
                    }
                } else if (this.extensionFilterFactory != null) {
                    extensionFilter = this.extensionFilterFactory.getExtensionFilter();
                }
                return extensionFilter;
            }
        }
    }
}

