/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.definitions;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ProfileOS {
    public static final String AIX = "aix";
    public static final String HPUX = "hpux";
    public static final String LINUX = "linux";
    public static final String MACOSX = "macosx";
    public static final String OS400 = "os400";
    public static final String SOLARIS = "solaris";
    public static final String WIN32 = "win32";
    public static final String ZOS = "zos";
    public static final String AIX_DISPLAY = "AIX";
    public static final String HPUX_DISPLAY = "HPUX";
    public static final String LINUX_DISPLAY = "Linux";
    public static final String MACOSX_DISPLAY = "MACOSX";
    public static final String OS400_DISPLAY = "OS400";
    public static final String SOLARIS_DISPLAY = "Solaris";
    public static final String WIN32_DISPLAY = "Windows";
    public static final String ZOS_DISPLAY = "ZOS";
    private static final Map<String, String> operatingSystems;

    static {
        LinkedHashMap<String, String> systems = new LinkedHashMap<String, String>();
        systems.put(AIX, AIX_DISPLAY);
        systems.put(HPUX, HPUX_DISPLAY);
        systems.put(LINUX, LINUX_DISPLAY);
        systems.put(MACOSX, MACOSX_DISPLAY);
        systems.put(OS400, OS400_DISPLAY);
        systems.put(SOLARIS, SOLARIS_DISPLAY);
        systems.put(WIN32, WIN32_DISPLAY);
        systems.put(ZOS, ZOS_DISPLAY);
        operatingSystems = Collections.unmodifiableMap(systems);
    }

    public static Set<String> getOperatingSystems() {
        return operatingSystems.keySet();
    }

    public static Collection<String> getOperatingSystemDisplayNames() {
        return operatingSystems.values();
    }

    public static String getOperatingSystemDisplayName(String osIdentifier) {
        return operatingSystems.get(osIdentifier);
    }

    public static String getOperatingSystemIdentifier(String osDisplayName) {
        for (Map.Entry<String, String> entry : operatingSystems.entrySet()) {
            String osIdentifier = entry.getKey();
            if (!entry.getValue().equals(osDisplayName)) continue;
            return osIdentifier;
        }
        return null;
    }
}

