/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.ConsoleRepositoryUtils;
import com.ibm.cic.common.core.cmd.PrompterUtils;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.IStatusCodes;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SilentRepositoryUtils {
    public static IRepository silentOpenExistingRepository(boolean staySecure, IRepositoryGroup group, IRepositoryInfo repInfo, IProgressMonitor monitor) throws CoreException {
        PrompterUtils.SilentDownloadUserPrompts prompts = new PrompterUtils.SilentDownloadUserPrompts(staySecure);
        try {
            IRepository iRepository = RepositoryUtils.openExistingRepository(group, repInfo, monitor);
            return iRepository;
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            if (StatusCodes.isAuthenticationCanceled(status)) {
                CicMultiStatus ms = Statuses.ERROR.getMultiStatus(Messages.RepositoryUtils_failedToConnectToRepositoryE, repInfo.getName());
                Collection<String> credPrompts = prompts.getPrompts();
                for (String credPrompt : credPrompts) {
                    ms.add(Statuses.ERROR.get(status.getCode(), Messages.SilentRepositoryUtils_missingCredentialsForPrompt, credPrompt));
                }
                ms.add(IStatusCodes.STATUS_ERROR_MISSING_CREDENTIALS_KEYRING_TIPOFF);
                throw new CoreException((IStatus)ms);
            }
            throw e;
        }
        finally {
            prompts.restore();
        }
    }

    public static CicMultiStatus openServiceRepositories(final boolean staySecure, IRepositoryGroup group, IOffering[] offerings, IProgressMonitor monitor) {
        return ConsoleRepositoryUtils.openServiceRepositories(new ServiceRepositoryUtils.DefaultOpenServiceRepo(){

            @Override
            public IRepository openServiceRepository(IRepositoryGroup destinationGroup, IOffering offering, IRepositoryInfo repInfo) throws CoreException {
                return SilentRepositoryUtils.silentOpenExistingRepository(staySecure, destinationGroup, repInfo, (IProgressMonitor)new NullProgressMonitor());
            }
        }, group, offerings, monitor);
    }
}

