/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.ACmdLine;
import com.ibm.cic.common.core.cmd.CmdUtils;
import com.ibm.cic.common.core.cmd.ICmdOperation;
import com.ibm.cic.common.core.utils.Encodings;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public abstract class ACmdOp
implements ICmdOperation {
    protected final ACmdLine cl;
    protected final PrintWriter out;
    protected final PrintWriter err;

    public ACmdOp(ACmdLine cl) {
        this.cl = cl;
        this.out = new PrintWriter((Writer)new BufferedWriter(Encodings.DEFAULT.writer(System.out)), true);
        this.err = new PrintWriter((Writer)new BufferedWriter(Encodings.DEFAULT.writer(System.err)), true);
    }

    protected abstract boolean isQuery();

    protected abstract IStatus doExecute(IProgressMonitor var1);

    public boolean isPreview() {
        return false;
    }

    @Override
    public IStatus execute(IProgressMonitor monitor) {
        IStatus result = this.doExecute(monitor);
        this.reportSuccessFailureToOutput(result, this.out);
        return result;
    }

    public boolean shouldPrompt() {
        return this.cl.containsCommand("-prompt");
    }

    protected IStatus done(IStatus result) {
        if (!result.isOK()) {
            CmdUtils.reportNotOKResult(result, this.out, this.err);
        }
        return result;
    }

    protected void reportSuccessFailureToOutput(IStatus result, PrintWriter outWriter) {
        if (this.isQuery()) {
            return;
        }
        CmdUtils.reportSuccessFailureToOutput(!this.isPreview(), result, outWriter);
    }
}

