/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.CmdCommand;
import com.ibm.cic.common.core.cmd.CmdIterator;
import com.ibm.cic.common.core.cmd.CmdLinkParam1;
import com.ibm.cic.common.core.cmd.CmdUtils;
import com.ibm.cic.common.core.cmd.ICicCmdCnst;
import com.ibm.cic.common.core.cmd.ICmdLink;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.Check;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class ACmdManager
implements ICicCmdCnst {
    private String[] m_originalCommandArguments = null;
    private final Map<String, CmdCommand> m_allRegisteredCommands = new LinkedHashMap<String, CmdCommand>();
    private final Map<String, CmdCommand> m_loadedCommands = new LinkedHashMap<String, CmdCommand>();
    private IStatus loadCommandLineData_Status = Status.OK_STATUS;

    public ACmdManager() {
        this.setCommandRules();
    }

    public String toString() {
        if (this.m_originalCommandArguments == null) {
            return "null";
        }
        return Util.toString(this.m_originalCommandArguments, new Util.Formatter(" "));
    }

    protected abstract void setCommandRules();

    protected abstract String[][] getToolsArray();

    protected IStatus processCommandDependencies() {
        return Status.OK_STATUS;
    }

    SortedSet<CmdCommand> getAllSortedRegisteredCommands() {
        TreeSet<CmdCommand> return_value = new TreeSet<CmdCommand>(new Comparator<CmdCommand>(){

            @Override
            public int compare(CmdCommand arg0, CmdCommand arg1) {
                return CmdUtils.compareCommands(arg0, arg1);
            }
        });
        return_value.addAll(this.m_allRegisteredCommands.values());
        return return_value;
    }

    public CmdCommand getCommand(String a_commandId) {
        return this.m_loadedCommands.get(a_commandId);
    }

    public boolean containsCommand(String a_commandId) {
        return this.getCommand(a_commandId) != null;
    }

    protected CmdCommand getRegisteredCommand(String a_commandId) {
        for (Map.Entry<String, CmdCommand> entry : this.m_allRegisteredCommands.entrySet()) {
            String cmdId = entry.getKey();
            if (!cmdId.equalsIgnoreCase(a_commandId)) continue;
            return entry.getValue();
        }
        return null;
    }

    int levelRequest(String a_param) {
        if (a_param != null) {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    if (!a_param.equalsIgnoreCase("all")) break block9;
                                    return 3;
                                }
                                if (!a_param.equalsIgnoreCase("hidden")) break block10;
                                return 4;
                            }
                            if (!a_param.equalsIgnoreCase("undocumented")) break block11;
                            return 8;
                        }
                        if (!a_param.equalsIgnoreCase("internal")) break block12;
                        return 16;
                    }
                    if (!a_param.equalsIgnoreCase("dummy")) break block13;
                    return 32;
                }
                if (!a_param.equalsIgnoreCase("deprecated")) break block14;
                return 64;
            }
            try {
                return Integer.parseInt(a_param);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public void registerCommand(CmdCommand cmd) {
        for (String id : cmd.getCommandIds()) {
            CmdCommand prev = this.m_allRegisteredCommands.put(id, cmd);
            if (prev == null) continue;
            Check.fail("Same id ({0}) used for two commands: {1}, {2}", id, prev.id(), cmd.id());
        }
    }

    private String findToolLable(String a_toolId) {
        String[][] toolsArray = this.getToolsArray();
        int i = 0;
        while (i < toolsArray[0].length) {
            if (toolsArray[0][i].equals(a_toolId)) {
                return toolsArray[1][i];
            }
            ++i;
        }
        return "";
    }

    private IStatus checkCommandConsistency() {
        for (CmdCommand cmd : this.m_loadedCommands.values()) {
            StringBuffer message = null;
            message = this.checkToolId(message, cmd);
            message = this.checkRequiredCommands(message, cmd);
            IStatus return_status = (message = this.checkOptionallyRequiredCommands(message, cmd)) != null ? Statuses.ERROR.get(8015, message.toString(), new Object[0]) : this.checkForbiddenCommands(cmd);
            if (return_status.isOK()) continue;
            return return_status;
        }
        return Status.OK_STATUS;
    }

    private IStatus checkForbiddenCommands(CmdCommand cmd) {
        List<ICmdLink> parents = cmd.getIncompatibleCommands();
        for (ICmdLink link : parents) {
            if (!link.isValidLink()) continue;
            return Statuses.ERROR.get(8017, Messages.Cmd_Error_Incompatible_Command, cmd.getStrVal(), link.getParent().getStrVal());
        }
        return Status.OK_STATUS;
    }

    private StringBuffer checkOptionallyRequiredCommands(StringBuffer message, CmdCommand cmd) {
        List<ICmdLink> parents = cmd.getOptionalParents();
        if (parents.isEmpty()) {
            return message;
        }
        for (ICmdLink link : parents) {
            if (!link.isValidLink()) continue;
            return message;
        }
        boolean reported_header = false;
        for (ICmdLink link : parents) {
            if ((link.getParent().getLevel() & 4) != 0) continue;
            if (!reported_header) {
                if (message == null) {
                    message = new StringBuffer();
                    message.append(NLS.bind(Messages.Cmd_Error_No_Required_Parents, (Object)cmd.getStrVal()));
                }
                message.append("\n");
                message.append(Messages.Cmd_Error_No_Allowed_Commands_One);
                reported_header = true;
            }
            message.append(' ').append(link.getParent().getCommandId());
        }
        return message;
    }

    private StringBuffer checkRequiredCommands(StringBuffer message, CmdCommand cmd) {
        List<ICmdLink> parents = cmd.getRequiredParents();
        boolean reported_header = false;
        for (ICmdLink link : parents) {
            if (link.getParent().id() == "-toolId" || link.isValidLink()) continue;
            if (!reported_header) {
                if (message == null) {
                    message = new StringBuffer();
                    message.append(NLS.bind(Messages.Cmd_Error_No_Required_Parents, (Object)cmd.getStrVal()));
                }
                message.append("\n");
                message.append(Messages.Cmd_Error_No_Allowed_Commands);
                reported_header = true;
            }
            message.append(' ').append(link.getParent().getCommandId());
        }
        return message;
    }

    private StringBuffer checkToolId(StringBuffer message, CmdCommand cmd) {
        List<ICmdLink> parents = cmd.getRequiredParents();
        boolean reported_header = false;
        for (ICmdLink link : parents) {
            String[] allowedParentParams;
            if (link.getParent().id() != "-toolId" || link.isValidLink()) continue;
            if (!reported_header) {
                if (message == null) {
                    message = new StringBuffer();
                    message.append(NLS.bind(Messages.Cmd_Error_No_Required_Parents, (Object)cmd.getStrVal()));
                }
                message.append("\n");
                message.append(Messages.Cmd_Error_No_Allowed_Executables);
                reported_header = true;
            }
            String[] stringArray = allowedParentParams = ((CmdLinkParam1)link).allowedParentParameters();
            int n = allowedParentParams.length;
            int n2 = 0;
            while (n2 < n) {
                String allowedParentParam = stringArray[n2];
                String name = this.findToolLable(allowedParentParam);
                if (name.length() > 0) {
                    message.append("\n");
                    message.append(name);
                }
                ++n2;
            }
        }
        return message;
    }

    IStatus loadCommandLineData(String[] a_cmdArray) {
        if (this.m_originalCommandArguments == a_cmdArray) {
            return this.loadCommandLineData_Status;
        }
        this.reset();
        this.m_originalCommandArguments = a_cmdArray;
        this.loadCommandLineData_Status = this.processCommandLine(a_cmdArray);
        if (this.loadCommandLineData_Status.isOK()) {
            this.loadCommandLineData_Status = this.processCommandDependencies();
        }
        if (this.loadCommandLineData_Status.isOK()) {
            this.loadCommandLineData_Status = this.checkCommandConsistency();
        }
        if (!this.loadCommandLineData_Status.isOK()) {
            StringBuffer msg = new StringBuffer();
            msg.append("\n");
            String toolL = this.findToolLable(this.getParam1StrVal("-toolId"));
            if (toolL.length() > 0) {
                msg.append(toolL);
                msg.append(":");
                msg.append("\n");
            }
            msg.append(NLS.bind(Messages.Cmd_Warning_Problem_In_Command_Line, (Object)Util.toString(this.m_originalCommandArguments, new Util.Formatter(" "))));
            msg.append("\n");
            msg.append(this.loadCommandLineData_Status.getMessage());
            msg.append("\n\n");
            msg.append(Messages.Cmd_Warning_use_help);
            msg.append("\n");
            this.loadCommandLineData_Status = Statuses.ST.createStatus(this.loadCommandLineData_Status, msg.toString(), new Object[0]);
        }
        return this.loadCommandLineData_Status;
    }

    protected IStatus processCommandLine(String[] a_cmdArray) {
        CmdIterator cmdData = new CmdIterator(a_cmdArray);
        while (cmdData.hasMoreArgs()) {
            CmdCommand cmd = this.getRegisteredCommand(cmdData.getCurrentArg());
            if (cmd == null) {
                return Statuses.ERROR.get(8004, Messages.Cmd_Error_Unrecognized_Command_Line_argument, cmdData.getCurrentArg());
            }
            IStatus status = cmd.loadCommandLineData(this, cmdData);
            if (!status.isOK()) {
                return status;
            }
            this.m_loadedCommands.put(cmd.id(), cmd);
        }
        return Status.OK_STATUS;
    }

    void reset() {
        for (CmdCommand cmd : this.m_allRegisteredCommands.values()) {
            cmd.reset();
        }
        this.m_loadedCommands.clear();
        this.m_originalCommandArguments = null;
    }

    String[] getCommandLine() {
        return this.m_originalCommandArguments;
    }

    protected String getParam1StrVal(String a_commandId) {
        CmdCommand cmd = this.getCommand(a_commandId);
        return cmd == null ? null : cmd.getParamStrVal(0);
    }

    protected Object getParam1ObjVal(String a_commandId) {
        CmdCommand cmd = this.getCommand(a_commandId);
        return cmd == null ? null : cmd.getParamObjVal(0);
    }

    boolean setParam1StrVal(String a_commandId, String a_val) {
        CmdCommand cmd = this.getCommand(a_commandId);
        return cmd != null && cmd.setParamVal(0, a_val);
    }

    protected Map<String, CmdCommand> getLoadedCommands() {
        return this.m_loadedCommands;
    }
}

