/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.NotValidatedPolicy;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoComputation;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoUtil;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.IStatusCodes;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IDownloaded;
import com.ibm.cic.common.downloads.ResumableDownloadProgress;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class ArtifactValidationUtil {
    ArtifactValidationUtil() {
    }

    public static IStatus validateDownloadedBytes(IDownloadSession session, NotValidatedPolicy nvp, IContentInfo expectedContentInfo, IDownloaded dl, ResumableDownloadProgress.IVerificationProgress progress, SimpleContentInfo validated) {
        List<String> expectedAlgorithms;
        if (progress.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        List<String> list = expectedAlgorithms = expectedContentInfo == null ? Collections.EMPTY_LIST : expectedContentInfo.getDigestAlgorithms();
        if (expectedAlgorithms.isEmpty()) {
            if (nvp == NotValidatedPolicy.NVP_SILENT) {
                return IStatusCodes.STATUS_OK_VALIDATION_NO_DIGESTS_AVAILABLE;
            }
            ICicStatus status = Statuses.WARNING.get(IStatusCodes.STATUS_OK_VALIDATION_NO_DIGESTS_AVAILABLE.getCode(), Messages.digest_validation_no_digest_available, new Object[0]);
            return status;
        }
        List<String> algorithms = expectedAlgorithms;
        ContentInfoComputation cic = null;
        try {
            IStatus status;
            IContentInfo ciActual;
            cic = session.getContentInfoComputer();
            try {
                ciActual = cic.computePreferredDigest(dl, algorithms, progress);
            }
            catch (IOException e) {
                ICicStatus status2;
                ICicStatus iCicStatus = status2 = Statuses.ERROR.get(28, e, Messages.digest_validation_exception, new Object[0]);
                if (cic != null) {
                    session.releaseContentInfoComputer(cic);
                }
                return iCicStatus;
            }
            if (ciActual != null) {
                dl.getMutableDownloadContentInfo().setDigests(ciActual);
            }
            if (progress.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            IStatus iStatus = status = ContentInfoUtil.validate(nvp == NotValidatedPolicy.NVP_SILENT, expectedContentInfo, ciActual, validated);
            return iStatus;
        }
        finally {
            if (cic != null) {
                session.releaseContentInfoComputer(cic);
            }
        }
    }
}

