/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

public class ArtifactTocUtil {
    public static CharRange[] getSplittableDomainNames(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        int len = s.length();
        if (len < 7) {
            return null;
        }
        int count = 1;
        boolean expectIdentifierStart = true;
        int lastDot = -1;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (expectIdentifierStart) {
                if (!Character.isJavaIdentifierStart(c)) {
                    return null;
                }
                expectIdentifierStart = false;
            } else if (c == '.') {
                ++count;
                lastDot = i;
                expectIdentifierStart = true;
            } else if (!Character.isJavaIdentifierPart(c)) {
                return null;
            }
            ++i;
        }
        if (lastDot == len - 1) {
            --count;
        }
        if (count < 3) {
            return null;
        }
        int iSplit = 0;
        lastDot = -1;
        CharRange[] splitted = new CharRange[count];
        i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '.') {
                splitted[iSplit] = new CharRange(lastDot + 1, i + 1);
                ++iSplit;
                lastDot = i;
            }
            ++i;
        }
        if (lastDot < len - 1) {
            splitted[count - 1] = new CharRange(lastDot + 1, len);
        }
        return splitted;
    }

    private static boolean isSplittableDomainSeparator(char c) {
        return c == '.';
    }

    public static String getIdPattern(String id) {
        String idPattern;
        CharRange[] domainNameId = ArtifactTocUtil.getSplittableDomainNames(id);
        if (domainNameId != null) {
            if (domainNameId.length < 3) {
                throw new AssertionError();
            }
            boolean endsWithSeparator = ArtifactTocUtil.isSplittableDomainSeparator(id.charAt(domainNameId[2].getEnd() - 1));
            int d = endsWithSeparator ? 1 : 0;
            idPattern = String.valueOf(id.substring(0, domainNameId[2].getEnd() - d)) + "*";
        } else {
            idPattern = id;
        }
        return idPattern;
    }

    public static class CharRange {
        private final int start;
        private final int end;

        CharRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

