/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.IArtifactRepositoryAdapter;
import com.ibm.cic.common.core.internal.artifactrepo.ArtifactRepositoryAdapters;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.IPath;

public class ArtifactPathMapperUtil {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static IPath toNamespaceUniquePath(IArtifactKey key) {
        String ns = key.getNamespace();
        IArtifactRepositoryAdapter adapter = ArtifactRepositoryAdapters.getAdapter(ns);
        if (adapter == null) {
            return null;
        }
        return adapter.toNamespaceUniquePath(key);
    }

    public static IArtifactKey toArtifactKey(IPath relPath) {
        if (relPath.segmentCount() < 2) {
            return null;
        }
        Collection namespaces = ArtifactRepositoryAdapters.getAdapterNamespaces();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String namespace : namespaces) {
            String[] dirs;
            String[] stringArray = dirs = ArtifactPathMapperUtil.enumerateTopLevelDirs(namespace);
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                String dir = stringArray[n2];
                map.put(dir, namespace);
                ++n2;
            }
        }
        String dir = relPath.segment(0);
        String pathNamespace = (String)map.get(dir);
        if (pathNamespace == null) {
            return null;
        }
        IArtifactRepositoryAdapter adapter = ArtifactRepositoryAdapters.getAdapter(pathNamespace);
        if (adapter == null) {
            return null;
        }
        return adapter.toNamespaceArtifactKey(relPath);
    }

    public static String[] getNamespaces() {
        Collection collection = ArtifactRepositoryAdapters.getAdapterNamespaces();
        return collection.toArray(new String[collection.size()]);
    }

    public static String[] enumerateTopLevelDirs(String namespace) {
        IArtifactRepositoryAdapter adapter = ArtifactRepositoryAdapters.getAdapter(namespace);
        if (adapter == null) {
            return EMPTY_STRING_ARRAY;
        }
        return adapter.enumerateTopLevelDirs();
    }
}

