/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.base.SingleArtifactOperationOptions;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.logging.Logger;
import java.util.Map;

public class AddOption
extends SingleArtifactOperationOptions {
    private static final Logger log = Logger.getLogger(AddOption.class);
    private UpdateMode updateMode;
    private final boolean checkOnly;
    private final Map<IArtifactKey, IArtifact> mismatchedArtifacts;

    public static AddOption newAddModeMismatchIsError() {
        return new AddOption(UpdateMode.ADD_LOG_MISMATCH_AS_ERROR);
    }

    public static AddOption newAddMode() {
        return new AddOption(UpdateMode.ADD);
    }

    public static AddOption newDefaultAddMode() {
        return AddOption.newAddMode();
    }

    private AddOption(UpdateMode updateMode, boolean checkOnly, Map<IArtifactKey, IArtifact> mismatchedArtifacts) {
        this.updateMode = updateMode;
        this.checkOnly = checkOnly;
        this.mismatchedArtifacts = mismatchedArtifacts;
    }

    public AddOption(UpdateMode updateMode, Map<IArtifactKey, IArtifact> mismatchedArtifacts) {
        this(updateMode, false, mismatchedArtifacts);
    }

    private AddOption(UpdateMode updateMode) {
        this(updateMode, false, null);
    }

    boolean isAddMode() {
        return this.updateMode.equals(UpdateMode.ADD) || this.updateMode.equals(UpdateMode.ADD_LOG_MISMATCH_AS_ERROR) || this.updateMode.equals(UpdateMode.ADD_DELTA);
    }

    public boolean isAddDeltaMode() {
        return this.updateMode.equals(UpdateMode.ADD_DELTA);
    }

    int getDigestMismatchSeverity() {
        return this.updateMode.equals(UpdateMode.ADD_LOG_MISMATCH_AS_ERROR) ? 4 : 0;
    }

    void addMismatchedArtifact(IArtifact artifact) {
        if (this.mismatchedArtifacts != null) {
            IArtifactKey key = artifact.getKey();
            if (this.mismatchedArtifacts.containsKey(key)) {
                log.debug("Artifact already found as mismatching: {0}", artifact);
                return;
            }
            this.mismatchedArtifacts.put(key, artifact);
        }
    }

    boolean isOverwriteMode() {
        return this.updateMode.equals(UpdateMode.OVERWRITE);
    }

    boolean getCheckOnly() {
        return this.checkOnly;
    }

    UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public void setUpdateMode(UpdateMode updateMode) {
        this.updateMode = updateMode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("updateMode=");
        sb.append(this.updateMode.toString());
        sb.append(" checkOnly=");
        sb.append(this.checkOnly);
        return sb.toString();
    }

    public static class UpdateMode {
        private final String name;
        public static final UpdateMode ADD = new UpdateMode("ADD");
        public static final UpdateMode ADD_DELTA = new UpdateMode("ADD_DELTA");
        public static final UpdateMode ADD_LOG_MISMATCH_AS_ERROR = new UpdateMode("ADD_LOG_MISMATCH_AS_ERROR");
        public static final UpdateMode OVERWRITE = new UpdateMode("OVERWRITE");

        private UpdateMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

