/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IArtifactSessionFactory;
import com.ibm.cic.common.core.artifactrepo.IContentLocator;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.NotValidatedPolicy;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTableOfContents;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactGet;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactTocRead;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.artifactrepo.ArtifactSession;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserNames;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadedFile;
import com.ibm.cic.common.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractReadArtifactRepo
implements IReadArtifactRepo,
IArtifactGet,
IArtifactTocRead {
    protected static final Logger log = Logger.getLogger(AbstractReadArtifactRepo.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    public static final String PROPERTY_SUPPRESS_ATOC_VALIDATION = "SUPPRESS_ATOC_VALIDATION";

    @Override
    public IStatus existsArtifact(IArtifactSession session, IArtifact artifact, IProgressMonitor monitor) {
        IArtifactLocator[] result = new IArtifactLocator[1];
        return this.getArtifactLocator(session, artifact, monitor, result);
    }

    public IStatus initializeArtifactRepository(IRepositoryInfo repInfo) {
        return Status.OK_STATUS;
    }

    @Override
    public abstract IRepository getRepository();

    public static ArtifactTableOfContents.Parameters getAtocParameters(IRepositoryInfo repoInfo) {
        boolean atocDigestsEnabled = UserOptions.useNonArtifactMD5s();
        Object prop = repoInfo.getProperty(PROPERTY_SUPPRESS_ATOC_VALIDATION);
        if (prop instanceof Boolean && ((Boolean)prop).booleanValue()) {
            atocDigestsEnabled = false;
        }
        ArtifactTableOfContents.Parameters atocParams = ArtifactTableOfContents.getDefaultAtocParams(atocDigestsEnabled);
        return atocParams;
    }

    @Override
    public boolean hasArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        if (session == null) {
            try (IArtifactSession callSession = IArtifactSessionFactory.INSTANCE.createArtifactSession();){
                boolean bl = this.hasArtifactToc(callSession, monitor);
                return bl;
            }
        }
        IReadArtifactRepo.IArtifactToc atoc = this.getArtifactToc(session, monitor);
        return ArtifactSession.ATOC_UNAVAILABLE != atoc;
    }

    /*
     * Loose catch block
     */
    @Override
    public IStatus getArtifactLocator(IArtifactSession session, IArtifact artifact, IProgressMonitor monitor, IArtifactLocator[] result) {
        if (artifact == null) {
            throw new NullPointerException();
        }
        if (monitor == null) {
            throw new NullPointerException();
        }
        if (result == null) {
            throw new NullPointerException();
        }
        if (result.length != 1) {
            throw new IllegalArgumentException();
        }
        if (session == null) {
            try (IArtifactSession singleCallSession = IArtifactSessionFactory.INSTANCE.createArtifactSession();){
                IStatus iStatus = this.getArtifactLocator(singleCallSession, artifact, monitor, result);
                return iStatus;
            }
        }
        monitor.beginTask("", 10);
        try {
            IReadArtifactRepo.IArtifactToc callToc = null;
            if (session.getSettings().getUseToc()) {
                try {
                    callToc = this.getArtifactToc(session, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (CoreException e) {
                    if (e.getStatus().matches(8)) {
                        IStatus iStatus = e.getStatus();
                        monitor.done();
                        return iStatus;
                    }
                    IStatus iStatus = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, e.getStatus(), null);
                    monitor.done();
                    return iStatus;
                }
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
            } else {
                monitor.worked(1);
            }
            IStatus iStatus = this.doGetArtifactLocatorChecked(session, callToc, artifact, (IProgressMonitor)new SubProgressMonitor(monitor, 9), result);
            return iStatus;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected IStatus doGetArtifactLocatorChecked(IArtifactSession session, IReadArtifactRepo.IArtifactToc atoc, IArtifact artifact, IProgressMonitor monitor, IArtifactLocator[] result) {
        try {
            monitor.beginTask("", 10);
            IContentInfo atocContentInfo = null;
            boolean checkedExist = false;
            if (atoc != null && atoc != ArtifactSession.ATOC_UNAVAILABLE) {
                IArtifact tocArtifact;
                block27: {
                    try {
                        tocArtifact = atoc.getTocArtifact(session, artifact.getKey(), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                        if (tocArtifact != null) break block27;
                        IStatus iStatus = AbstractReadArtifactRepo.createArtifactNotFoundStatus(0, this.getRepository(), artifact);
                        return iStatus;
                    }
                    catch (CoreException e) {
                        IStatus iStatus = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, e.getStatus(), null);
                        monitor.done();
                        return iStatus;
                    }
                }
                if (log.isDebugLoggable() && tocArtifact.isExploded() != artifact.isExploded()) {
                    String msg = tocArtifact.isExploded() ? NLS.bind((String)Messages.get_locator_with_unexploded_requested_stored_exploded, (Object)tocArtifact.toUserString()) : NLS.bind((String)Messages.get_locator_with_exploded_requested_stored_unexploded, (Object)tocArtifact.toUserString());
                    log.debug(msg);
                }
                atocContentInfo = tocArtifact.getContentInfo();
                checkedExist = true;
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            IStatus status = this.doGetArtifactLocator(session, artifact, atocContentInfo, (IProgressMonitor)new SubProgressMonitor(monitor, 8), result);
            if (!status.isOK()) {
                session.log(status);
            }
            if (status.matches(12)) {
                IStatus iStatus = status;
                return iStatus;
            }
            if (StatusCodes.isContentNotFound(status)) {
                IStatus iStatus = status;
                return iStatus;
            }
            if (!checkedExist) {
                IStatus statusExists = result[0].validateExists(0, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                if (StatusCodes.isContentNotFound(statusExists)) {
                    result[0] = null;
                    IStatus iStatus = statusExists;
                    return iStatus;
                }
                if (statusExists.matches(12)) {
                    IStatus iStatus = statusExists;
                    return iStatus;
                }
            }
            if (!session.getValidationPolicy().isValidationRequired()) {
                IStatus iStatus = status;
                return iStatus;
            }
            IStatus statusValidation = result[0].validate(NotValidatedPolicy.NVP_SILENT);
            if (!statusValidation.isOK()) {
                session.log(statusValidation);
            }
            if (status.matches(4)) {
                IStatus iStatus = statusValidation;
                return iStatus;
            }
            IStatus iStatus = statusValidation;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IReadArtifactRepo.IArtifactToc getArtifactToc(IArtifactSession session, boolean refresh, IProgressMonitor monitor) throws CoreException {
        if (refresh) {
            ArtifactSession.asSessionAtoc(session).setArtifactToc(this, null);
        }
        return AbstractReadArtifactRepo.getCachedArtifactToc(this, session, monitor);
    }

    static IReadArtifactRepo.IArtifactToc getCachedArtifactToc(IReadArtifactRepo repo, IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 1);
        try {
            IReadArtifactRepo.IArtifactToc atoc = ArtifactSession.asSessionAtoc(session).getArtifactToc(repo);
            if (atoc == null) {
                if (repo.getArtifactTocCapabilities().isTocSupported()) {
                    atoc = repo.readArtifactToc(session, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (atoc == null) {
                        atoc = ArtifactSession.ATOC_UNAVAILABLE;
                    }
                } else {
                    atoc = ArtifactSession.ATOC_UNAVAILABLE;
                    monitor.worked(1);
                }
                ArtifactSession.asSessionAtoc(session).setArtifactToc(repo, atoc);
            }
            IReadArtifactRepo.IArtifactToc iArtifactToc = atoc;
            return iArtifactToc;
        }
        finally {
            monitor.done();
        }
    }

    private IReadArtifactRepo.IArtifactToc getArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return AbstractReadArtifactRepo.getCachedArtifactToc(this, session, monitor);
    }

    protected abstract IStatus doGetArtifactLocator(IArtifactSession var1, IArtifact var2, IContentInfo var3, IProgressMonitor var4, IArtifactLocator[] var5);

    public static IStatus createArtifactNotFoundStatus(int severity, IRepository repo, IArtifact artifact) {
        UserNames context = repo != null ? repo.getUserNames() : null;
        String contextLocation = context != null ? context.getPureSystemName() : null;
        String msg = contextLocation == null || contextLocation.isEmpty() ? NLS.bind((String)Messages.artifact_does_not_exist, (Object)artifact.toUserString()) : NLS.bind((String)Messages.artifact_does_not_exist_in_repo, (Object)artifact.toUserString(), (Object)contextLocation);
        return Statuses.ST.createStatus(severity, 1, null, msg, new Object[0]);
    }

    public static IStatus createGetArtifactLocatorError(IArtifact artifact, IStatus childStatus, Exception e) {
        if (childStatus != null) {
            return AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, new IStatus[]{childStatus}, e);
        }
        return Statuses.ERROR.get(2, e, Messages.get_artifact_locator_failed, artifact.toUserString());
    }

    public static IStatus createGetArtifactLocatorError(IArtifact artifact, IStatus[] children, Exception e) {
        if (children != null) {
            return Statuses.ERROR.getMultiStatus(2, children, Messages.get_artifact_locator_failed, artifact.toUserString());
        }
        return Statuses.ERROR.get(2, e, Messages.get_artifact_locator_failed, artifact.toUserString());
    }

    public static IStatus createGetArtifactFileError(IArtifact artifact, IPath destination, IStatus[] children) {
        String msg = NLS.bind((String)Messages.error_get_artifact_file_failed, (Object)artifact.toUserString(), (Object)destination.toString());
        return Statuses.ST.createMultiStatus(100, children, msg, new Object[0]);
    }

    public static IStatus createGetArtifactFileError(IArtifact artifact, IPath destination, Throwable e) {
        String msg = NLS.bind((String)Messages.error_get_artifact_file_failed, (Object)artifact.toUserString(), (Object)destination.toString());
        return Statuses.ERROR.get(100, e, msg, new Object[0]);
    }

    protected IStatus createGetError(IArtifact artifact, IPath destination, IStatus childStatus) {
        return AbstractReadArtifactRepo.createGetArtifactFileError(artifact, destination, new IStatus[]{childStatus});
    }

    protected IStatus createGetError(IArtifact artifact, IPath destination, IStatus[] children) {
        return AbstractReadArtifactRepo.createGetArtifactFileError(artifact, destination, children);
    }

    @Override
    public IStatus getArtifactFile(IArtifactSession session, IArtifact artifact, IPath destination, IProgressMonitor monitor) {
        if (artifact == null) {
            throw new NullPointerException();
        }
        if (destination == null) {
            throw new NullPointerException();
        }
        if (monitor == null) {
            throw new NullPointerException();
        }
        ICicStatus statusDestination = FileUtil.checkDestination(destination.toFile());
        if (!statusDestination.isOK()) {
            return statusDestination;
        }
        IArtifactSession singleCallSession = null;
        IArtifactSession callSession = null;
        callSession = session == null ? (singleCallSession = IArtifactSessionFactory.INSTANCE.createArtifactSession()) : session;
        try {
            IStatus status;
            IStatus iStatus = status = this.doGetArtifactFileChecked(callSession, artifact, destination, monitor);
            return iStatus;
        }
        finally {
            if (singleCallSession != null) {
                singleCallSession.close();
            }
        }
    }

    protected IStatus doGetArtifactFileChecked(IArtifactSession session, IArtifact artifact, IPath destination, IProgressMonitor monitor) {
        String task = NLS.bind((String)Messages.task_simple_get_artifact, (Object)artifact.toUserString());
        monitor.beginTask("", 10);
        monitor.subTask(task);
        try {
            IArtifactLocator[] resultLocator = new IArtifactLocator[1];
            IStatus statusGetLocator = RepoAs.IArtifactGet(this).getArtifactLocator(session, artifact, (IProgressMonitor)new SubProgressMonitor(monitor, 1), resultLocator);
            if (StatusCodes.isContentNotFound(statusGetLocator)) {
                IStatus iStatus = AbstractReadArtifactRepo.createArtifactNotFoundStatus(4, this.getRepository(), artifact);
                return iStatus;
            }
            if (statusGetLocator.matches(8)) {
                IStatus iStatus = statusGetLocator;
                return iStatus;
            }
            if (statusGetLocator.matches(4)) {
                IStatus iStatus = this.createGetError(artifact, destination, statusGetLocator);
                return iStatus;
            }
            IArtifactLocator locator = resultLocator[0];
            long[] outReadBytes = new long[1];
            IStatus statusGetFile = this.doGetArtifactFile(session, artifact.getContentInfo(), locator, destination, (IProgressMonitor)new SubProgressMonitor(monitor, 9), outReadBytes);
            if (statusGetFile.matches(4)) {
                session.log(statusGetFile);
            }
            IStatus iStatus = statusGetFile;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected IStatus doGetArtifactFile(IArtifactSession session, IContentInfo expectedContentInfo, IContentLocator locator, IPath destination, IProgressMonitor monitor, long[] outReadBytes) {
        IDownloadedFile dlUncached = locator.downloadToFile(session, destination, monitor);
        return dlUncached.getStatus();
    }

    public static IStatus createGetArtifactFilesFailedOperationError(String location, IStatus childStatus, Exception e) {
        if (childStatus != null) {
            return AbstractReadArtifactRepo.createGetArtifactFilesFailedOperationError(location, new IStatus[]{childStatus}, e);
        }
        String msg = NLS.bind((String)Messages.get_artifact_files_failed, (Object)location);
        return Statuses.ERROR.get(3, e, msg, new Object[0]);
    }

    public static IStatus createGetArtifactFilesFailedOperationError(String location, IStatus[] children, Exception e) {
        String msg = NLS.bind((String)Messages.get_artifact_files_failed, (Object)location);
        if (children != null) {
            return Statuses.ST.createMultiStatus(3, children, msg, new Object[0]);
        }
        return Statuses.ERROR.get(3, e, msg, new Object[0]);
    }

    @Override
    public IReadArtifactRepo.IArtifactTocCapabilities getArtifactTocCapabilities() {
        return IReadArtifactRepo.IArtifactTocCapabilities.NOT_SUPPORTED;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IReadArtifactRepo.class) {
            return this;
        }
        if (adapter == IArtifactGet.class) {
            return this;
        }
        if (adapter == IArtifactTocRead.class) {
            return this;
        }
        return null;
    }
}

