/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.base;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IArtifactSessionFactory;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperationMultiple;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.internal.artifactrepo.ArtifactRecords;
import com.ibm.cic.common.downloads.DownloadUI;
import com.ibm.cic.common.downloads.IDownloadUI;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

abstract class ArtifactOperationMultiple
implements IArtifactOperationMultiple {
    private final boolean supportsSuspendResume;

    protected ArtifactOperationMultiple(boolean supportsSuspendResume) {
        this.supportsSuspendResume = supportsSuspendResume;
    }

    @Override
    public Collection<IStatus> getTotalStatusCollection(IMultiArtifactOperationArguments records) {
        ArrayList<IStatus> statusList = new ArrayList<IStatus>(records.getRecords().size());
        for (IArtifactOperation.IArtifactOperationRecord dlRecord : records.getRecords()) {
            IStatus status = dlRecord.getTotalStatus();
            statusList.add(status);
        }
        return statusList;
    }

    @Override
    public IMultiArtifactOperationArguments createArguments() {
        return new ArtifactRecords();
    }

    @Override
    public final void execute(IArtifactSession session, IArtifactOperation.IOperationContext target, MultiArtifactOperationOptions options, IMultiArtifactOperationArguments arguments, IProgressMonitor monitor) {
        if (arguments == null) {
            throw new NullPointerException();
        }
        if (target == null) {
            throw new NullPointerException();
        }
        if (monitor == null) {
            throw new NullPointerException();
        }
        if (monitor.isCanceled()) {
            arguments.setCanceled();
            return;
        }
        if (session == null) {
            try (IArtifactSession singleCallSession = IArtifactSessionFactory.INSTANCE.createArtifactSession();){
                this.execute(singleCallSession, target, options, arguments, monitor);
            }
        }
        IDownloadUI ui = null;
        if (this.supportsSuspendResume) {
            ui = DownloadUI.INSTANCE.getUI();
            DownloadUI.beginDownloads(ui);
        }
        try {
            this.doExecute(session, target, arguments, options, monitor);
        }
        finally {
            target.release();
            if (this.supportsSuspendResume) {
                DownloadUI.endDownloads(ui);
            }
        }
    }

    protected abstract void doExecute(IArtifactSession var1, IArtifactOperation.IOperationContext var2, IMultiArtifactOperationArguments var3, MultiArtifactOperationOptions var4, IProgressMonitor var5);
}

