/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo;

import com.ibm.cic.common.core.artifactrepo.IAlternativeRepositories;
import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IContentLocator;
import com.ibm.cic.common.core.artifactrepo.base.AddArtifactsProgress;
import com.ibm.cic.common.core.artifactrepo.base.ArtifactOperationStatusSummary;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperationMultiple;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.impl.IMasterSetupDiskExtensions;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.artifactrepo.ArtifactGroupUtil;
import com.ibm.cic.common.core.internal.artifactrepo.DownloadAccessMonitor;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.IFilterRepository;
import com.ibm.cic.common.core.repository.IReopenRepositoryPrompter;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryIdentity;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.IDownloadListener;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class AssignArtifacts {
    private static final Logger log = Logger.getLogger(AssignArtifacts.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    private final Map<IRepositoryIdentity, IMultiArtifactOperationArguments> mapRepoIdentityToArgs = new LinkedHashMap<IRepositoryIdentity, IMultiArtifactOperationArguments>();
    private final Map<IRepositoryIdentity, IRepository> mapRepoIdentityToRepo = new LinkedHashMap<IRepositoryIdentity, IRepository>();
    private final Map<IArtifact, IArtifactOperation.IArtifactOperationRecord> artifacts = new LinkedHashMap<IArtifact, IArtifactOperation.IArtifactOperationRecord>();
    private IRepository[] srcRepos;
    private Map<IRepositoryIdentity, IStatus> validatedSrcRepo = new LinkedHashMap<IRepositoryIdentity, IStatus>();
    private final IArgumentFactory factory;
    private final List<IRepository> alternativeReposUsed;
    private IAlternativeRepositories alternativeRepos;
    private final ILazySourceRepositoriesFactory lazySourceRepositoriesFactory;
    private static final IAlternativeRepositories NULL_ALTERNATIVE_REPOS = new IAlternativeRepositories(){

        @Override
        public IAlternativeRepositories.IAlternativeArtifactRepositories getAlternativeRepos(IAlternativeRepositories.ISkipRepositoryFilter skipRepoFilter, Object parentIu, IArtifact artifact, IProgressMonitor monitor) {
            return NULL_ALTERNATIVE_ARTIFACT_REPOS;
        }

        @Override
        public void done() {
        }
    };
    private static final IAlternativeRepositories.IAlternativeArtifactRepositories NULL_ALTERNATIVE_ARTIFACT_REPOS = new IAlternativeRepositories.IAlternativeArtifactRepositories(){

        @Override
        public int count() {
            return 0;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public IReopenRepositoryPrompter.ReopenRepositoryResult nextRepo(IArtifactSession session) {
            throw new NoSuchElementException();
        }
    };

    public IAlternativeRepositories getAlternativeRepos() {
        if (this.alternativeRepos == null) {
            this.alternativeRepos = this.lazySourceRepositoriesFactory.getAlternativeRepositories();
            if (this.alternativeRepos == null) {
                this.alternativeRepos = NULL_ALTERNATIVE_REPOS;
            }
        }
        return this.alternativeRepos;
    }

    public AssignArtifacts(final IRepositoryGroup group, final IAlternativeRepositories alternativeRepositories, IArgumentFactory entryFactory) {
        this(new ILazySourceRepositoriesFactory(){

            @Override
            public IAlternativeRepositories getAlternativeRepositories() {
                return alternativeRepositories;
            }

            @Override
            public IRepositoryGroup createSourceRepositoriesGroup(IProgressMonitor monitor) {
                return group;
            }

            @Override
            public DiskSetPriority determineDiskSetsPriority(IVolumeAccessByDisk diskRepo, IArtifactSession session, IVolumeAccessByDisk.IDiskSet[] allDiskSets, IProgressMonitor monitor) {
                return null;
            }

            @Override
            public IStatus validateRepository(IRepository repo, IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        }, entryFactory);
    }

    public AssignArtifacts(ILazySourceRepositoriesFactory lazySourceRepositoriesFactory, IArgumentFactory entryFactory) {
        this.factory = entryFactory;
        this.alternativeReposUsed = new ArrayList<IRepository>();
        this.lazySourceRepositoriesFactory = lazySourceRepositoriesFactory;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(50 * this.artifacts.size());
        for (IArtifact artifact : this.artifacts.keySet()) {
            sb.append(artifact).append('\n');
        }
        return sb.toString();
    }

    public IStatus assignArtifact(IArtifactSession session, IRepository fromRepo, Object artifactParent, IArtifact artifact, IProgressMonitor monitor) {
        return this.assignArtifact(session, fromRepo, artifactParent, artifact, true, monitor);
    }

    public IStatus assignArtifact(IArtifactSession session, IRepository fromRepo, Object artifactParent, IArtifact artifact, boolean errorOnNotFound, IProgressMonitor monitor) {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 2);
        if (this.artifacts.containsKey(artifact)) {
            log.debug("Artifact already requested: {0}", artifact);
            pm.done();
            return Status.OK_STATUS;
        }
        AssignedArtifact[] aaRef = new AssignedArtifact[1];
        IStatus status = this.getAssignedArtifact(session, fromRepo, artifactParent, artifact, errorOnNotFound, pm.next(), aaRef);
        if (StatusCodes.isContentFound(status)) {
            this.addAssignedArtifact(aaRef[0]);
            status = Status.OK_STATUS;
        }
        return status;
    }

    public void addAssignedArtifact(IRepository repo, IArtifact artifact, IArtifactLocator locator) {
        if (this.artifacts.containsKey(artifact)) {
            log.debug("Artifact already requested: {0}", artifact);
            return;
        }
        AssignedArtifact aa = new AssignedArtifact(artifact, repo, locator);
        this.addAssignedArtifact(aa);
    }

    public IArtifactOperation.IArtifactOperationRecord getAssignedRecord(IArtifact artifact) {
        return this.artifacts.get(artifact);
    }

    public Collection<IRepository> getAssignedRepos() {
        return Collections.unmodifiableCollection(this.mapRepoIdentityToRepo.values());
    }

    public IMultiArtifactOperationArguments getArguments(IRepository sourceRepo) {
        IRepositoryIdentity repoIdentity = (IRepositoryIdentity)sourceRepo.getAdapter(IRepositoryIdentity.class);
        return this.mapRepoIdentityToArgs.get(repoIdentity);
    }

    public Collection<IArtifact> getAssignedArtifacts(IRepository repo) {
        IMultiArtifactOperationArguments args = this.getArguments(repo);
        if (args == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IArtifact> repoArtifacts = new ArrayList<IArtifact>(args.getRecordCount());
        List<IArtifactOperation.IArtifactOperationRecord> records = args.getRecords();
        for (IArtifactOperation.IArtifactOperationRecord record : records) {
            IArtifact artifact = this.factory.getArtifact(record.getInput());
            if (artifact == null) continue;
            repoArtifacts.add(artifact);
        }
        return repoArtifacts;
    }

    public IStatus execute(IArtifactSession session, IContextFactory contextFactory, IArtifactOperationMultiple op, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
        this.executeWithoutStatusSummary(session, contextFactory, op, options, monitor);
        return this.getSummaryStatus(op, false, true);
    }

    private IStatus getFailedStatus() {
        for (IRepository sourceRepo : this.getAssignedRepos()) {
            IMultiArtifactOperationArguments args = this.getArguments(sourceRepo);
            IStatus failedStatus = args.getFailedOperationStatus();
            if (!failedStatus.matches(12)) continue;
            return failedStatus;
        }
        return Status.OK_STATUS;
    }

    public Collection<IStatus> getStatusCollection(IArtifactOperationMultiple op, boolean makeNotFoundsErrors, boolean addRepoAllNotOkStatus) {
        ArrayList<IStatus> statusCollection = new ArrayList<IStatus>(this.getArtifacts().size());
        for (IRepository sourceRepo : this.getAssignedRepos()) {
            IStatus failedStatus;
            IMultiArtifactOperationArguments args = this.getArguments(sourceRepo);
            if (addRepoAllNotOkStatus && !(failedStatus = args.getFailedOperationStatus()).isOK()) {
                statusCollection.add(failedStatus);
            }
            Collection<IStatus> repoCollection = op.getTotalStatusCollection(args);
            if (makeNotFoundsErrors) {
                repoCollection = AssignArtifacts.recodeNotFoundStatusToError(repoCollection);
            }
            statusCollection.addAll(repoCollection);
        }
        return statusCollection;
    }

    private IStatus getSummaryStatus(IArtifactOperationMultiple op, boolean makeNotFoundsErrors, boolean addRepoAllNotOkStatus) {
        IStatus failedStatus = this.getFailedStatus();
        if (!failedStatus.isOK()) {
            return failedStatus;
        }
        Collection<IStatus> statusCollection = this.getStatusCollection(op, makeNotFoundsErrors, addRepoAllNotOkStatus);
        return AssignArtifacts.getSummaryStatus(statusCollection, true);
    }

    public static IStatus getSummaryStatus(Collection<IStatus> statusCollection, boolean includeWarnings) {
        ArtifactOperationStatusSummary statusSummary = new ArtifactOperationStatusSummary(statusCollection);
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        if (statusSummary.matchesMostSevereStatus(8)) {
            if (statusSummary.getCancelMultiStatus().hasChildren()) {
                result.addAll((IStatus)statusSummary.getCancelMultiStatus());
                return result;
            }
            return Status.CANCEL_STATUS;
        }
        if (statusSummary.matchesMostSevereNonCancelOrNotFound(4)) {
            result.addAll((IStatus)statusSummary.getErrorMultiStatus());
            if (includeWarnings) {
                result.addAll((IStatus)statusSummary.getWarningMultiStatus());
            }
        } else if (includeWarnings && statusSummary.matchesMostSevereNonCancelOrNotFound(2)) {
            result.addAll((IStatus)statusSummary.getWarningMultiStatus());
        } else if (statusSummary.getNotFoundMultiStatus().hasChildren()) {
            result.addAll((IStatus)statusSummary.getNotFoundMultiStatus());
        } else if (statusSummary.getRequestedOKMultiStatus().hasChildren()) {
            result.addAll((IStatus)statusSummary.getRequestedOKMultiStatus());
        }
        return result;
    }

    public static Collection<IStatus> recodeNotFoundStatusToError(Collection<IStatus> statusList) {
        return AssignArtifacts.recodeNotFoundStatusToSeverity(statusList, 4);
    }

    private static Collection<IStatus> recodeNotFoundStatusToSeverity(Collection<IStatus> statusList, int severity) {
        ArrayList<IStatus> list = new ArrayList<IStatus>(statusList.size());
        for (IStatus status : statusList) {
            list.add(StatusCodes.recodeNotFoundToSeverity(status, severity));
        }
        return list;
    }

    public void executeWithoutStatusSummary(IArtifactSession session, IContextFactory contextFactory, IArtifactOperationMultiple op, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
        IMultiArtifactOperationArguments args;
        if (contextFactory == null && this.factory instanceof IContextFactory) {
            contextFactory = (IContextFactory)((Object)this.factory);
        }
        AddArtifactsProgress.AddArtifactsProgressHelper progressHelper = new AddArtifactsProgress.AddArtifactsProgressHelper(session);
        AddArtifactsProgress addArtifactsProgress = new AddArtifactsProgress();
        for (IRepository sourceRepo : this.getAssignedRepos()) {
            args = this.getArguments(sourceRepo);
            addArtifactsProgress.addRepositoryToTotals(sourceRepo, args);
        }
        addArtifactsProgress.begin(options, monitor);
        try {
            for (IRepository sourceRepo : this.getAssignedRepos()) {
                args = this.getArguments(sourceRepo);
                IArtifactOperation.IOperationContext context = contextFactory.createContext(sourceRepo);
                op.execute(session, context, options, args, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                IStatus failedStatus = args.getFailedOperationStatus();
                if (failedStatus.matches(12)) {
                    return;
                }
                Collection<IStatus> statusCollection = AssignArtifacts.recodeNotFoundStatusToError(op.getTotalStatusCollection(args));
                IStatus summaryStatus = AssignArtifacts.getSummaryStatus(statusCollection, false);
                if (!summaryStatus.matches(12)) continue;
                return;
            }
        }
        finally {
            this.getAlternativeRepos().done();
            addArtifactsProgress.done(options);
            progressHelper.restorePrevious();
        }
    }

    private static IStatus getAssignedArtifactOneRepo(IArtifactSession session, IRepository srcRepo, IArtifact artifact, IProgressMonitor monitor, AssignedArtifact[] aaRef) {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 2);
        try {
            boolean canGetLocator;
            IVolumeAccessByDisk byDisk = RepoAs.IVolumeAccessByDisk(srcRepo);
            IStatus status = Status.OK_STATUS;
            if (byDisk != null) {
                try {
                    canGetLocator = byDisk.canGetLocatorsFromDisk1(pm.next());
                }
                catch (CoreException e) {
                    canGetLocator = false;
                    status = e.getStatus();
                }
            } else {
                canGetLocator = true;
                pm.next();
            }
            if (status.matches(8)) {
                IStatus iStatus = status;
                return iStatus;
            }
            if (status.matches(4)) {
                IStatus iStatus = status;
                return iStatus;
            }
            if (canGetLocator) {
                IArtifactLocator[] locatorRef = new IArtifactLocator[1];
                status = RepoAs.IArtifactGet(srcRepo).getArtifactLocator(session, artifact, pm.next(), locatorRef);
                if (StatusCodes.isContentFound(status)) {
                    aaRef[0] = new AssignedArtifact(artifact, srcRepo, locatorRef[0]);
                }
            } else {
                status = RepoAs.IArtifactGet(srcRepo).existsArtifact(session, artifact, pm.next());
                if (StatusCodes.isContentFound(status)) {
                    aaRef[0] = new AssignedArtifact(artifact, srcRepo, null);
                }
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            pm.done();
        }
    }

    private IRepository[] getSourceRepositoryArray(IArtifactSession session, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        if (this.srcRepos == null) {
            IRepositoryGroup group = this.lazySourceRepositoriesFactory.createSourceRepositoriesGroup((IProgressMonitor)sm.newChild(1));
            ArrayList<IRepository> repoList = new ArrayList<IRepository>(group.size() + 1);
            ArrayList<IRepository> repoListMasterSecondary = new ArrayList<IRepository>(group.size());
            repoList.add(null);
            sm.setWorkRemaining(group.size());
            for (IRepository repository : group) {
                this.addRepo(repoList, repoListMasterSecondary, session, repository, (IProgressMonitor)sm.newChild(1));
            }
            ArrayList<IRepository> repoListAll = new ArrayList<IRepository>(repoList.size() + repoListMasterSecondary.size());
            repoListAll.addAll(repoList);
            repoListAll.addAll(repoListMasterSecondary);
            this.srcRepos = repoListAll.toArray(new IRepository[repoListAll.size()]);
            this.validatedSrcRepo = new LinkedHashMap<IRepositoryIdentity, IStatus>(group.size());
        }
        sm.setWorkRemaining(0);
        return this.srcRepos;
    }

    /*
     * Exception decompiling
     */
    private void addRepo(Collection<IRepository> primaryRepoList, Collection<IRepository> secondaryRepoList, IArtifactSession session, IRepository repo, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addByDiskSetPriority(IMasterSetupDiskExtensions msrFilterFactory, Collection<IRepository> primaryRepoList, Collection<IRepository> secondaryRepoList, String repoLoc, DiskSetPriority diskSetPriority) {
        IFilterRepository primaryRepo = msrFilterFactory.createFilteredRepositoryView(new IMasterSetupDiskExtensions.VisibleDiskSetsFilter(diskSetPriority.getPrimaryDiskSets()));
        primaryRepoList.add(primaryRepo);
        log.debug("Source repository using primary disk sets: {0}\n\t{1}", repoLoc, Arrays.asList(diskSetPriority.getPrimaryDiskSets()));
        IVolumeAccessByDisk.IDiskSet[] secondaryDiskSets = diskSetPriority.getSecondaryDiskSets();
        if (secondaryDiskSets != null && secondaryDiskSets.length > 0) {
            IFilterRepository secondaryRepo = msrFilterFactory.createFilteredRepositoryView(new IMasterSetupDiskExtensions.VisibleDiskSetsFilter(secondaryDiskSets));
            secondaryRepoList.add(secondaryRepo);
            log.debug("Source repository using secondary disk sets: {0}\n\t{1}", repoLoc, Arrays.asList(secondaryDiskSets));
        }
    }

    private IStatus getAssignedArtifact(IArtifactSession session, final IRepository fromRepo, Object artifactParent, IArtifact artifact, boolean errorOnNotFound, IProgressMonitor monitor, AssignedArtifact[] aaRef) {
        try (UpdateSubTaskHelper updateTaskHelper = new UpdateSubTaskHelper(monitor);){
            IStatus status;
            LinkedList<IStatus> allStatus = new LinkedList<IStatus>();
            IRepository[] src = this.getSourceRepositoryArray(session, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            src[0] = fromRepo;
            SplitProgressMonitor pm = new SplitProgressMonitor(monitor, src.length + this.alternativeReposUsed.size() + 1);
            int i = 0;
            while (i < src.length) {
                IRepository srcRepo = src[i];
                if (srcRepo != null && (srcRepo != fromRepo || i == 0)) {
                    if (!this.hasBeenCheckedValidSrcRepo(srcRepo) && !(status = this.checkValidSrcRepo(srcRepo, (IProgressMonitor)new SubProgressMonitor(monitor, 0))).isOK()) {
                        IStatus skipStatus = this.makeSkipPreferenceRepoStatus(srcRepo, status);
                        if (status.matches(8)) {
                            log.status(skipStatus);
                            IStatus iStatus = status;
                            return iStatus;
                        }
                        allStatus.add(skipStatus);
                    } else {
                        updateTaskHelper.updateTask(srcRepo);
                        status = AssignArtifacts.getAssignedArtifactOneRepo(session, srcRepo, artifact, pm.next(), aaRef);
                        if (status.matches(8)) {
                            AssignArtifacts.logGetArtifactIntermediateIssues(artifact, allStatus);
                            IStatus iStatus = status;
                            return iStatus;
                        }
                        if (StatusCodes.isContentFound(status)) {
                            AssignArtifacts.logGetArtifactIntermediateIssues(artifact, allStatus);
                            IStatus iStatus = status;
                            return iStatus;
                        }
                        allStatus.add(status);
                    }
                }
                ++i;
            }
            for (IRepository srcRepo : this.alternativeReposUsed) {
                updateTaskHelper.updateTask(srcRepo);
                status = AssignArtifacts.getAssignedArtifactOneRepo(session, srcRepo, artifact, pm.next(), aaRef);
                if (status.matches(8)) {
                    AssignArtifacts.logGetArtifactIntermediateIssues(artifact, allStatus);
                    IStatus iStatus = status;
                    return iStatus;
                }
                if (StatusCodes.isContentFound(status)) {
                    AssignArtifacts.logGetArtifactIntermediateIssues(artifact, allStatus);
                    IStatus iStatus = status;
                    return iStatus;
                }
                allStatus.add(status);
            }
            SplitProgressMonitor spmAlternatives = new SplitProgressMonitor(pm.next(), 2);
            IAlternativeRepositories.IAlternativeArtifactRepositories alternativeReposForArtifact = this.getAlternativeRepos().getAlternativeRepos(new IAlternativeRepositories.ISkipRepositoryFilter(){

                @Override
                public boolean skip(IRepositoryInfo repoInfo) {
                    return AssignArtifacts.this.alreadyOpened(fromRepo, repoInfo);
                }
            }, artifactParent, artifact, spmAlternatives.next());
            SplitProgressMonitor spmUseAlternatives = new SplitProgressMonitor(spmAlternatives.next(), alternativeReposForArtifact.count());
            while (alternativeReposForArtifact.hasNext()) {
                IReopenRepositoryPrompter.ReopenRepositoryResult rr = alternativeReposForArtifact.nextRepo(session);
                IStatus status2 = rr.getStatus();
                if (status2.matches(8)) {
                    AssignArtifacts.logGetArtifactIntermediateIssues(artifact, allStatus);
                    IStatus iStatus = status2;
                    return iStatus;
                }
                if (rr.getRepository() == null) continue;
                this.alternativeReposUsed.add(rr.getRepository());
                updateTaskHelper.updateTask(rr.getRepository());
                status2 = AssignArtifacts.getAssignedArtifactOneRepo(session, rr.getRepository(), artifact, spmUseAlternatives.next(), aaRef);
                if (status2.matches(8)) {
                    AssignArtifacts.logGetArtifactIntermediateIssues(artifact, allStatus);
                    IStatus iStatus = status2;
                    return iStatus;
                }
                if (StatusCodes.isContentFound(status2)) {
                    spmUseAlternatives.done();
                    AssignArtifacts.logGetArtifactIntermediateIssues(artifact, allStatus);
                    IStatus iStatus = status2;
                    return iStatus;
                }
                allStatus.add(status2);
            }
            spmUseAlternatives.done();
            IStatus iStatus = AssignArtifacts.createNotFoundStatus(artifact, allStatus, errorOnNotFound);
            return iStatus;
        }
    }

    private IStatus makeSkipPreferenceRepoStatus(IRepository srcRepo, IStatus status) {
        IStatus warning = MultiStatusUtil.recodeLevel(status, 12, 2);
        return warning;
    }

    private IStatus checkValidSrcRepo(IRepository srcRepo, IProgressMonitor monitor) {
        IRepositoryIdentity repoId = (IRepositoryIdentity)srcRepo.getAdapter(IRepositoryIdentity.class);
        IStatus status = this.validatedSrcRepo.get(repoId);
        if (status == null) {
            status = this.lazySourceRepositoriesFactory.validateRepository(srcRepo, monitor);
            this.validatedSrcRepo.put(repoId, status);
        }
        return status;
    }

    private boolean isValidSrcRepo(IRepository srcRepo) {
        IRepositoryIdentity repoId = (IRepositoryIdentity)srcRepo.getAdapter(IRepositoryIdentity.class);
        IStatus status = this.validatedSrcRepo.get(repoId);
        return status != null && status.isOK();
    }

    private boolean hasBeenCheckedValidSrcRepo(IRepository srcRepo) {
        IRepositoryIdentity repoId = (IRepositoryIdentity)srcRepo.getAdapter(IRepositoryIdentity.class);
        IStatus status = this.validatedSrcRepo.get(repoId);
        return status != null;
    }

    private boolean alreadyOpened(IRepository fromRepo, IRepositoryInfo repoInfo) {
        String srcRepoInfoKey;
        String repoInfoKey = repoInfo.serialize();
        int i = 0;
        while (i < this.srcRepos.length) {
            IRepository srcRepo = this.srcRepos[i];
            if (srcRepo != null && (srcRepo != fromRepo || i == 0) && this.isValidSrcRepo(srcRepo) && (srcRepoInfoKey = srcRepo.getRepositoryInfo().serialize()).equals(repoInfoKey)) {
                return true;
            }
            ++i;
        }
        for (IRepository srcRepo : this.alternativeReposUsed) {
            srcRepoInfoKey = srcRepo.getRepositoryInfo().serialize();
            if (!srcRepoInfoKey.equals(repoInfoKey)) continue;
            return true;
        }
        return false;
    }

    private static void logGetArtifactIntermediateIssues(IArtifact artifact, List<IStatus> allStatus) {
        ArtifactGroupUtil.logGetArtifactIntermediateIssues(log, artifact, allStatus);
    }

    private static IStatus createNotFoundStatus(IArtifact artifact, List<IStatus> allStatus, boolean errorOnNotFound) {
        Collection<IStatus> recodedStatuses;
        if (allStatus.size() == 1) {
            IStatus status = allStatus.get(0);
            return errorOnNotFound ? MultiStatusUtil.recodeLevel(allStatus.get(0), 4) : status;
        }
        if (allStatus.size() == 0) {
            return new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 1, NLS.bind((String)Messages.AssignArtifacts_Artifact_Not_Found_No_Source_Repositories, (Object)artifact.toUserString()), null);
        }
        int severity = errorOnNotFound || AssignArtifacts.statusListContainsErrors(allStatus) ? 4 : 0;
        CicMultiStatus result = Statuses.ST.createMultiStatus(severity, 1, (recodedStatuses = AssignArtifacts.recodeNotFoundStatusToSeverity(allStatus, severity)).toArray(new IStatus[recodedStatuses.size()]), null, Messages.AssignArtifacts_Artifact_Not_Found, artifact.toUserString());
        if (result.getSeverity() != severity || !result.matches(8)) {
            return MultiStatusUtil.recodeLevel(result, severity);
        }
        return result;
    }

    private static boolean statusListContainsErrors(List<IStatus> statuses) {
        for (IStatus status : statuses) {
            if (!status.matches(4)) continue;
            return true;
        }
        return false;
    }

    private IMultiArtifactOperationArguments getRepoArgs(IRepository sourceRepo) {
        IRepositoryIdentity repoIdentity = (IRepositoryIdentity)sourceRepo.getAdapter(IRepositoryIdentity.class);
        assert (repoIdentity != null);
        IMultiArtifactOperationArguments args = this.mapRepoIdentityToArgs.get(repoIdentity);
        if (args == null) {
            args = this.factory.createArguments();
            this.mapRepoIdentityToArgs.put(repoIdentity, args);
            this.mapRepoIdentityToRepo.put(repoIdentity, sourceRepo);
        }
        return args;
    }

    private void addAssignedArtifact(AssignedArtifact aa) {
        IArtifact artifact = aa.getArtifact();
        IRepository sourceRepo = aa.getRepo();
        IArtifactOperation.IArtifactOperationInput input = this.factory.createInput(artifact, sourceRepo, aa.getArtifactLocator());
        IArtifactOperation.IArtifactOperationRecord record = this.getRepoArgs(sourceRepo).addInput(input);
        this.artifacts.put(artifact, record);
    }

    public boolean contains(IArtifact artifact) {
        return this.artifacts.containsKey(artifact);
    }

    public Collection<IArtifact> getArtifacts() {
        return this.artifacts.keySet();
    }

    private static class AssignedArtifact {
        private final IArtifact artifact;
        private final IRepository repo;
        private final IArtifactLocator locator;

        public AssignedArtifact(IArtifact artifact, IRepository repo, IArtifactLocator locator) {
            this.artifact = artifact;
            this.repo = repo;
            this.locator = locator;
        }

        public IArtifact getArtifact() {
            return this.artifact;
        }

        public IRepository getRepo() {
            return this.repo;
        }

        public IArtifactLocator getArtifactLocator() {
            return this.locator;
        }
    }

    public static class DiskSetPriority {
        private final IVolumeAccessByDisk.IDiskSet[] primaryDiskSets;
        private final IVolumeAccessByDisk.IDiskSet[] secondaryDiskSets;

        public DiskSetPriority(IVolumeAccessByDisk.IDiskSet[] primaryDiskSets, IVolumeAccessByDisk.IDiskSet[] secondaryDiskSets) {
            this.primaryDiskSets = primaryDiskSets;
            this.secondaryDiskSets = secondaryDiskSets;
        }

        public IVolumeAccessByDisk.IDiskSet[] getPrimaryDiskSets() {
            return this.primaryDiskSets;
        }

        public IVolumeAccessByDisk.IDiskSet[] getSecondaryDiskSets() {
            return this.secondaryDiskSets;
        }
    }

    public static interface IArgumentFactory {
        public IMultiArtifactOperationArguments createArguments();

        public IArtifactOperation.IArtifactOperationInput createInput(IArtifact var1, IRepository var2, IContentLocator var3);

        public IArtifact getArtifact(IArtifactOperation.IArtifactOperationInput var1);
    }

    public static interface IContextFactory {
        public IArtifactOperation.IOperationContext createContext(IRepository var1);
    }

    public static interface IDetermineDiskSetsPriorities {
        public DiskSetPriority determineDiskSetsPriority(IVolumeAccessByDisk var1, IArtifactSession var2, IVolumeAccessByDisk.IDiskSet[] var3, IProgressMonitor var4) throws CoreException, IOException;
    }

    public static interface ILazySourceRepositoriesFactory
    extends IDetermineDiskSetsPriorities {
        public IAlternativeRepositories getAlternativeRepositories();

        public IRepositoryGroup createSourceRepositoriesGroup(IProgressMonitor var1);

        public IStatus validateRepository(IRepository var1, IProgressMonitor var2);
    }

    public static interface IOperationFactory
    extends IArgumentFactory,
    IContextFactory {
    }

    private static class UpdateSubTaskHelper {
        private final IProgressMonitor monitor;
        private final DownloadAccessMonitor accessMonitor;
        private String fTask = "";

        UpdateSubTaskHelper(IProgressMonitor monitor) {
            this.monitor = new SubProgressMonitor(monitor, 0){
                private String prevSubTask;
                {
                    super($anonymous0, $anonymous1);
                    this.prevSubTask = null;
                }

                public void subTask(String name) {
                    if (name != null) {
                        if (name.equals(this.prevSubTask)) {
                            return;
                        }
                        this.prevSubTask = name;
                    }
                    super.subTask(name);
                }
            };
            this.accessMonitor = new DownloadAccessMonitor(new DownloadAccessMonitor.StartAccessCallback(){

                @Override
                public void startAccess(IDownloadListener.Access access) {
                    this.updateAccess();
                }
            });
        }

        public void updateTask(IRepository srcRepo) {
            String msg = NLS.bind((String)Messages.AssignArtifacts_CollectingForRepo, (Object)srcRepo.getLocationStr());
            this.update(msg);
        }

        public void update(String task) {
            this.fTask = task;
            IDownloadListener.Access access = this.accessMonitor.getAccess(3000L, true);
            if (access != null) {
                this.updateAccess();
            } else {
                this.monitor.subTask(task);
            }
        }

        private void updateAccess() {
            String taskMsg = NLS.bind((String)Messages.AssignArtifacts_AccessingDetail, (Object)this.fTask);
            this.monitor.subTask(taskMsg);
        }

        public void close() {
            this.accessMonitor.close();
        }
    }
}

