/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.api.utils;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.logging.Logger;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.core.runtime.Plugin;

public class EncryptionUtils {
    private static final byte[] SYMMETRIC_KEY = new byte[]{66, 84, 81, 79, 108, 108, 43, 89, 70, 80, 73, 99, 115, 66, 43, 118, 77, 102, 88, 78, 84, 103, 61, 61};
    private static byte[] passwordKey = SYMMETRIC_KEY;
    private static final String SYMMETIC_KEY_ALOGRITHM = "aes";
    private static final Base64 b64 = new Base64();
    private static final Encodings ENCODING = Encodings.DEFAULT;
    private static final Logger log = Logger.getLogger(EncryptionUtils.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());

    public static void setPasswordKey(String newPasswordKey) {
        if (newPasswordKey != null) {
            byte[] newKey = new byte[SYMMETRIC_KEY.length];
            byte[] pwdKey = ENCODING.toBytes(newPasswordKey);
            int len = pwdKey.length;
            if (SYMMETRIC_KEY.length - 2 < pwdKey.length) {
                len = SYMMETRIC_KEY.length - 2;
            }
            int i = 0;
            int j = 0;
            while (j < len) {
                newKey[i++] = pwdKey[j];
                ++j;
            }
            while (i < SYMMETRIC_KEY.length) {
                newKey[i] = SYMMETRIC_KEY[i];
                ++i;
            }
            passwordKey = newKey;
        }
    }

    public static String encrypt(String standardStr) {
        if (standardStr != null) {
            try {
                Cipher cipher = EncryptionUtils.getAndInitCipher(1);
                byte[] byteValue = cipher.doFinal(ENCODING.toBytes(standardStr));
                return ENCODING.toString(b64.encode(byteValue));
            }
            catch (GeneralSecurityException e) {
                log.warning(e);
            }
        }
        return null;
    }

    public static char[] encryptChars(char[] chars) {
        if (chars != null) {
            try {
                Cipher cipher = EncryptionUtils.getAndInitCipher(1);
                byte[] bytes = ENCODING.toBytes(chars);
                byte[] byteValue = cipher.doFinal(bytes);
                Arrays.fill(bytes, (byte)0);
                byte[] convertedBytes = b64.encode(byteValue);
                Arrays.fill(byteValue, (byte)0);
                char[] encryptedChars = ENCODING.toChars(convertedBytes);
                Arrays.fill(convertedBytes, (byte)0);
                return encryptedChars;
            }
            catch (GeneralSecurityException e) {
                log.warning(e);
            }
        }
        return null;
    }

    public static String decrypt(String encryptedStr) {
        if (encryptedStr != null) {
            try {
                byte[] encryptedString = b64.decode(ENCODING.toBytes(encryptedStr));
                byte[] byteValue = EncryptionUtils.getAndInitCipher(2).doFinal(encryptedString);
                return ENCODING.toString(byteValue);
            }
            catch (GeneralSecurityException e) {
                log.warning(e);
            }
        }
        return null;
    }

    public static char[] decryptChars(char[] encryptedChars) {
        if (encryptedChars != null) {
            try {
                byte[] encryptedBytes = ENCODING.toBytes(encryptedChars);
                byte[] convertedBytes = b64.decode(encryptedBytes);
                Arrays.fill(encryptedBytes, (byte)0);
                byte[] decryptedBytes = EncryptionUtils.getAndInitCipher(2).doFinal(convertedBytes);
                Arrays.fill(convertedBytes, (byte)0);
                char[] decryptedChars = ENCODING.toChars(decryptedBytes);
                Arrays.fill(decryptedBytes, (byte)0);
                return decryptedChars;
            }
            catch (GeneralSecurityException e) {
                log.warning(e);
            }
        }
        return null;
    }

    private static Cipher getAndInitCipher(int mode) throws GeneralSecurityException {
        byte[] key = b64.decode(passwordKey);
        Cipher cipher = Cipher.getInstance(SYMMETIC_KEY_ALOGRITHM);
        cipher.init(mode, new SecretKeySpec(key, SYMMETIC_KEY_ALOGRITHM));
        return cipher;
    }
}

