/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.shared.pages;

import com.ibm.cic.common.core.console.ConCommonCommandKeys;
import com.ibm.cic.common.core.console.Messages;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.ConActionAddPage;
import com.ibm.cic.common.core.console.actions.ConActionExit;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.shared.manager.ConCredentialPromptManager;
import com.ibm.cic.common.core.console.shared.pages.ConCredentialSavePromptPage;
import com.ibm.cic.common.core.console.shared.pages.ConCredentialUserNamePromptPage;
import com.ibm.cic.common.core.console.views.ConViewGroup;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.ConViewXML;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.downloads.CredentialPromptConversation;

public class ConCredentialPrompterPage
extends AConPage {
    private ConCredentialPromptManager context;

    public ConCredentialPrompterPage(IConManager controller) {
        super(controller);
    }

    @Override
    public void init() {
        this.context = this.conManager().getDataContext(ConCredentialPromptManager.class);
        this.setHeaderView(NLS.bind((String)Messages.PagePrompt_Pwd_Header, (Object)this.context.getApplication()));
        super.init();
    }

    protected void createContents(ConViewGroup contents) {
        CredentialPromptConversation.SimpleTextBox links;
        this.context = this.conManager().getDataContext(ConCredentialPromptManager.class);
        contents.addView(new ConViewText(this.context.getConnectMessage()));
        contents.addView(new ConViewText(""));
        ConViewList mainList = new ConViewList(Messages.General_Select);
        mainList.setNewLineAfterList(false);
        mainList.addEntry(Messages.PagePrompt_Pwd_Connect, ConCommonCommandKeys.keys_ProvideCredentials[0], (AConActionEntry)new ConActEnterCredentials());
        if (this.context.needsDomain() && CicCommonSettings.isWindows()) {
            mainList.addEntry(Messages.PagePrompt_Pwd_ConnectWithDefault, ConCommonCommandKeys.keys_ConnectWithWindowsCredentials[0], (AConActionEntry)new ConCredentialSavePromptPage.ConActOK(this.context));
        }
        mainList.addEntry(Messages.General_Dlg_Cancel, ConCommonCommandKeys.keys_Cancel[0], (AConActionEntry)new ConActCancel());
        contents.addView(mainList);
        contents.addView(new ConViewText(""));
        if (!this.context.needsDomain() || !CicCommonSettings.isWindows()) {
            contents.addView(new ConViewText(NLS.bind((String)Messages.PagePrompt_Pwd_CredentialPrompt, (Object)ConCommonCommandKeys.keys_ProvideCredentials[0], (Object)ConCommonCommandKeys.keys_Cancel[0])));
        }
        if ((links = this.context.getLinksText()) != null) {
            contents.addView(new ConViewText(""));
            contents.addView(new ConViewXML("<realm>" + links.getText() + "</realm>"));
        }
    }

    @Override
    public void present(OutputFormatter a_output) {
        this.clear();
        this.createContents(this);
        super.present(a_output);
    }

    class ConActCancel
    extends ConActionExit {
        ConActCancel() {
        }

        @Override
        public void run(IConManager a_conManager) {
            ConCredentialPrompterPage.this.context.cancel();
            super.run(a_conManager);
        }
    }

    static class ConActEnterCredentials
    extends ConActionAddPage {
        ConActEnterCredentials() {
        }

        @Override
        protected AConPage createNewPage(IConManager a_manager) {
            return new ConCredentialUserNamePromptPage(a_manager);
        }
    }
}

