/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.manager;

import com.ibm.cic.common.core.console.Messages;
import com.ibm.cic.common.core.console.manager.IConIO;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.ConvertUtil;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.StandardInputDetector;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConIOSimple
implements IConIO {
    private char[] m_inputChars;
    private IStatus m_status = Status.OK_STATUS;

    @Override
    public String getString() {
        if (this.m_inputChars == null) {
            return null;
        }
        return String.valueOf(this.m_inputChars);
    }

    @Override
    public char[] getInputChars() {
        return this.m_inputChars;
    }

    @Override
    public int getInteger() {
        int return_value = -1;
        try {
            return_value = Integer.parseInt(this.getString());
        }
        catch (NumberFormatException e) {
            ExceptionUtil.debugLogIllegalArgumentException((IllegalArgumentException)e);
        }
        return return_value;
    }

    @Override
    public final IStatus getUserInput(IConManager a_conManager, String a_defaultInput) {
        boolean standardInputActive = StandardInputDetector.INSTANCE.isActive();
        this.m_inputChars = null;
        String inputLine = null;
        while (!((inputLine = this.retrieveInput(a_conManager, a_defaultInput)) == null && standardInputActive || inputLine != null)) {
        }
        if (standardInputActive && inputLine == null) {
            this.setErrorStatus(6400, Messages.ConIOSimple_InsufficientInputErrorStatus);
        } else {
            inputLine = inputLine.trim();
            this.m_inputChars = inputLine.toCharArray();
        }
        return this.getStatus();
    }

    @Override
    public final IStatus getPassword(IConManager a_conManager) {
        this.m_inputChars = null;
        do {
            String value;
            Console c;
            if ((c = System.console()) != null) {
                try {
                    this.m_inputChars = c.readPassword();
                    if (!CicCommonSettings.isZOS()) continue;
                    value = ConvertUtil.convertStringA2UTF8((String)String.valueOf(this.m_inputChars));
                    this.m_inputChars = value.toCharArray();
                }
                catch (Exception e) {
                    ExceptionUtil.debugLogToReview((Throwable)e);
                }
                continue;
            }
            value = this.retrieveInput(a_conManager, a_conManager.getCurrentPage().getSuggestedInput());
            if (value == null) continue;
            if (CicCommonSettings.isZOS()) {
                value = ConvertUtil.convertStringA2UTF8((String)String.valueOf(this.m_inputChars));
            }
            this.m_inputChars = value.toCharArray();
        } while (this.m_inputChars == null);
        this.m_inputChars = this.trimChars(this.m_inputChars);
        return this.getStatus();
    }

    private char[] trimChars(char[] value) {
        int firstCharIndex = 0;
        int lastCharIndex = value.length - 1;
        int start = 0;
        int end = lastCharIndex;
        while (start <= end && value[start] <= ' ') {
            ++start;
        }
        while (end >= start && value[end] <= ' ') {
            --end;
        }
        if (start == firstCharIndex && end == lastCharIndex) {
            return value;
        }
        int length = end - start + 1;
        char[] returnValue = new char[length];
        System.arraycopy(value, start, returnValue, 0, length);
        Arrays.fill(value, '\u0000');
        return returnValue;
    }

    public String toString() {
        return String.valueOf(OutputFormatter.NEW_LINE_STR) + this.m_status.toString() + OutputFormatter.NEW_LINE_STR;
    }

    @Override
    public IStatus display(IConManager a_conManager, OutputFormatter of) {
        this.display(of.toString());
        return this.getStatus();
    }

    public void display(String s) {
        System.out.print(s);
    }

    protected String retrieveInput(IConManager m_conManager, String a_defaultInput) {
        String return_value = null;
        BufferedReader br = new BufferedReader(Encodings.DEFAULT.reader(System.in));
        try {
            return_value = br.readLine();
        }
        catch (IOException e) {
            ExceptionUtil.debugLogToReview((Throwable)e);
        }
        if (return_value != null && return_value.length() == 0) {
            return_value = a_defaultInput;
        }
        return return_value;
    }

    @Override
    public IStatus getStatus() {
        return this.m_status;
    }

    @Override
    public void setStatus(IStatus a_status) {
        this.m_status = a_status;
    }

    protected void setErrorStatus(int a_statusCode, String a_message) {
        this.setStatus((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), a_statusCode, a_message, null));
    }
}

