/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.dialogs;

import com.ibm.cic.common.core.console.Messages;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.dialogs.ConMessageDialog;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class ConStatusMessageDialog
extends ConMessageDialog {
    public static final int DISPLAY_DEFAULT_MASK = 7;
    private final String NESTING_INDENT = "   ";
    private final IStatus status;
    private final int displayMask;
    private final boolean showDetailsByDefault;

    public ConStatusMessageDialog(IConManager parent, String title, String message, IStatus status, int displayMask, ConMessageDialog.Kind kind, ConMessageDialog.Action[] actions, int defaultIndex) {
        this(parent, title, message, status, displayMask, kind, actions, defaultIndex, false);
    }

    public ConStatusMessageDialog(IConManager parent, String title, String message, IStatus status, int displayMask, ConMessageDialog.Kind kind, ConMessageDialog.Action[] actions, int defaultIndex, boolean showDetailsByDefault) {
        status = StatusUtil.fixMultiStatusNoMsgProblem((IStatus)status);
        super(parent, title, ConStatusMessageDialog.computeMessage(message, status), kind, actions, defaultIndex);
        this.NESTING_INDENT = "   ";
        this.status = status;
        int allMask = 15;
        assert ((displayMask & allMask) != 0);
        this.displayMask = displayMask;
        this.showDetailsByDefault = showDetailsByDefault;
    }

    @Override
    public int open() {
        if (ConStatusMessageDialog.shouldDisplay(this.getStatus(), this.getDisplayMask())) {
            return super.open();
        }
        this.setReturnCode(0);
        return 0;
    }

    public static boolean open(ConMessageDialog.Kind kind, IConManager parent, String title, String message, IStatus status, int displayMask, boolean showDetails) {
        return ConStatusMessageDialog.open(kind, parent, title, message, status, displayMask, 0, showDetails);
    }

    public static boolean open(ConMessageDialog.Kind kind, IConManager parent, String title, String message, IStatus status, int displayMask, int defaultIndex, boolean showDetails) {
        ConStatusMessageDialog dialog = new ConStatusMessageDialog(parent, title, message, status, displayMask, kind, ConStatusMessageDialog.getActions(kind), defaultIndex, showDetails);
        return dialog.open() == 0;
    }

    public static boolean open(ConMessageDialog.Kind kind, IConManager parent, String title, String message, IStatus status, int displayMask) {
        return ConStatusMessageDialog.open(kind, parent, title, message, status, displayMask, false);
    }

    public static boolean open(IConManager parent, String title, String message, IStatus status, int displayMask, boolean showDetails) {
        ConMessageDialog.Kind dialogKind;
        switch (status.getSeverity()) {
            case 4: 
            case 8: {
                dialogKind = ConMessageDialog.Kind.ERROR;
                break;
            }
            case 2: {
                dialogKind = ConMessageDialog.Kind.WARNING;
                break;
            }
            default: {
                dialogKind = ConMessageDialog.Kind.INFORMATION;
            }
        }
        return ConStatusMessageDialog.open(dialogKind, parent, title, message, status, displayMask, showDetails);
    }

    public static boolean openError(IConManager parent, String title, String message, IStatus status) {
        return ConStatusMessageDialog.openError(parent, title, message, status, 7);
    }

    public static boolean openError(IConManager parent, String title, String message, IStatus status, int displayMask) {
        return ConStatusMessageDialog.openError(parent, title, message, status, displayMask, false);
    }

    public static boolean openError(IConManager parent, String title, String message, IStatus status, int displayMask, boolean showDetails) {
        return ConStatusMessageDialog.open(ConMessageDialog.Kind.ERROR, parent, title, message, status, displayMask, showDetails);
    }

    public static boolean openQuestion(IConManager parent, String title, String message, IStatus status) {
        return ConStatusMessageDialog.openQuestion(parent, title, message, status, 7);
    }

    public static boolean openQuestion(IConManager parent, String title, String message, IStatus status, int displayMask) {
        return ConStatusMessageDialog.openQuestion(parent, title, message, status, displayMask, 0);
    }

    public static boolean openQuestion(IConManager parent, String title, String message, IStatus status, int displayMask, int defaultIndex) {
        return ConStatusMessageDialog.open(ConMessageDialog.Kind.QUESTION, parent, title, message, status, displayMask, defaultIndex, false);
    }

    public static boolean openConfirm(IConManager parent, String title, String message, IStatus status) {
        return ConStatusMessageDialog.openConfirm(parent, title, message, status, 7);
    }

    public static boolean openConfirm(IConManager parent, String title, String message, IStatus status, int displayMask) {
        return ConStatusMessageDialog.open(ConMessageDialog.Kind.CONFIRM, parent, title, message, status, displayMask);
    }

    protected static String computeMessage(String message, IStatus status) {
        String result;
        assert (status != null);
        if (message == null) {
            result = status.getMessage();
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(message);
            sb.append(CommonDef.EOL);
            sb.append(CommonDef.EOL);
            sb.append(Messages.ConStatusMessageDialog_reasonLabel);
            sb.append(" ");
            sb.append(status.getMessage());
            result = sb.toString();
        }
        return StatusUtil.combineAnchors((String)result);
    }

    protected static boolean shouldDisplay(IStatus status, int mask) {
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return status.matches(mask);
        }
        IStatus[] iStatusArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            if (element.matches(mask)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected SMDPage createPage() {
        return new SMDPage(this, this.showDetailsByDefault);
    }

    protected IStatus getStatus() {
        return this.status;
    }

    protected int getDisplayMask() {
        return this.displayMask;
    }

    protected boolean detailsExist(IStatus curStatus, boolean includeStatus) {
        IStatus[] children;
        if (!curStatus.matches(this.getDisplayMask())) {
            return false;
        }
        Throwable t = curStatus.getException();
        boolean isCoreException = t instanceof CoreException;
        if (includeStatus) {
            return true;
        }
        if (!isCoreException && t != null) {
            return true;
        }
        boolean result = false;
        if (isCoreException) {
            CoreException ce = (CoreException)t;
            IStatus eStatus = ce.getStatus();
            if (this.getMessage() == null || this.getMessage().indexOf(eStatus.getMessage()) == -1) {
                result |= this.detailsExist(eStatus, true);
            }
        }
        IStatus[] iStatusArray = children = curStatus.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            result |= this.detailsExist(element, true);
            ++n2;
        }
        return result;
    }

    protected boolean shouldShowDetailsAction() {
        boolean haveDetails = this.detailsExist(this.getStatus(), false);
        if (haveDetails) {
            return true;
        }
        return CommonSharedUIUtils.hasUID((IStatus)this.status);
    }

    protected void indent(StringBuilder sb, int nesting) {
        sb.append(CommonDef.EOL);
        int i = 0;
        while (i < nesting) {
            sb.append("   ");
            ++i;
        }
    }

    private static class DetailsAction
    extends AConActionEntry<ConViewListEntry> {
        private final SMDPage page;

        protected DetailsAction(SMDPage page) {
            this.page = page;
        }

        @Override
        public void run(IConManager manager) {
            this.page.toggleDetails((ConViewListEntry)this.getEntry());
        }
    }

    protected static class SMDPage
    extends ConMessageDialog.MDPage {
        boolean showDetailsByDefault = false;
        private ConViewText detailsText;
        private String details = null;

        protected SMDPage(ConStatusMessageDialog dialog) {
            this(dialog, false);
        }

        protected SMDPage(ConStatusMessageDialog dialog, boolean showDetails) {
            super(dialog);
            this.showDetailsByDefault = showDetails;
        }

        @Override
        protected void createContent() {
            super.createContent();
            this.detailsText = new ConViewText(null);
            this.detailsText.setTrailingNewLineNr(2);
            this.addView(this.detailsText);
        }

        @Override
        protected ConViewList createActions() {
            ConViewList listView = super.createActions();
            ConStatusMessageDialog dialog = (ConStatusMessageDialog)this.getDialog();
            if (dialog.shouldShowDetailsAction()) {
                String detailsLabel = this.showDetailsByDefault ? Messages.ConStatusMessageDialog_hideDetails : Messages.ConStatusMessageDialog_showDetails;
                listView.addEntry(detailsLabel, "D", (AConActionEntry)new DetailsAction(this));
                if (this.showDetailsByDefault) {
                    this.detailsText.setText(this.getDetails());
                }
            }
            return listView;
        }

        protected void toggleDetails(ConViewListEntry entry) {
            if (this.detailsText.getText() == null) {
                this.detailsText.setText(this.getDetails());
                entry.setName(Messages.ConStatusMessageDialog_hideDetails);
            } else {
                this.detailsText.setText(null);
                entry.setName(Messages.ConStatusMessageDialog_showDetails);
            }
        }

        private String getDetails() {
            if (this.details == null) {
                ConStatusMessageDialog dialog = (ConStatusMessageDialog)this.getDialog();
                IStatus status = dialog.getStatus();
                OutputFormatter outputFormatter = new OutputFormatter();
                outputFormatter.appendNTnl(Messages.ConStatusMessageDialog_detailsLabel);
                CommonSharedUIUtils.populateDetailArea((IStatus)status, (OutputFormatter)outputFormatter);
                this.details = StatusUtil.combineAnchors((String)outputFormatter.toString());
            }
            return this.details;
        }
    }
}

