/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.UninstallJob;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIDisableCancelWizard;
import com.ibm.cic.agent.internal.ui.wizards.CompletionPage;
import com.ibm.cic.agent.internal.ui.wizards.ConditionalInstallPage;
import com.ibm.cic.agent.internal.ui.wizards.UninstallCompletionPage;
import com.ibm.cic.agent.internal.ui.wizards.UninstallSummaryPage;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.ui.CICImages;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;

public class UninstallWizard
extends AgentUIDisableCancelWizard {
    public UninstallWizard() {
        super(null, Messages.UninstallWizard_uninstalling, CICImages.WIZ_UNINSTALL);
    }

    public UninstallWizard(String returnPageId) {
        super(returnPageId, Messages.UninstallWizard_uninstalling, CICImages.WIZ_UNINSTALL);
    }

    public void addPages() {
        ConditionalInstallPage conditionalInstall = new ConditionalInstallPage(this.toolkit, this);
        if (!conditionalInstall.shouldSkip()) {
            this.addPage((IWizardPage)conditionalInstall);
            conditionalInstall.setHelpRef("com.ibm.cic.agent.ui.ConditionalInstallPage");
        }
        this.addExtensionPages("com.ibm.cic.agent.ui.MissingCustomPanelUninstallWizard");
        this.addSingleConfigurationPage(com.ibm.cic.agent.internal.ui.licenses.Messages.ConfirmationPage_title, "com.ibm.cic.agent.ui.MissingCustomPanelSingleConfigurationPage");
        this.addPage((IWizardPage)new UninstallSummaryPage(this.toolkit, this));
    }

    @Override
    protected AbstractJob createJob(Profile profile, IOfferingOrFix offering) {
        UninstallJob job = new UninstallJob(profile, offering);
        job.setSelected(false);
        return job;
    }

    @Override
    public CompletionPage createCompletionPage(IStatus status) {
        AgentUI.getDefault().getCurrentWizard().setAllowExit(true);
        return new UninstallCompletionPage(this.toolkit, this, status);
    }

    @Override
    protected String getRestartMessage() {
        return Messages.RestartProfileMsg;
    }

    public IWizardPage getStartingPage() {
        IWizardPage page = super.getStartingPage();
        return page;
    }

    @Override
    protected WizardType getWizardType() {
        return WizardType.UNINSTALL;
    }

    @Override
    protected IStatus performTask(IProgressMonitor monitor) {
        AgentUI.getDefault().getCurrentWizard().setAllowExit(false);
        Agent agent = AgentUI.getDefault().getAgent();
        List selectedJobs = this.getSelectedJobs();
        AbstractJob[] jobsToUninstall = selectedJobs.toArray(new AbstractJob[selectedJobs.size()]);
        SortUtil.sortByProfileNameAndVersion((AgentJob[])jobsToUninstall, (boolean)true);
        IStatus uninstallStatus = agent.uninstall((AgentJob[])jobsToUninstall, this.getCollectedArtifacts(), (Agent.IDisableCancel)this, monitor);
        return uninstallStatus;
    }

    @Override
    public void setInput(Object[] items) {
        List productProfiles = this.getProductProfileList();
        productProfiles.clear();
        List agentProfileList = this.getAgentProfileList();
        agentProfileList.clear();
        this.setInputFromJobs((AbstractJob[])items);
    }

    private void setInputFromJobs(AbstractJob[] items) {
        List productProfiles = this.getProductProfileList();
        List agentProfile = this.getAgentProfileList();
        List wizardJobs = this.getJobs();
        AbstractJob[] abstractJobArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractJob item = abstractJobArray[n2];
            if (item instanceof UninstallJob) {
                wizardJobs.add(item);
                Profile nextProfile = item.getProfile();
                if (nextProfile.getProfileKind().equals("self")) {
                    if (!agentProfile.contains(nextProfile)) {
                        agentProfile.add(nextProfile);
                    }
                } else if (!productProfiles.contains(nextProfile)) {
                    productProfiles.add(nextProfile);
                }
            }
            ++n2;
        }
    }

    public boolean isHelpAvailable() {
        return true;
    }

    protected String getStatusMessage(IStatus status) {
        if (status.matches(8)) {
            return Messages.UninstallCanceledMsg;
        }
        return Messages.UninstallFailedMsg;
    }

    protected String getKeepDownloadedMessage() {
        return Messages.KeepDownloadedMsgForUninstall;
    }

    protected String getKeepDownloadedDlgTitle(IStatus status) {
        if (status.matches(8)) {
            return Messages.UninstallCanceledTitle;
        }
        return Messages.UninstallFailedTitle;
    }
}

