/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.Messages;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIPrimaryPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryWizard;
import com.ibm.cic.agent.internal.ui.wizards.ProfileDetailsPage;
import com.ibm.cic.agent.internal.ui.wizards.ProfileSelectionSection;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.TreeSection;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IDetailsPage;

public class ProfileSelectionPage
extends AbstractAgentUIPrimaryPage {
    private ProfileSelectionSection profileSection;
    protected Object[] input = null;
    private IStatus locationCheckStatus;

    public ProfileSelectionPage(String title, String description, PrimaryWizard wizard) {
        super(title, description, wizard);
    }

    @Override
    protected AgentUIWizard createInnerWizard() {
        return null;
    }

    @Override
    protected TreeSection createTreeSection(IFormContext context, Composite parent) {
        this.profileSection = new ProfileSelectionSection(context, parent, this, this.input);
        return this.profileSection;
    }

    public void setVisible(boolean visible) {
        if (visible && this.profileSection != null) {
            this.profileSection.setFocus();
        }
        super.setVisible(visible);
    }

    @Override
    public IWizardPage getNextPage() {
        Status[] result = new Status[1];
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress((IStatus[])result){
                private final /* synthetic */ IStatus[] val$result;
                {
                    this.val$result = iStatusArray;
                }

                public void run(IProgressMonitor monitor) {
                    this.val$result[0] = ProfileSelectionPage.this.prepareInstalledOfferingsInSelectedProfile(monitor);
                }
            });
            if (StatusUtil.isErrorOrCancel((IStatus)result[0])) {
                return this;
            }
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
            return this;
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
            return this;
        }
        return super.getNextPage();
    }

    @Override
    public boolean canFlipToNextPage() {
        if (super.canFlipToNextPage()) {
            return !this.hasLocationCheckFailed();
        }
        return false;
    }

    protected boolean hasLocationCheckFailed() {
        if (this.locationCheckStatus == null) {
            return false;
        }
        return StatusUtil.isErrorOrCancel((IStatus)this.locationCheckStatus);
    }

    protected void setLocationCheckStatus(IStatus status) {
        this.locationCheckStatus = status;
    }

    protected void resetLocationCheckStatus() {
        this.locationCheckStatus = Status.OK_STATUS;
        if (this.getLocationCheckError() != null) {
            this.setErrorState(this.getLocationCheckError(), null);
        }
        if (this.getLocationCheckWarning() != null) {
            this.setWarningState(this.getLocationCheckWarning(), null);
        }
    }

    protected CustomMessageWizardPage.ErrorId getLocationCheckError() {
        return null;
    }

    protected CustomMessageWizardPage.WarningId getLocationCheckWarning() {
        return null;
    }

    protected IStatus prepareInstalledOfferingsInSelectedProfile(IProgressMonitor monitor) {
        return this.prepareInstalledOfferingsInSelectedProfile(true, monitor);
    }

    protected IStatus prepareInstalledOfferingsInSelectedProfile(boolean prepareOnly, IProgressMonitor monitor) {
        Object[] selectionArray;
        Agent agent = AgentUI.getDefault().getAgent();
        ArrayList<Object> offeringOrFixesToPrepare = new ArrayList<Object>();
        Object[] objectArray = selectionArray = this.getSelections();
        int n = selectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof Profile) {
                IFix[] fixes;
                IOffering[] offerings;
                IOffering[] iOfferingArray = offerings = agent.getInstalledOfferings((Profile)element);
                int n3 = offerings.length;
                int n4 = 0;
                while (n4 < n3) {
                    IOffering offering = iOfferingArray[n4];
                    offeringOrFixesToPrepare.add(offering);
                    ++n4;
                }
                IFix[] iFixArray = fixes = agent.getInstalledFixes((Profile)element);
                int n5 = fixes.length;
                n3 = 0;
                while (n3 < n5) {
                    IFix fix = iFixArray[n3];
                    offeringOrFixesToPrepare.add(fix);
                    ++n3;
                }
            }
            ++n2;
        }
        if (!offeringOrFixesToPrepare.isEmpty()) {
            SplitProgressMonitor sm = new SplitProgressMonitor(monitor, new int[]{1, 3});
            IStatus unloadStatus = Agent.getInstance().unloadAgentBundles(sm.next());
            if (!unloadStatus.isOK()) {
                AgentUI.reportStatus(unloadStatus, false);
            }
            IStatus status = Status.OK_STATUS;
            status = prepareOnly ? SharedUIUtils.prepareOfferingsAndFixes(offeringOrFixesToPrepare, (IProgressMonitor)sm.next()) : SharedUIUtils.prepareAndResolveOfferingsAndFixes(offeringOrFixesToPrepare, (boolean)false, (IProgressMonitor)sm.next());
            return status;
        }
        return Status.OK_STATUS;
    }

    protected CicMultiStatus performLocationPermissionCheck() {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        Object[] currentSelections = this.getSelections();
        Profile[] profiles = new Profile[]{};
        if (currentSelections instanceof Profile[]) {
            profiles = (Profile[])currentSelections;
        }
        Profile[] profileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            status.add(AgentUtil.validateInstallDirectoryPermissions((String)profile.getInstallLocation()));
            ++n2;
        }
        if (status.matches(4)) {
            status.setMessage(Messages.ProfileSelectionPage_Permission_Check_ErrMsg);
        }
        return status;
    }

    @Override
    protected IDetailsPage createDetailsSection() {
        return new ProfileDetailsPage();
    }

    @Override
    protected int[] getWeights() {
        return new int[]{50, 50};
    }

    @Override
    public boolean isPageComplete() {
        return this.canFlipToNextPage();
    }

    @Override
    protected void setInput(Object[] inputElements) {
        this.input = inputElements;
    }
}

