/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.ModifyWizard;
import com.ibm.cic.agent.internal.ui.wizards.RebootCompletionPage;
import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.ui.internal.CommonImages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ModifyCompletionPage
extends RebootCompletionPage {
    private Label modifiedPackageLabel;
    private Label unmodifiedPackageLabel;
    private Table modifiedJobTable;
    private Table unmodifiedJobTable;
    private final AgentUILabelProvider agentLabelProvider;
    private List modifiedJobList = new ArrayList();
    private final List unmodifiedJobList = new ArrayList();

    public ModifyCompletionPage(FormToolkit toolkit, AgentUIWizard wizard, IStatus status) {
        super(toolkit, Messages.ModifyCompletionPage_title, "", wizard, status);
        super.setHelpRef("com.ibm.cic.agent.ui.ModifyCompletionPage");
        this.agentLabelProvider = AgentUI.getDefault().getLabelProvider();
        this.agentLabelProvider.connect((Object)this);
    }

    @Override
    public void dispose() {
        this.agentLabelProvider.disconnect((Object)this);
    }

    private void determineModifiedJobs() {
        String currentLangsString;
        Set currentInstalledLangs;
        Set previousLocaleLangSet;
        List selectedProductJobs = this.filterPEKJobs(this.getSelectedJobs());
        if (selectedProductJobs.size() == 0) {
            return;
        }
        Profile profile = ((AgentJob)selectedProductJobs.get(0)).getProfile();
        Map previousLocaleLangMap = ((ModifyWizard)this.getWizard()).getPreviousLocaleLangsMap();
        String previousLocaleLangString = (String)previousLocaleLangMap.get(profile);
        if (previousLocaleLangString != null && !(previousLocaleLangSet = ProfileLanguageUtils.convertCodeStringToSet((String)previousLocaleLangString)).equals(currentInstalledLangs = ProfileLanguageUtils.convertCodeStringToSet((String)(currentLangsString = profile.getData("cic.selector.nl"))))) {
            this.modifiedJobList = selectedProductJobs;
            return;
        }
        Map modifyOfferingPreviousStatus = ((ModifyWizard)this.getWizard()).getOfferingStatusList();
        int i = 0;
        while (i < selectedProductJobs.size()) {
            AgentJob job = (AgentJob)selectedProductJobs.get(i);
            IOffering selectedOffering = job.getOffering();
            if (selectedOffering != null) {
                Set previousInstallFeatures;
                Set currentInstalledFeatures = AgentUI.getDefault().getAgent().getInstalledFeatures(job.getProfile(), selectedOffering);
                if (currentInstalledFeatures.equals(previousInstallFeatures = (Set)modifyOfferingPreviousStatus.get(selectedOffering)) && !OfferingProperty.isModifyForceEnabled((IOffering)selectedOffering)) {
                    this.unmodifiedJobList.add(job);
                } else {
                    this.modifiedJobList.add(job);
                }
            }
            ++i;
        }
    }

    @Override
    protected Composite createDetailControl(Composite container) {
        int style;
        this.determineModifiedJobs();
        Composite detailComp = this.getToolkit().createComposite(container, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        detailComp.setLayout((Layout)gridLayout);
        detailComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label fillerLabel1 = this.getToolkit().createLabel(detailComp, "");
        GridData data = new GridData();
        data.widthHint = this.modifiedJobList.size() > 0 && this.unmodifiedJobList.size() > 0 ? 50 : 150;
        fillerLabel1.setLayoutData((Object)data);
        Composite pkgResultComp = this.getToolkit().createComposite(detailComp, 0);
        GridLayout pkgCompLayout = new GridLayout();
        int numCols = 1;
        if (this.modifiedJobList.size() > 0 && this.unmodifiedJobList.size() > 0) {
            numCols = 2;
        }
        pkgCompLayout.numColumns = numCols;
        pkgResultComp.setLayout((Layout)pkgCompLayout);
        GridData detailsLayoutData = new GridData(4, 4, true, true);
        detailsLayoutData.heightHint = 200;
        pkgResultComp.setLayoutData((Object)detailsLayoutData);
        this.createDetailResultTextControl(pkgResultComp, numCols);
        if (this.modifiedJobList.size() > 0) {
            Composite modifiedPkgComp = this.getToolkit().createComposite(pkgResultComp, 0);
            modifiedPkgComp.setLayout((Layout)new GridLayout());
            modifiedPkgComp.setLayoutData((Object)new GridData(4, 4, true, true));
            this.modifiedPackageLabel = this.getToolkit().createLabel(modifiedPkgComp, "");
            style = 101124;
            this.modifiedJobTable = new Table(modifiedPkgComp, style);
            this.getToolkit().adapt((Control)this.modifiedJobTable, true, true);
            GridData gd = new GridData(1808);
            gd.heightHint = this.modifiedJobTable.getItemHeight() * 6;
            gd.widthHint = 300;
            this.modifiedJobTable.setLayoutData((Object)gd);
            this.modifiedJobTable.setLinesVisible(false);
            new TableColumn(this.modifiedJobTable, 0);
            this.modifiedJobTable.pack();
        }
        if (this.unmodifiedJobList.size() > 0) {
            Composite unmodifiedPkgComp = this.getToolkit().createComposite(pkgResultComp, 0);
            unmodifiedPkgComp.setLayout((Layout)new GridLayout());
            unmodifiedPkgComp.setLayoutData((Object)new GridData(4, 4, true, true));
            this.unmodifiedPackageLabel = this.getToolkit().createLabel(unmodifiedPkgComp, "");
            style = 101124;
            this.unmodifiedJobTable = new Table(unmodifiedPkgComp, style);
            this.getToolkit().adapt((Control)this.unmodifiedJobTable, true, true);
            GridData gData = new GridData(1808);
            gData.heightHint = this.unmodifiedJobTable.getItemHeight() * 6;
            gData.widthHint = 300;
            this.unmodifiedJobTable.setLayoutData((Object)gData);
            this.unmodifiedJobTable.setLinesVisible(false);
            new TableColumn(this.unmodifiedJobTable, 0);
            this.unmodifiedJobTable.pack();
        }
        Label fillerLabel2 = this.getToolkit().createLabel(detailComp, "");
        data = new GridData();
        data.widthHint = this.modifiedJobList.size() > 0 && this.unmodifiedJobList.size() > 0 ? 50 : 150;
        fillerLabel2.setLayoutData((Object)data);
        return pkgResultComp;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.showResultText();
            this.showModifyDetails();
            this.reflowFor((Control)this.resultText);
            if (this.modifiedJobTable != null) {
                this.reflowFor((Control)this.modifiedJobTable);
            } else if (this.unmodifiedJobTable != null) {
                this.reflowFor((Control)this.unmodifiedJobTable);
            }
            this.reflowFor(this.getControl());
        }
        super.setVisible(visible);
    }

    private void showResultText() {
        if (this.result == 0) {
            this.resultText.setText(Messages.ModifyCompletionPage_result_success);
        } else if (this.result == 3) {
            this.resultText.setText(Messages.ModifyCompletionPage_result_completeWithWarning);
        } else if (this.result == 2) {
            this.resultText.setText(Messages.ModifyCompletionPage_result_cancel);
        } else {
            this.resultText.setText(Messages.ModifyCompletionPage_result_fail);
        }
    }

    private List filterPEKJobs(List jobs) {
        ArrayList<AbstractJob> return_result = new ArrayList<AbstractJob>();
        int i = 0;
        while (i < jobs.size()) {
            AbstractJob job = (AbstractJob)jobs.get(i);
            IOffering offering = job.getOffering();
            if (offering == null || !LicenseUtils.isPEKOffering((IOffering)offering)) {
                return_result.add(job);
            }
            ++i;
        }
        return return_result;
    }

    private void showModifyDetails() {
        TableItem item;
        String name;
        IOfferingOrFix offeringOrFix;
        AbstractJob job;
        int i;
        if (this.modifiedJobList.size() > 0) {
            this.modifiedJobTable.removeAll();
            if (this.modifiedJobList.size() > 1) {
                this.modifiedPackageLabel.setText(Messages.ModifyCompletionPage_modificationsSuccessLabel);
            } else {
                this.modifiedPackageLabel.setText(Messages.ModifyCompletionPage_modificationSuccessLabel);
            }
            List sortedJobList = SortUtil.sortByNameAndVersion((List)this.modifiedJobList);
            i = 0;
            while (i < sortedJobList.size()) {
                job = (AbstractJob)sortedJobList.get(i);
                offeringOrFix = job.getOfferingOrFix();
                name = offeringOrFix.getName();
                item = new TableItem(this.modifiedJobTable, 0);
                item.setText(name);
                if (offeringOrFix instanceof IOffering) {
                    item.setImage(this.agentLabelProvider.getOfferingImage((IOffering)offeringOrFix));
                } else {
                    item.setImage(this.agentLabelProvider.get(CommonImages.DESC_FIX_OBJ));
                }
                ++i;
            }
            this.modifiedJobTable.getColumn(0).pack();
        }
        if (this.unmodifiedJobList.size() > 0) {
            this.unmodifiedJobTable.removeAll();
            if (this.unmodifiedJobList.size() > 1) {
                this.unmodifiedPackageLabel.setText(Messages.ModifyCompletionPage_modificationsFailLabel);
            } else {
                this.unmodifiedPackageLabel.setText(Messages.ModifyCompletionPage_modificationFailLabel);
            }
            List sortedUnmodifiedJobList = SortUtil.sortByNameAndVersion((List)this.unmodifiedJobList);
            i = 0;
            while (i < sortedUnmodifiedJobList.size()) {
                job = (AbstractJob)sortedUnmodifiedJobList.get(i);
                offeringOrFix = job.getOfferingOrFix();
                name = offeringOrFix.getName();
                item = new TableItem(this.unmodifiedJobTable, 0);
                item.setText(name);
                if (offeringOrFix instanceof IOffering) {
                    item.setImage(this.agentLabelProvider.getOfferingImage((IOffering)offeringOrFix));
                } else {
                    item.setImage(this.agentLabelProvider.get(CommonImages.DESC_FIX_OBJ));
                }
                ++i;
            }
            this.unmodifiedJobTable.getColumn(0).pack();
        }
    }

    @Override
    protected void createSpaceNoticeControl(Composite container) {
        if (this.needCreateSpaceNoticeControl()) {
            Layout layout = container.getLayout();
            int numSpan = 1;
            if (layout instanceof GridLayout) {
                numSpan = ((GridLayout)layout).numColumns;
            }
            final Link noteLink = new Link(container, 64);
            noteLink.setText(Messages.FeatureSelectionPage_noteLabel);
            GridData gridData = new GridData(4, 1, true, false);
            gridData.widthHint = 250;
            gridData.horizontalSpan = numSpan;
            noteLink.setLayoutData((Object)gridData);
            noteLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)noteLink.getShell(), (String)"com.ibm.cic.agent.ui.DownloadCachePage", (String[])new String[]{"com.ibm.cic.agent.ui.DownloadCachePage"}, null);
                    dlg.open();
                }
            });
            this.createSpaceNoticeControl = true;
        }
    }

    @Override
    protected String getRebootRequestLabel() {
        return com.ibm.cic.agent.core.sharedUI.Messages.RebootCompletionPage_rebootModifyLabel;
    }
}

