/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.internal.ui.utils.LicenseFlexData;
import com.ibm.cic.agent.internal.ui.utils.ProfileOfferingFeature;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.CompletionPage;
import com.ibm.cic.agent.internal.ui.wizards.EclipseStyleLicensePage;
import com.ibm.cic.agent.internal.ui.wizards.LicenseFlexCompletionPage;
import com.ibm.cic.agent.internal.ui.wizards.LicenseFlexPage;
import com.ibm.cic.agent.internal.ui.wizards.LicenseUsagePage;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.ui.CICImages;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;

public class LicenseFlexWizard
extends AgentUIWizard {
    private LicenseFlexData licenseFlexData;
    private final ProfileOfferingFeature profileOfferingFeature;

    public LicenseFlexWizard(ProfileOfferingFeature pof) {
        super(null, null, CICImages.WIZ_LICENSES);
        this.profileOfferingFeature = pof;
    }

    public void addPages() {
        this.licenseFlexData = new LicenseFlexData();
        IOffering offering = this.profileOfferingFeature.getProfileOffering().getOffering();
        if (offering != null) {
            InstallJob job = new InstallJob((IOfferingOrFix)offering);
            job.setSelected(true);
            this.getJobs().clear();
            this.getJobs().add(job);
            HashMap<IOffering, String> map = new HashMap<IOffering, String>();
            map.put(offering, "FLOATING");
            this.setOfferingOrFixLicenseTypeMap(map);
            EclipseStyleLicensePage eclipseStyleLicensePage = new EclipseStyleLicensePage(this.toolkit, this);
            if (!eclipseStyleLicensePage.shouldSkip()) {
                eclipseStyleLicensePage.setPageComplete(false);
                eclipseStyleLicensePage.setHelpRef("com.ibm.cic.agent.ui.EclipseStyleLicensePage");
                this.addPage((IWizardPage)eclipseStyleLicensePage);
            }
        }
        this.addPage((IWizardPage)new LicenseFlexPage(this.toolkit, this, this.licenseFlexData, this.profileOfferingFeature));
        this.addPage((IWizardPage)new LicenseUsagePage(this.toolkit, this, this.licenseFlexData, this.profileOfferingFeature));
    }

    protected AbstractJob createJob(IOfferingOrFix offeringOrFix, Map offeringFixProfileMap) {
        return null;
    }

    @Override
    protected String getRestartMessage() {
        return null;
    }

    @Override
    protected AbstractJob createJob(Profile profile, IOfferingOrFix offering) {
        return null;
    }

    @Override
    protected WizardType getWizardType() {
        return WizardType.LICENSE_MANAGEMENT;
    }

    @Override
    protected IStatus performTask(IProgressMonitor monitor) {
        try {
            this.licenseFlexData.save();
        }
        catch (IOException e) {
            return new Status(4, "com.ibm.cic.agent.ui", 0, e.getLocalizedMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    @Override
    public void setInput(Object[] items) {
    }

    public boolean isHelpAvailable() {
        return true;
    }

    @Override
    public CompletionPage createCompletionPage(IStatus succeeded) {
        return new LicenseFlexCompletionPage(this.toolkit, this, this.profileOfferingFeature, succeeded);
    }
}

