/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.LicenseFlexData;
import com.ibm.cic.agent.internal.ui.utils.ProfileOfferingFeature;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.licensing.common.util.LicensePolicyData;
import com.ibm.cic.licensing.common.util.ProductInformation;
import com.ibm.cic.licensing.policy.ui.viewers.EditableTableViewer;
import com.ibm.cic.licensing.policy.ui.viewers.FlexViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.framework.Version;

public class LicenseFlexPage
extends AbstractAgentUIWizardPage
implements LicensePolicyData.IDataChangeListener {
    private final LicensePolicyData policyData;
    private FlexViewer viewer;
    private final ProfileOfferingFeature profileOfferingFeature;
    private boolean enabled;
    private boolean hasBeenVisible = false;

    public LicenseFlexPage(FormToolkit toolkit, AgentUIWizard wizard, LicenseFlexData data, ProfileOfferingFeature pof) {
        super(Messages.LicenseFlexPage_title, toolkit, Messages.LicenseFlexPage_title, Messages.LicenseFlexPage_header, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.LicenseFlexPage");
        this.policyData = data.getPolicyData();
        this.profileOfferingFeature = pof;
    }

    @Override
    public void createControl(Composite parent) {
        IOffering offering = this.profileOfferingFeature.getProfileOffering().getOffering();
        IFeatureBase featureOrGroup = this.profileOfferingFeature.getFeatureOrGroup();
        IInstallableUnit unit = null;
        unit = featureOrGroup != null ? LicenseUtils.getFeatureIplaUnit((IOffering)offering, (IFeatureBase)featureOrGroup) : LicenseUtils.getOfferingIplaUnit((IOffering)offering);
        String id = LicenseUtils.getLicenseId((IInstallableUnit)unit);
        String name = LicenseUtils.getLicenseName((IInstallableUnit)unit);
        Version version = unit.getParent().getVersion();
        String flexid = unit.getProperties().getProperty("enablement.flex.id");
        String flexversion = unit.getProperties().getProperty("enablement.flex.version");
        ProductInformation pi = new ProductInformation();
        pi.setProductId(id);
        pi.setProductVersion(version);
        pi.setProductName(name);
        pi.setFlexFeatureId(flexid);
        pi.setFlexVersionId(flexversion);
        Composite container = this.toolkit.createComposite(parent);
        EditableTableViewer.DefaultFormAdapter formAdapter = new EditableTableViewer.DefaultFormAdapter();
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.viewer = new FlexViewer(container, (EditableTableViewer.IFormAdapter)formAdapter);
        this.viewer.setPi(pi);
        LicensePolicyData.FlexData flexData = this.policyData.getFlexData();
        this.viewer.setInput((Object)flexData);
        this.setControl((Control)container);
        this.enabled = flexData.isEnabled();
        this.validateFlexPage(flexData);
        flexData.addDataChangeListener((LicensePolicyData.IDataChangeListener)this);
    }

    public void dataChanged(LicensePolicyData.DataEvent event) {
        LicensePolicyData.AbstractData data = event.getChangedData();
        if (data instanceof LicensePolicyData.FlexData) {
            this.enabled = ((LicensePolicyData.FlexData)data).isEnabled();
            this.validateFlexPage((LicensePolicyData.FlexData)data);
        }
    }

    public IWizardPage getNextPage() {
        if (!this.enabled) {
            return null;
        }
        return super.getNextPage();
    }

    private void validateFlexPage(LicensePolicyData.FlexData data) {
        if (this.enabled) {
            LicensePolicyData.ServerData[] servers = data.getServers();
            if (servers == null || servers.length == 0) {
                this.setPageComplete(false);
            } else {
                this.setPageComplete(true);
            }
        } else {
            this.setPageComplete(true);
        }
        this.updateButtons();
    }

    public boolean isPageComplete() {
        if (super.isPageComplete()) {
            return this.hasBeenVisible;
        }
        return false;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.hasBeenVisible = true;
            Table table = this.viewer.getTableViewer().getTable();
            if (table.getEnabled()) {
                table.setEnabled(false);
                table.setEnabled(true);
            }
        }
        super.setVisible(visible);
    }
}

