/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.console.manager.licensePanel.AgentLicensePageData;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.internal.ui.licenses.Messages;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.common.core.internal.LicenseFactory;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.ui.internal.licensePanel.BaseEclipseStyleLicensePage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EclipseStyleLicensePage
extends BaseEclipseStyleLicensePage {
    private AgentUIWizard agentWizard = null;

    public EclipseStyleLicensePage(FormToolkit toolkit, AgentUIWizard wizard, LicenseFactory.License[] licenses) {
        super(toolkit, licenses);
        this.agentWizard = wizard;
        this.setAcceptLicense();
    }

    public EclipseStyleLicensePage(FormToolkit toolkit, AgentUIWizard wizard) {
        super(toolkit, null);
        this.agentWizard = wizard;
        this.setAcceptLicense();
    }

    private LicenseFactory.License[] fetchLicenses(AgentJob[] jobs, Map offeringLicenseMap) {
        if (this.licenses == null || this.licenses.length == 0) {
            ArrayList<LicenseFactory.License> licenseList = new ArrayList<LicenseFactory.License>();
            AgentJob[] agentJobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob job = agentJobArray[n2];
                IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
                if (!(offeringOrFix instanceof IOffering) || !LicenseUtils.isPEKOffering((IOffering)((IOffering)offeringOrFix))) {
                    LicenseFactory.License[] licensesForOfferingOrFix = null;
                    licensesForOfferingOrFix = offeringLicenseMap == null || offeringLicenseMap.get(offeringOrFix) == null || ((String)offeringLicenseMap.get(offeringOrFix)).length() == 0 ? LicenseFactory.getInstance().findLicenseTextFor(offeringOrFix) : LicenseFactory.getInstance().findLicenseTextFor(offeringOrFix, (String)offeringLicenseMap.get(offeringOrFix));
                    if (licensesForOfferingOrFix.length > 0) {
                        licenseList.addAll(Arrays.asList(licensesForOfferingOrFix));
                    }
                }
                ++n2;
            }
            this.licenses = licenseList.toArray(new LicenseFactory.License[licenseList.size()]);
        }
        return this.licenses;
    }

    protected AgentUIWizard getAgentWizard() {
        return this.agentWizard;
    }

    protected List getSelectedJobs() {
        return this.agentWizard.getSelectedJobs();
    }

    public boolean shouldSkip() {
        if (this.getAgentWizard() == null) {
            return false;
        }
        List selectedJobs = this.getSelectedJobs();
        AbstractJob[] jobsArray = selectedJobs.toArray(new AbstractJob[selectedJobs.size()]);
        this.licenses = this.fetchLicenses((AgentJob[])jobsArray, this.agentWizard.getOfferingOrFixLicenseTypeMap());
        return this.licenses.length == 0;
    }

    public void setPageComplete(boolean complete) {
        if (complete) {
            List selectedJobs = this.getSelectedJobs();
            for (AbstractJob job : selectedJobs) {
                job.setAcceptLicense(true);
            }
        }
        super.setPageComplete(complete);
    }

    private void setAcceptLicense() {
        List selectedJobs = this.getSelectedJobs();
        if (selectedJobs.isEmpty()) {
            this.isAcceptLicense = false;
            return;
        }
        for (AbstractJob job : selectedJobs) {
            if (job.isAcceptLicense()) continue;
            this.isAcceptLicense = false;
            return;
        }
        this.isAcceptLicense = true;
    }

    protected String getDeclineMessage() {
        if (this.agentWizard.getWizardType().equals(WizardType.INSTALL) || this.agentWizard.getWizardType().equals(WizardType.UPDATE)) {
            return AgentLicensePageData.getDeclinedMessage();
        }
        if (this.agentWizard.getWizardType().equals(WizardType.LICENSE_MANAGEMENT)) {
            return Messages.LicensePage_DeclineMsg_ManageLicense;
        }
        return super.getDeclineMessage();
    }
}

