/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.InstallWizard;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserFeedbackProvider;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.YesNoErrorDialog;
import com.ibm.cic.common.ui.services.IBaseDialogService;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EclipseLocationPage
extends AbstractAgentUIWizardPage {
    private Button useExistingEclipseButton;
    private Text eclipseIDEText;
    private Text eclipseJVMText;
    private Button ideBrowseButton;
    private Button recheckStatusButton;
    private boolean skipped = false;
    boolean firstTimeVisible = true;
    private transient CustomMessageWizardPage.WarningId eclipseVerificationWarningId = new CustomMessageWizardPage.WarningId();
    private Label multipleProfileDes;
    private transient Profile profileToConfigureExistingEclipse;

    public EclipseLocationPage(FormToolkit toolkit, AgentUIWizard wizard) {
        super(toolkit, com.ibm.cic.agent.internal.ui.licenses.Messages.InstallLocationPage_title, Messages.EclipseLocationPage_description, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.EclipseLocationPage");
    }

    @Override
    public void createControl(Composite parent) {
        Composite detailsComposite = this.toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        detailsComposite.setLayout((Layout)layout);
        detailsComposite.setLayoutData((Object)new GridData(1808));
        if (this.getAgentWizard().isMultipleProfileInstall()) {
            this.createMultipleProfileDescription(detailsComposite);
        }
        this.createWarningArea(detailsComposite);
        this.createEclipseLocationArea(detailsComposite);
        this.setControl((Control)detailsComposite);
    }

    private void createMultipleProfileDescription(Composite parent) {
        Composite container = this.getToolkit().createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        this.multipleProfileDes = this.getToolkit().createLabel(container, "", 64);
        GridData data = new GridData(4, 1, true, false);
        this.multipleProfileDes.setLayoutData((Object)data);
    }

    private void createEclipseLocationArea(Composite parent) {
        Composite eclipseComposite = this.getToolkit().createComposite(parent);
        eclipseComposite.setLayout((Layout)new GridLayout());
        eclipseComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.useExistingEclipseButton = this.getToolkit().createButton(eclipseComposite, Messages.EclipseLocationPage_eclipseTitle, 32);
        this.useExistingEclipseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EclipseLocationPage.this.useExistingEclipseButton.getSelection()) {
                    EclipseLocationPage.this.eclipseIDEText.setEnabled(true);
                    EclipseLocationPage.this.ideBrowseButton.setEnabled(true);
                    EclipseLocationPage.this.recheckStatusButton.setEnabled(true);
                } else {
                    EclipseLocationPage.this.setEclipseLocation(EclipseLocationPage.this.profileToConfigureExistingEclipse.getInstallLocation());
                    EclipseLocationPage.this.eclipseIDEText.setEnabled(false);
                    EclipseLocationPage.this.ideBrowseButton.setEnabled(false);
                    EclipseLocationPage.this.recheckStatusButton.setEnabled(false);
                }
                EclipseLocationPage.this.validateEclipseLocation();
                EclipseLocationPage.this.updateButtons();
            }
        });
        Composite group = this.getToolkit().createComposite(eclipseComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 0;
        layout.marginBottom = 10;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        this.getToolkit().createLabel(group, Messages.EclipseLocationPage_eclipseIDELabel);
        this.eclipseIDEText = this.getToolkit().createText(group, "", 2048);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 10;
        this.eclipseIDEText.setLayoutData((Object)data);
        this.eclipseIDEText.setEnabled(false);
        this.eclipseIDEText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EclipseLocationPage.this.validateEclipseLocation();
                EclipseLocationPage.this.updateButtons();
            }
        });
        this.ideBrowseButton = this.getToolkit().createButton(group, Messages.EclipseLocationPage_eclipseBrowseButton, 0);
        this.ideBrowseButton.setEnabled(false);
        this.ideBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String directory;
                IBaseDialogService service = UiServices.getInstance().getDirectoryDialog(EclipseLocationPage.this.ideBrowseButton.getShell()).title(Messages.EclipseLocationPage_browseTitle).message(Messages.EclipseLocationPage_browseIDEDir);
                String ideDir = EclipseLocationPage.this.eclipseIDEText.getText();
                if (ideDir != null) {
                    service.filterPath(TextProcessor.deprocess((String)ideDir));
                }
                if ((directory = service.run()) != null) {
                    EclipseLocationPage.this.eclipseIDEText.setText(TextProcessor.process((String)directory));
                    EclipseLocationPage.this.validateEclipseLocation();
                    EclipseLocationPage.this.updateButtons();
                }
            }
        });
        this.getToolkit().createLabel(group, "");
        int originalBorderStyle = this.getToolkit().getBorderStyle();
        this.getToolkit().setBorderStyle(0);
        Text instruction = this.getToolkit().createText(group, Messages.EclipseLocationPage_ideLocation, 8);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.horizontalIndent = 10;
        gridData.horizontalSpan = 2;
        instruction.setLayoutData((Object)gridData);
        instruction.setEnabled(false);
        this.getToolkit().setBorderStyle(originalBorderStyle);
        Label fillerLabel = this.getToolkit().createLabel(group, "");
        GridData fillerData = new GridData();
        fillerData.horizontalSpan = 3;
        fillerLabel.setLayoutData((Object)fillerData);
        this.getToolkit().createLabel(group, Messages.EclipseLocationPage_eclipseJVMLabel);
        this.eclipseJVMText = this.getToolkit().createText(group, "", 2048);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 10;
        data.horizontalSpan = 2;
        this.eclipseJVMText.setLayoutData((Object)data);
        this.eclipseJVMText.setEnabled(false);
        Label separatorLabel = new Label(eclipseComposite, 258);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        separatorLabel.setLayoutData((Object)data);
        this.recheckStatusButton = this.getToolkit().createButton(eclipseComposite, Messages.ConditionalInstallPage_refreshButton, 8);
        this.recheckStatusButton.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
        this.recheckStatusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EclipseLocationPage.this.validateEclipseLocation();
                EclipseLocationPage.this.updateButtons();
            }
        });
    }

    private void createWarningArea(Composite parent) {
        Composite warningComposite = this.toolkit.createComposite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        warningComposite.setLayout((Layout)layout);
        warningComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label warningIcon = this.toolkit.createLabel(warningComposite, "", 0);
        warningIcon.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        warningIcon.setImage(DisplayKeeper.INSTANCE.getDisplay().getSystemImage(8));
        Label warningMessage = this.toolkit.createLabel(warningComposite, Messages.EclipseLocationPage_informationMessage, 64);
        warningMessage.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private String getIDELocation() {
        String eclipseLocation = this.profileToConfigureExistingEclipse.getEclipseLocation();
        return eclipseLocation == null ? "" : eclipseLocation;
    }

    private String getJVMLocation() {
        String location;
        if (this.profileToConfigureExistingEclipse.isExistingEclipseProfile() && (location = this.profileToConfigureExistingEclipse.getData("existing.jre.for.eclipse.ide.java.home")) != null) {
            return location;
        }
        return "";
    }

    private void validateEclipseLocation() {
        MapList profileToJobList;
        List selectedProductJobs;
        IStatus status;
        CicMultiStatus verificationStatus = Statuses.ST.createMultiStatus(com.ibm.cic.common.core.utils.Messages.MultipleWarnings, new Object[0]);
        if (this.useExistingEclipseButton.getSelection() && this.profileToConfigureExistingEclipse.isShadow()) {
            String location = TextProcessor.deprocess((String)this.eclipseIDEText.getText().trim());
            if (location.length() == 0) {
                this.setWarningMessage(this.eclipseVerificationWarningId, null);
                this.setErrorMessage(Messages.EclipseLocationPage_nonEclipseLocation);
                this.setPageComplete(false);
                return;
            }
            File ideDir = new File(location);
            boolean sameDirectories = PlatformUtils.areSameDirectories((String)location, (String)this.profileToConfigureExistingEclipse.getInstallLocation());
            if (!ideDir.isDirectory() && !sameDirectories) {
                this.setWarningMessage(this.eclipseVerificationWarningId, null);
                this.setErrorMessage(Messages.EclipseLocationPage_nonExistentEclipseIDELocationError);
                this.setPageComplete(false);
                return;
            }
            IStatus status2 = this.setEclipseLocation(location);
            if (StatusUtil.isErrorOrCancel((IStatus)status2)) {
                this.setWarningMessage(this.eclipseVerificationWarningId, null);
                this.setErrorMessageWithStatus(status2);
                this.setPageComplete(false);
                return;
            }
            if (!status2.isOK()) {
                verificationStatus.add(status2);
            }
            status2 = Agent.getInstance().qualifyNewProfile(this.profileToConfigureExistingEclipse);
            this.eclipseJVMText.setText(TextProcessor.process((String)this.getJVMLocation()));
            if (StatusUtil.isErrorOrCancel((IStatus)status2)) {
                this.setWarningMessage(this.eclipseVerificationWarningId, null);
                this.setErrorMessageWithStatus(status2);
                this.setPageComplete(false);
                return;
            }
            if (!status2.isOK()) {
                verificationStatus.add(status2);
            }
            if (!this.profileToConfigureExistingEclipse.isExistingEclipseProfile()) {
                this.setWarningMessage(this.eclipseVerificationWarningId, null);
                this.setErrorMessage(Messages.EclipseLocationPage_nonExistentEclipseError);
                this.setPageComplete(false);
                return;
            }
            status2 = this.profileToConfigureExistingEclipse.validateEclipseLocationCollision();
            if (StatusUtil.isErrorOrCancel((IStatus)status2)) {
                this.setWarningMessage(this.eclipseVerificationWarningId, null);
                this.setErrorMessageWithStatus(status2);
                this.setPageComplete(false);
                return;
            }
            if (!status2.isOK()) {
                verificationStatus.add(status2);
            }
        }
        if (StatusUtil.isErrorOrCancel((IStatus)(status = AgentUtil.getOfferingsApplicability((List)(selectedProductJobs = (profileToJobList = this.getAgentWizard().getProfileProductJobsMap()).get((Object)this.profileToConfigureExistingEclipse)))))) {
            this.setWarningMessage(this.eclipseVerificationWarningId, null);
            this.setErrorMessageWithStatus(status);
            this.setPageComplete(false);
            return;
        }
        if (!status.isOK()) {
            verificationStatus.add(status);
        }
        this.setErrorMessage(null);
        if (verificationStatus.getSeverity() == 2) {
            IStatus[] children = verificationStatus.getChildren();
            if (children != null && children.length == 1) {
                this.setWarningStateWithStatus(this.eclipseVerificationWarningId, children[0]);
            } else {
                this.setWarningStateWithStatus(this.eclipseVerificationWarningId, (IStatus)verificationStatus);
            }
        } else {
            this.setWarningMessage(this.eclipseVerificationWarningId, null);
        }
        this.setPageComplete(true);
    }

    private IStatus setEclipseLocation(String location) {
        String oldLocation = this.profileToConfigureExistingEclipse.getEclipseLocation();
        if (oldLocation.equals(location)) {
            return Status.OK_STATUS;
        }
        IStatus status = this.profileToConfigureExistingEclipse.setEclipseLocation(location);
        if (status.isOK()) {
            this.profileToConfigureExistingEclipse.setNeedsRequalification();
        }
        return status;
    }

    public void setVisible(boolean visible) {
        if (visible && this.firstTimeVisible) {
            this.firstTimeVisible = false;
            if (this.getAgentWizard().isMultipleProfileInstall() && this.multipleProfileDes != null && this.profileToConfigureExistingEclipse != null) {
                this.multipleProfileDes.setText(NLS.bind((String)Messages.MultipleProfileExistingEclipseDes, (Object)this.profileToConfigureExistingEclipse.getProfileId()));
                Composite parentControl = this.multipleProfileDes.getParent();
                if (parentControl != null) {
                    parentControl.layout();
                    if (parentControl.getParent() != null) {
                        parentControl.getParent().layout();
                    }
                }
            }
        }
        super.setVisible(visible);
    }

    @Override
    protected void setFocus() {
        String ideLocation = this.getIDELocation();
        String jvmLocation = this.getJVMLocation();
        if (this.profileToConfigureExistingEclipse.isShadow()) {
            this.useExistingEclipseButton.setEnabled(true);
            if (this.useExistingEclipse()) {
                this.useExistingEclipseButton.setSelection(true);
                this.eclipseJVMText.setText(TextProcessor.process((String)jvmLocation));
                this.eclipseIDEText.setText(TextProcessor.process((String)ideLocation));
                this.eclipseIDEText.setEnabled(true);
                this.ideBrowseButton.setEnabled(true);
                this.recheckStatusButton.setEnabled(true);
            } else {
                this.useExistingEclipseButton.setSelection(false);
                this.eclipseIDEText.setText("");
                this.eclipseJVMText.setText("");
                this.eclipseIDEText.setEnabled(false);
                this.ideBrowseButton.setEnabled(false);
                this.recheckStatusButton.setEnabled(false);
            }
        } else {
            this.useExistingEclipseButton.setEnabled(false);
            this.eclipseIDEText.setEnabled(false);
            this.ideBrowseButton.setEnabled(false);
            if (this.profileToConfigureExistingEclipse.hasEclipseLocation()) {
                this.useExistingEclipseButton.setSelection(true);
                this.eclipseIDEText.setText(TextProcessor.process((String)ideLocation));
                this.eclipseJVMText.setText(TextProcessor.process((String)jvmLocation));
                this.recheckStatusButton.setEnabled(true);
            } else {
                this.useExistingEclipseButton.setSelection(false);
                this.eclipseIDEText.setText("");
                this.eclipseJVMText.setText("");
            }
        }
    }

    public boolean isPageComplete() {
        return this.skipped ? true : super.isPageComplete();
    }

    public boolean shouldSkip() {
        AgentUIWizard wizard = this.getAgentWizard();
        if (!wizard.isMultipleProfileInstall()) {
            this.profileToConfigureExistingEclipse = this.getAgentWizard().getProductProfile();
        } else {
            if (wizard instanceof InstallWizard) {
                this.profileToConfigureExistingEclipse = ((InstallWizard)wizard).getProfileToConfigure();
            }
            if (this.profileToConfigureExistingEclipse == null) {
                this.profileToConfigureExistingEclipse = this.getAgentWizard().getProductProfile();
            }
        }
        MapList profileProductJobsMap = this.getAgentWizard().getProfileProductJobsMap();
        if (profileProductJobsMap != null && !profileProductJobsMap.isEmpty()) {
            List productJobs = profileProductJobsMap.get((Object)this.profileToConfigureExistingEclipse);
            boolean hasEclipseContext = AgentUtil.hasEclipseContext((AgentJob[])AgentJob.toArray((Collection)productJobs));
            boolean allowExistingEclipse = AgentUtil.isAllowExistingEclipse((AgentJob[])AgentJob.toArray((Collection)productJobs));
            if (this.profileToConfigureExistingEclipse != null && this.profileToConfigureExistingEclipse.isShadow() && hasEclipseContext && allowExistingEclipse) {
                this.skipped = false;
                return this.skipped;
            }
        }
        this.skipped = true;
        return this.skipped;
    }

    private boolean useExistingEclipse() {
        String eclipseIDELocation = this.getIDELocation();
        if (eclipseIDELocation.length() == 0) {
            return false;
        }
        String installLocation = this.profileToConfigureExistingEclipse.getInstallLocation();
        return !PlatformUtils.areSameDirectories((String)installLocation, (String)this.getIDELocation());
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        if (this.skipped) {
            return super.getNextPage();
        }
        final Profile profile = this.profileToConfigureExistingEclipse;
        if (profile.isShadow() && this.useExistingEclipse()) {
            final IStatus[] result_status = new IStatus[]{Status.OK_STATUS};
            try {
                CicCommonUiPlugin.getDefault().runWithSocketMonitor(false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.EclipseLocationPage_initializeEclipseTaskName, -1);
                        UserFeedbackProvider oldProvider = Agent.getInstance().setUserFeedbackProvider((UserFeedbackProvider)new EclipseInitializeFeedbackProvider());
                        try {
                            result_status[0] = Agent.getInstance().initializeNewProfile(profile);
                        }
                        finally {
                            Agent.getInstance().setUserFeedbackProvider(oldProvider);
                        }
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                this.setPageComplete(false);
                AgentUI.reportException(e, true);
                this.setErrorMessage(e.getLocalizedMessage());
                return this;
            }
            catch (InterruptedException e) {
                this.setPageComplete(false);
                AgentUI.reportException(e, true);
                this.setErrorMessage(e.getLocalizedMessage());
                return this;
            }
            if (StatusUtil.isErrorOrCancel((IStatus)result_status[0])) {
                this.setPageComplete(false);
                this.setErrorMessageWithStatus(result_status[0]);
                return this;
            }
            if (result_status[0].getSeverity() == 2) {
                this.setWarningStateWithStatus(this.eclipseVerificationWarningId, result_status[0]);
            }
        }
        return super.getNextPage();
    }

    private static class EclipseInitializeFeedbackProvider
    implements UserFeedbackProvider {
        private EclipseInitializeFeedbackProvider() {
        }

        public boolean confirmCancelWithUser(String msg) {
            return false;
        }

        public boolean confirmWithUser(final IStatus status, boolean statusHasConfirmMessage) {
            final boolean[] result = new boolean[1];
            DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell();
                    YesNoErrorDialog dialog = new YesNoErrorDialog(shell, Messages.InstallWizard_warningTitle, null, status, 1);
                    result[0] = dialog.open() == 2;
                }
            });
            return result[0];
        }

        public boolean keepDownloadedArtifacts(IStatus status, int downloadedCount, long downloadedSize) {
            return false;
        }
    }
}

