/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.wizards.AvailableOfferingPage;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryInstallWizard;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.utils.UserFeedback;
import com.ibm.cic.common.core.utils.UserFeedbackProvider;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.misc.PaUserFeedbackProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class AvailableOfferingPageWrapper
extends AvailableOfferingPage {
    private StackLayout stackLayout;
    private Composite hyperLinkComp;
    private Control availableOfferingControl;
    private final AgentUILabelProvider agentUILabelProvider = AgentUI.getDefault().getLabelProvider();

    public AvailableOfferingPageWrapper(PrimaryInstallWizard wizard) {
        super(wizard);
        this.agentUILabelProvider.connect(this);
    }

    @Override
    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }

    @Override
    public void createControl(Composite parent) {
        List jobs;
        Composite comp = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginWidth = 0;
        comp.setLayout((Layout)this.stackLayout);
        comp.setLayoutData((Object)new GridData(1808));
        super.createControl(comp);
        this.availableOfferingControl = this.getControl();
        this.hyperLinkComp = new Composite(comp, 2048);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 20;
        layout.marginHeight = 20;
        this.hyperLinkComp.setLayout((Layout)layout);
        this.hyperLinkComp.setLayoutData((Object)new GridData(1808));
        Label label1 = new Label(this.hyperLinkComp, 64);
        label1.setText(com.ibm.cic.agent.core.sharedUI.Messages.NoOfferingAvailablePage_label1);
        label1.setLayoutData((Object)new GridData(4, 1, true, false));
        new Label(this.hyperLinkComp, 0);
        Label label2 = new Label(this.hyperLinkComp, 0);
        label2.setText(Messages.NoOfferingAvailablePage_label2);
        label2.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite linkComp = new Composite(this.hyperLinkComp, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        linkComp.setLayout((Layout)gridLayout);
        linkComp.setLayoutData((Object)new GridData(4, 1, true, false));
        Label iconLabel1 = new Label(linkComp, 0);
        iconLabel1.setImage(this.agentUILabelProvider.get(CICImages.DESC_CATEGORY_OBJ));
        Link repLink = new Link(linkComp, 64);
        repLink.setText(Messages.NoOfferingAvailablePage_repLink);
        repLink.setLayoutData((Object)new GridData(768));
        repLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)AvailableOfferingPageWrapper.this.hyperLinkComp.getShell(), (String)"com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage", (String[])new String[]{"com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage", "com.ibm.cic.common.ui.internal.preferences.PassportAdvantagePreferencePage", "com.ibm.cic.agent.ui.InternetPreferencePage", "com.ibm.cic.common.ui.internal.preferences.HttpProxyPreferencePage", "com.ibm.cic.common.ui.internal.preferences.FtpProxyPreferencePage"}, null);
                if (dlg.open() == 0) {
                    AvailableOfferingPageWrapper.this.refresh();
                }
            }
        });
        Label iconLabel11 = new Label(linkComp, 0);
        iconLabel11.setImage(this.agentUILabelProvider.get(CICImages.DESC_CATEGORY_OBJ));
        Link updateOfferingLink = new Link(linkComp, 64);
        updateOfferingLink.setText(Messages.NoOfferingAvailablePage_UpdateOffering);
        updateOfferingLink.setLayoutData((Object)new GridData(768));
        Label iconLabel2 = new Label(linkComp, 0);
        iconLabel2.setImage(this.agentUILabelProvider.get(CICImages.DESC_CATEGORY_OBJ));
        Link pwaLink = new Link(linkComp, 64);
        pwaLink.setText(Messages.NoOfferingAvailablePage_passportAdvantageLink);
        pwaLink.setLayoutData((Object)new GridData(768));
        pwaLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)AvailableOfferingPageWrapper.this.hyperLinkComp.getShell(), (String)"com.ibm.cic.common.ui.internal.preferences.PassportAdvantagePreferencePage", (String[])new String[]{"com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage", "com.ibm.cic.common.ui.internal.preferences.PassportAdvantagePreferencePage", "com.ibm.cic.agent.ui.InternetPreferencePage", "com.ibm.cic.common.ui.internal.preferences.HttpProxyPreferencePage", "com.ibm.cic.common.ui.internal.preferences.FtpProxyPreferencePage"}, null);
                if (dlg.open() == 0) {
                    AvailableOfferingPageWrapper.this.refresh();
                }
            }
        });
        Label iconLabel3 = new Label(linkComp, 0);
        iconLabel3.setImage(this.agentUILabelProvider.get(CICImages.DESC_CATEGORY_OBJ));
        Link proxyLink = new Link(linkComp, 64);
        proxyLink.setText(Messages.NoOfferingAvailablePage_proxyLink);
        proxyLink.setLayoutData((Object)new GridData(768));
        proxyLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)AvailableOfferingPageWrapper.this.hyperLinkComp.getShell(), (String)"com.ibm.cic.common.ui.internal.preferences.HttpProxyPreferencePage", (String[])new String[]{"com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage", "com.ibm.cic.common.ui.internal.preferences.PassportAdvantagePreferencePage", "com.ibm.cic.agent.ui.InternetPreferencePage", "com.ibm.cic.common.ui.internal.preferences.HttpProxyPreferencePage", "com.ibm.cic.common.ui.internal.preferences.FtpProxyPreferencePage"}, null);
                if (dlg.open() == 0) {
                    AvailableOfferingPageWrapper.this.refresh();
                }
            }
        });
        Label iconLabel4 = new Label(linkComp, 0);
        iconLabel4.setImage(this.agentUILabelProvider.get(CICImages.DESC_CATEGORY_OBJ));
        Link refreshLink = new Link(linkComp, 64);
        refreshLink.setText(Messages.NoOfferingAvailablePage_fireWallLabel);
        refreshLink.setLayoutData((Object)new GridData(768));
        refreshLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvailableOfferingPageWrapper.this.refresh();
            }
        });
        final HashSet installedOfferings = AgentUIUtils.getInstalledProductOfferings();
        if (!installedOfferings.isEmpty()) {
            Label iconLabel5 = new Label(linkComp, 0);
            iconLabel5.setImage(this.agentUILabelProvider.get(CICImages.DESC_CATEGORY_OBJ));
            Link searchServiceRepLink = new Link(linkComp, 64);
            searchServiceRepLink.setText(Messages.NoOfferingAvailablePage_serviceRepForInstalledPkg);
            searchServiceRepLink.setLayoutData((Object)new GridData(4, 1, true, false));
            searchServiceRepLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ArrayList installedOfferingList = new ArrayList(installedOfferings);
                    AvailableOfferingPageWrapper.this.loadServiceRepAndRefresh(installedOfferingList.toArray(new IOffering[installedOfferingList.size()]));
                }
            });
        }
        if ((jobs = this.getJobs()) != null && !jobs.isEmpty()) {
            this.stackLayout.topControl = this.availableOfferingControl;
            this.availableOfferingControl.getParent().layout();
            super.setHelpRef("com.ibm.cic.agent.ui.AvailableOfferingPage");
            this.setDescription(this.combinePPAMsg(com.ibm.cic.agent.internal.console.Messages.AvailableOfferingPage_description));
        } else {
            this.stackLayout.topControl = this.hyperLinkComp;
            this.hyperLinkComp.layout();
            this.setDescription("");
            super.setHelpRef("com.ibm.cic.agent.ui.NoOfferingAvailablePage");
        }
        this.setControl((Control)comp);
    }

    private void refresh() {
        try {
            final IStatus[] status = new IStatus[1];
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    UserFeedbackProvider oldProvider = null;
                    try {
                        oldProvider = UserFeedback.setProvider((UserFeedbackProvider)new PaUserFeedbackProvider());
                        monitor.beginTask(com.ibm.cic.agent.internal.console.Messages.ProgressDialog_Obtain_offerings, 3);
                        SubProgressMonitor partMonitor = new SubProgressMonitor(monitor, 1);
                        status[0] = AgentUI.getDefault().getAgent().getRepositoryGroupStatus(true, (IProgressMonitor)partMonitor);
                        if (status[0].getSeverity() != 8) {
                            AgentInput agentInput = AgentInput.getInstance();
                            if (agentInput.getMode() == 1) {
                                if (!monitor.isCanceled()) {
                                    AgentUI.getDefault().setWizardJobs();
                                    monitor.worked(1);
                                }
                                if (!monitor.isCanceled()) {
                                    AvailableOfferingPageWrapper.this.setInput(agentInput.getWizardJobs());
                                    monitor.worked(1);
                                } else {
                                    AvailableOfferingPageWrapper.this.setInput(null);
                                }
                            } else {
                                ArrayList result = new ArrayList();
                                partMonitor = new SubProgressMonitor(monitor, 1);
                                List offerings = UpdateOfferingUtils.getAllOfferingsAndTheirUpdates((IRepository)Agent.getInstance().getRepositoryGroup(), (boolean)true, (IProgressMonitor)partMonitor);
                                result.addAll(offerings);
                                if (!monitor.isCanceled()) {
                                    ArrayList fixes = new ArrayList();
                                    partMonitor = new SubProgressMonitor(monitor, 1);
                                    for (IOffering offering : offerings) {
                                        fixes.addAll(Agent.getInstance().findFixes(offering, (IProgressMonitor)partMonitor));
                                    }
                                    result.addAll(fixes);
                                    AvailableOfferingPageWrapper.this.setInput(result.toArray());
                                } else {
                                    AvailableOfferingPageWrapper.this.setInput(null);
                                }
                            }
                        } else {
                            AvailableOfferingPageWrapper.this.setInput(null);
                        }
                    }
                    finally {
                        monitor.done();
                        UserFeedback.setProvider((UserFeedbackProvider)oldProvider);
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        List jobs = this.getJobs();
        if (jobs != null && !jobs.isEmpty()) {
            this.stackLayout.topControl = this.availableOfferingControl;
            this.offeringSection.resetTreeViewer();
            this.availableOfferingControl.getParent().layout();
            AgentUIUtils.updateHelpRefInsidePage(this, "com.ibm.cic.agent.ui.AvailableOfferingPage");
            this.checkInstalledOfferings();
            this.setDescription(this.combinePPAMsg(com.ibm.cic.agent.internal.console.Messages.AvailableOfferingPage_description));
        } else {
            this.stackLayout.topControl = this.hyperLinkComp;
            this.hyperLinkComp.layout();
            AgentUIUtils.updateHelpRefInsidePage(this, "com.ibm.cic.agent.ui.NoOfferingAvailablePage");
        }
    }

    private void loadServiceRepAndRefresh(final IOffering[] installedOfferings) {
        try {
            final IStatus[] status = new IStatus[1];
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    UserFeedbackProvider oldProvider = null;
                    try {
                        oldProvider = UserFeedback.setProvider((UserFeedbackProvider)new PaUserFeedbackProvider());
                        monitor.beginTask(com.ibm.cic.agent.internal.console.Messages.ProgressDialog_Obtain_offerings, 4);
                        SubProgressMonitor partMonitor = new SubProgressMonitor(monitor, 1);
                        status[0] = AgentUI.getDefault().getAgent().getRepositoryGroupStatus(true, (IProgressMonitor)partMonitor);
                        if (status[0].getSeverity() != 8) {
                            IRepositoryGroup repositories = AgentUI.getDefault().getAgent().getRepositoryGroup();
                            ServiceRepositoryUtils.loadServiceRepositoriesIfPrefIsSet((IRepositoryGroup)repositories, (IOffering[])installedOfferings, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            if (monitor.isCanceled()) {
                                AvailableOfferingPageWrapper.this.setInput(null);
                            } else {
                                AgentInput agentInput = AgentInput.getInstance();
                                if (agentInput.getMode() == 1) {
                                    if (!monitor.isCanceled()) {
                                        AgentUI.getDefault().setWizardJobs();
                                        monitor.worked(1);
                                    }
                                    if (!monitor.isCanceled()) {
                                        AvailableOfferingPageWrapper.this.setInput(agentInput.getWizardJobs());
                                        monitor.worked(1);
                                    } else {
                                        AvailableOfferingPageWrapper.this.setInput(null);
                                    }
                                } else {
                                    ArrayList result = new ArrayList();
                                    partMonitor = new SubProgressMonitor(monitor, 1);
                                    List offerings = UpdateOfferingUtils.getAllOfferingsAndTheirUpdates((IRepository)Agent.getInstance().getRepositoryGroup(), (boolean)true, (IProgressMonitor)partMonitor);
                                    result.addAll(offerings);
                                    if (!monitor.isCanceled()) {
                                        ArrayList fixes = new ArrayList();
                                        partMonitor = new SubProgressMonitor(monitor, 1);
                                        for (IOffering offering : offerings) {
                                            fixes.addAll(Agent.getInstance().findFixes(offering, (IProgressMonitor)partMonitor));
                                        }
                                        result.addAll(fixes);
                                        AvailableOfferingPageWrapper.this.setInput(result.toArray());
                                    } else {
                                        AvailableOfferingPageWrapper.this.setInput(null);
                                    }
                                }
                            }
                        } else {
                            AvailableOfferingPageWrapper.this.setInput(null);
                        }
                    }
                    finally {
                        monitor.done();
                        UserFeedback.setProvider((UserFeedbackProvider)oldProvider);
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        List jobs = this.getJobs();
        if (jobs != null && !jobs.isEmpty()) {
            this.stackLayout.topControl = this.availableOfferingControl;
            this.offeringSection.resetTreeViewer();
            this.availableOfferingControl.getParent().layout();
            AgentUIUtils.updateHelpRefInsidePage(this, "com.ibm.cic.agent.ui.AvailableOfferingPage");
            this.checkInstalledOfferings();
            this.setDescription(this.combinePPAMsg(com.ibm.cic.agent.internal.console.Messages.AvailableOfferingPage_description));
        } else {
            this.stackLayout.topControl = this.hyperLinkComp;
            this.hyperLinkComp.layout();
            AgentUIUtils.updateHelpRefInsidePage(this, "com.ibm.cic.agent.ui.NoOfferingAvailablePage");
        }
    }

    @Override
    public void dispose() {
        this.agentUILabelProvider.disconnect(this);
        super.dispose();
    }
}

