/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.internal.ui.utils.IProfileAndOfferings;
import com.ibm.cic.agent.internal.ui.utils.OfferingTreeNode;
import com.ibm.cic.common.core.model.IOffering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;

public class ProfileTreeNode
implements IProfileAndOfferings,
IAdaptable {
    private final Profile profile;
    private final Map<IOffering, OfferingTreeNode> offeringNodeMap = new HashMap<IOffering, OfferingTreeNode>();

    public ProfileTreeNode(Profile profile) {
        this.profile = profile;
    }

    public OfferingTreeNode addChild(IOffering installedOffering) {
        OfferingTreeNode offeringNode = this.offeringNodeMap.get(installedOffering);
        if (offeringNode == null) {
            offeringNode = new OfferingTreeNode(installedOffering, this);
            offeringNode.setInstalled(true);
            this.offeringNodeMap.put(installedOffering, offeringNode);
        }
        return offeringNode;
    }

    public OfferingTreeNode addChild(AbstractJob offeringJob) {
        IOffering offering = offeringJob.getOffering();
        OfferingTreeNode offeringNode = this.offeringNodeMap.get(offering);
        if (offeringNode == null) {
            offeringNode = new OfferingTreeNode(offeringJob, this);
            this.offeringNodeMap.put(offering, offeringNode);
        }
        return offeringNode;
    }

    public Collection<OfferingTreeNode> getChildren() {
        return this.offeringNodeMap.values();
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public Collection<IOffering> getOfferings() {
        ArrayList<IOffering> result = new ArrayList<IOffering>(this.offeringNodeMap.size());
        for (OfferingTreeNode offeringNode : this.offeringNodeMap.values()) {
            result.add(offeringNode.getOffering());
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        if (Profile.class.equals((Object)adapter) || IProfile.class.equals((Object)adapter)) {
            return this.profile;
        }
        return null;
    }
}

