/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.providers;

import com.ibm.cic.agent.core.RollbackJob;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.ui.internal.CommonImages;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class RollbackLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    protected AgentUILabelProvider agentLabelProvider = AgentUI.getDefault().getLabelProvider();

    public RollbackLabelProvider() {
        this.agentLabelProvider.connect((Object)this);
    }

    public void dispose() {
        this.agentLabelProvider.disconnect((Object)this);
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getText(element);
        }
        if (element instanceof RollbackJob) {
            RollbackJob job = (RollbackJob)element;
            IOffering offering = job.getOffering();
            switch (columnIndex) {
                case 1: {
                    if (offering != null) {
                        return offering.getName();
                    }
                }
                case 2: {
                    return job.getProfile().getProfileId();
                }
            }
        }
        return "";
    }

    public String getText(Object element) {
        if (element instanceof RollbackJob) {
            IOffering offering = ((RollbackJob)element).getOffering();
            String version = AgentUIUtils.getDisplayableVersion((IOfferingOrFix)offering);
            return NLS.bind((String)Messages.AvailableUpdateSection_version, (Object)version);
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof RollbackJob) {
            return this.agentLabelProvider.get(CommonImages.DESC_ROLLBACK_OBJ);
        }
        return super.getImage(element);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }
}

