/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.factories;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SubstitutionOperation;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.factories.LauncherFactoryNonAdminFilter;
import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.internal.BoundToOfferingOrFixFactory;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.MapSet;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public final class LauncherFactory
extends BoundToOfferingOrFixFactory {
    private static final Logger log = Logger.getLogger();
    private static final String VAR_CONFIG_LOCATION = "configLocation";
    private static final String VAR_INSTALL_LOCATION = "installLocation";
    private static final String VAR_ECLIPSE_LOCATION = "eclipseLocation";
    private static final String TAG_LAUNCHER = "launcher";
    private static final String ATT_LAUNCHER_ID = "id";
    private static final String ATT_BEFORE = "before";
    private static final String ATT_AFTER = "after";
    private static final String TAG_PLATFORM = "platform";
    static final String ATT_OS = "os";
    static final String ATT_IGNORE_ADMIN_CHECK = "ignoreAdminCheck";
    private static final String ATT_PATH = "path";
    private static final String ATT_WORKING_DIRECTORY = "workingDirectory";
    private static final String ATT_INSTALL_CONTEXT_ID = "installContextId";
    private static final String TAG_EXEC = "exec";
    private static final String ATT_COMMAND = "command";
    private static final String ATT_CHECK_EXISTENCE = "checkExistence";
    private static final String TAG_ARGUMENT = "arg";
    private static final String TAG_LAUNCHER_OFFERING_BINDING = "launcherOfferingBinding";
    private static final String ATT_LABEL = "label";
    private static final String ATT_LAUNCHER_EXTENSION_ID = "launcherId";
    private static final LauncherFactory INSTANCE = new LauncherFactory();
    private static final String TAG_FLOWTYPE = "phases";
    static final String ATT_FLOW = "flow";

    private LauncherFactory() {
    }

    public static LauncherFactory getInstance() {
        return INSTANCE;
    }

    protected Comparable createBindingEntry(IConfigurationElement element) {
        String launcherId = element.getAttribute(ATT_LAUNCHER_EXTENSION_ID);
        String label = element.getAttribute(ATT_LABEL);
        if (launcherId == null || label == null) {
            return null;
        }
        return new LauncherBinding(launcherId, label);
    }

    public Launcher[] findLaunchersFor(IOffering offering) {
        IExtensionPoint extnPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.cic.agent.ui", TAG_LAUNCHER);
        IExtension[] extensions = extnPoint.getExtensions();
        SortedMap launcherBindings = this.findOfferingOrFixBindings((IOfferingOrFix)offering, TAG_LAUNCHER_OFFERING_BINDING, null, extensions);
        CicMultiStatus status = Statuses.WARNING.getMultiStatus(Messages.LauncherFactory_launcherBindingError, new Object[]{offering.getIdentity(), offering.getVersion()});
        ArrayList<Launcher> launcherList = new ArrayList<Launcher>();
        for (Map.Entry entry : launcherBindings.entrySet()) {
            IConfigurationElement element;
            Launcher launcher;
            LauncherBinding binding = (LauncherBinding)entry.getKey();
            IExtension extension = (IExtension)entry.getValue();
            IConfigurationElement[] elements = this.findByTagAndAttr(TAG_LAUNCHER, ATT_LAUNCHER_ID, binding.launcherId, extension);
            if (elements.length == 0) {
                status.add((IStatus)Statuses.WARNING.get(binding.toString(), new Object[0]));
                continue;
            }
            if (elements.length > 1) {
                log.warning(Messages.LauncherFactory_duplicateLauncherId, new Object[]{binding.launcherId});
            }
            if ((launcher = this.createLauncher(element = elements[0], binding)) == null) continue;
            IConfigurationElement[] children = element.getChildren(TAG_FLOWTYPE);
            String flow = null;
            IConfigurationElement[] iConfigurationElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement childElement = iConfigurationElementArray[n2];
                flow = childElement.getAttribute(ATT_FLOW);
                if (flow.equals("UPDATE")) {
                    launcher.setShowLauncherUpdateMode(true);
                }
                ++n2;
            }
            launcherList.add(launcher);
            if (OfferingUtil.isMinimumAgentToleranceLessThan((IOfferingOrFix)offering, (Version)new Version("1.3.3")) || launcher.hasCommand()) continue;
            log.warning(Messages.LauncherFactory_pathAttrDeprecated, new Object[]{launcher.path});
        }
        if (status.hasChildren()) {
            log.status((IStatus)status);
        }
        return launcherList.toArray(new Launcher[launcherList.size()]);
    }

    Map getLauncherVariables(Profile profile) {
        HashMap<String, String> variables = new HashMap<String, String>(7);
        variables.put(VAR_INSTALL_LOCATION, profile.getInstallLocation());
        this.addEclipseLocationVar(variables, profile);
        this.addConfigLocationVar(variables, profile);
        return variables;
    }

    private void addEclipseLocationVar(Map variables, Profile profile) {
        String eclipseLocation = profile.getEclipseLocation();
        if (eclipseLocation != null) {
            variables.put(VAR_ECLIPSE_LOCATION, eclipseLocation);
        }
    }

    private void addConfigLocationVar(Map variables, Profile profile) {
        String configLocation;
        InstallContext eclipseContext;
        String contextId = profile.getData("eclipseContext");
        if (contextId != null && (eclipseContext = profile.findInstallContext(contextId)) != null && (configLocation = eclipseContext.getProperty(VAR_CONFIG_LOCATION)) != null) {
            variables.put(VAR_CONFIG_LOCATION, configLocation);
        }
    }

    private Launcher createLauncher(IConfigurationElement element, LauncherBinding binding) {
        IConfigurationElement[] children;
        IConfigurationElement[] iConfigurationElementArray = children = element.getChildren(TAG_PLATFORM);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement childElement = iConfigurationElementArray[n2];
            if (LauncherFactoryNonAdminFilter.getPolicy().checkElement(Platform.getOS(), childElement)) {
                String workingDirectory = childElement.getAttribute(ATT_WORKING_DIRECTORY);
                String installContextId = childElement.getAttribute(ATT_INSTALL_CONTEXT_ID);
                Launcher launcher = new Launcher(element, workingDirectory, installContextId, binding);
                IConfigurationElement[] exec = childElement.getChildren(TAG_EXEC);
                String path = childElement.getAttribute(ATT_PATH);
                if (exec.length > 0) {
                    IConfigurationElement[] argument;
                    String command = exec[0].getAttribute(ATT_COMMAND);
                    String checkExistenceValue = exec[0].getAttribute(ATT_CHECK_EXISTENCE);
                    boolean checkExistence = Boolean.valueOf(checkExistenceValue);
                    ArrayList<String> commandList = new ArrayList<String>();
                    commandList.add(command);
                    IConfigurationElement[] iConfigurationElementArray2 = argument = exec[0].getChildren(TAG_ARGUMENT);
                    int n3 = argument.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element2 = iConfigurationElementArray2[n4];
                        String value = element2.getValue();
                        commandList.add(value);
                        ++n4;
                    }
                    launcher.setCommand(commandList, checkExistence);
                    return launcher;
                }
                if (path != null) {
                    launcher.setPath(path);
                    return launcher;
                }
                log.error(Messages.LauncherFactory_noPathAttrOrExecError, new Object[]{element.getAttribute(ATT_LAUNCHER_ID)});
            }
            ++n2;
        }
        return null;
    }

    public static final class Launcher {
        private final String contributingBundle;
        private final String label;
        private final String workingDirectory;
        private final String installContextId;
        private final String launcherId;
        final Set before;
        final Set after;
        private final Map variables = new HashMap();
        private String path = null;
        private String[] command = CommonDef.EmptyStringArray;
        private boolean checkExistence = false;
        private Profile profile = null;
        private boolean showLauncherUpdateMode;

        public static List reorder(Collection launchers) {
            return new LauncherReorder(launchers).perform();
        }

        Launcher(IConfigurationElement element, String workingDirectory, String installContextId, LauncherBinding binding) {
            this.contributingBundle = element.getContributor().getName();
            this.before = Launcher.parseBeforeAfter(element.getAttribute(LauncherFactory.ATT_BEFORE));
            this.after = Launcher.parseBeforeAfter(element.getAttribute(LauncherFactory.ATT_AFTER));
            this.workingDirectory = workingDirectory;
            this.installContextId = installContextId;
            this.label = binding.label;
            this.launcherId = binding.launcherId;
            this.command = CommonDef.EmptyStringArray;
            this.checkExistence = false;
        }

        public String toString() {
            return this.getLabel();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Launcher) {
                Launcher that = (Launcher)obj;
                return Util.equals((Object)this.launcherId, (Object)that.launcherId) && Util.equals((Object)this.profile, (Object)that.profile);
            }
            return false;
        }

        public int hashCode() {
            return Util.hashCode((Object)this.launcherId) ^ Util.hashCode((Object)this.profile);
        }

        void setPath(String path) {
            assert (!this.hasCommand() && path != null);
            this.path = path;
        }

        void setCommand(List commandList, boolean checkExistence) {
            assert (this.path == null && !commandList.isEmpty());
            this.command = commandList.toArray(new String[commandList.size()]);
            this.checkExistence = checkExistence;
        }

        public void setProfile(Profile profile) {
            assert (this.profile == null);
            this.profile = profile;
            this.variables.putAll(LauncherFactory.getInstance().getLauncherVariables(profile));
        }

        public Profile getProfile() {
            return this.profile;
        }

        public boolean getShowLauncherUpdateMode() {
            return this.showLauncherUpdateMode;
        }

        public void setShowLauncherUpdateMode(boolean bVal) {
            this.showLauncherUpdateMode = bVal;
        }

        public void setVariable(String name, String value) {
            this.variables.put(name, value);
        }

        public IStatus launch() {
            String substitutedCommands = null;
            File dir = null;
            String[] substitutedCommandAndArgs = null;
            try {
                SubstitutionOperation operation = new SubstitutionOperation(this.getInstallContext());
                if (this.command.length > 0) {
                    substitutedCommandAndArgs = new String[this.command.length];
                    int i = 0;
                    while (i < this.command.length) {
                        substitutedCommandAndArgs[i] = this.performSubstitutions(operation, this.command[i]);
                        ++i;
                    }
                } else {
                    substitutedCommands = this.performSubstitutions(operation, this.path);
                }
                if (this.workingDirectory == null) {
                    String installLocation = this.getVariable(LauncherFactory.VAR_INSTALL_LOCATION);
                    dir = new File(installLocation);
                    if (!dir.isDirectory()) {
                        dir = null;
                    }
                } else {
                    dir = new File(this.performSubstitutions(operation, this.workingDirectory));
                }
            }
            catch (IllegalArgumentException e) {
                return new Status(4, this.contributingBundle, 0, e.getMessage(), (Throwable)e);
            }
            catch (AbstractVariableSubstitution.VariableSubstitutionException e) {
                return new Status(4, this.contributingBundle, 0, e.getMessage(), (Throwable)e);
            }
            try {
                if (dir != null && !(dir = dir.getCanonicalFile()).isDirectory()) {
                    throw new FileNotFoundException("Working directory not found: " + dir.getPath());
                }
                if (substitutedCommandAndArgs != null) {
                    log.debug("Launching in \"{0}\": {1}", new Object[]{dir, substitutedCommandAndArgs});
                    Runtime.getRuntime().exec(substitutedCommandAndArgs, PlatformUtils.getEnvironmentVariablesArg(), dir);
                } else if (substitutedCommands != null) {
                    log.debug("Launching in \"{0}\": {1}", new Object[]{dir, substitutedCommands});
                    Runtime.getRuntime().exec(substitutedCommands, PlatformUtils.getEnvironmentVariablesArg(), dir);
                }
            }
            catch (IOException e) {
                return new Status(4, this.contributingBundle, 0, NLS.bind((String)Messages.LauncherFactory_problemLaunchingProgram, (Object)this.getCommand()), (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        private InstallContext getInstallContext() {
            String contextId = this.installContextId;
            if (contextId == null && (contextId = this.profile.getData("eclipseContext")) == null) {
                return this.profile.getRootContext();
            }
            InstallContext context = this.profile.findInstallContext(contextId);
            if (context == null) {
                if (this.installContextId != null) {
                    log.warning("Could not resolve launcher installContextId: {0}", new Object[]{contextId});
                }
                return this.profile.getRootContext();
            }
            return context;
        }

        private String performSubstitutions(SubstitutionOperation operation, String attrValue) throws IllegalArgumentException, AbstractVariableSubstitution.VariableSubstitutionException {
            String result = this.performSubstitutions(attrValue);
            return operation.performVariableSubstitutions(result);
        }

        private String performSubstitutions(String attrValue) throws IllegalArgumentException {
            if (attrValue.indexOf(36) < 0) {
                return attrValue;
            }
            Pattern pattern = Pattern.compile("^(.*?)\\$([^${}]+)\\$(.*)$");
            String result = attrValue;
            Matcher matcher;
            while ((matcher = pattern.matcher(result)).find()) {
                result = String.valueOf(matcher.group(1)) + this.getVariable(matcher.group(2)) + matcher.group(3);
            }
            return result;
        }

        public String getLauncherId() {
            return this.launcherId;
        }

        public String getLabel() {
            return this.label;
        }

        public String getCommand() {
            try {
                SubstitutionOperation operation = new SubstitutionOperation(this.getInstallContext());
                if (this.command.length > 0) {
                    StringBuffer sb = new StringBuffer();
                    String[] stringArray = this.command;
                    int n = this.command.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String element = stringArray[n2];
                        sb.append(this.performSubstitutions(operation, element));
                        sb.append(' ');
                        ++n2;
                    }
                    sb.setLength(sb.length() - 1);
                    return sb.toString();
                }
                return this.performSubstitutions(operation, this.path);
            }
            catch (AbstractVariableSubstitution.VariableSubstitutionException e) {
                return null;
            }
        }

        public boolean hasCommand() {
            return this.command.length > 0;
        }

        public boolean commandExists() {
            if (!this.checkExistence) {
                return true;
            }
            File commandFile = null;
            if (this.profile == null) {
                commandFile = new File(this.command[0]);
            } else {
                SubstitutionOperation operation = new SubstitutionOperation(this.getInstallContext());
                try {
                    commandFile = new File(this.performSubstitutions(operation, this.command[0]));
                }
                catch (IllegalArgumentException e) {
                    log.warning((Throwable)e);
                    return false;
                }
                catch (AbstractVariableSubstitution.VariableSubstitutionException e) {
                    return false;
                }
            }
            return commandFile.exists();
        }

        private String getVariable(String name) {
            String value = (String)this.variables.get(name);
            if (value == null) {
                throw new IllegalArgumentException("Could not resolve variable: " + name);
            }
            return value;
        }

        private static Set parseBeforeAfter(String attr) {
            String trimmed;
            if (attr != null && (trimmed = attr.trim()).length() > 0) {
                return new HashSet<String>(Arrays.asList(trimmed.split("\\s*,\\s*")));
            }
            return new HashSet(0);
        }
    }

    private static final class LauncherBinding
    implements Comparable {
        final String launcherId;
        final String label;

        LauncherBinding(String launcherId, String label) {
            this.launcherId = launcherId;
            this.label = label;
        }

        public String toString() {
            return this.launcherId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LauncherBinding) {
                LauncherBinding other = (LauncherBinding)obj;
                return other.launcherId.equals(this.launcherId);
            }
            return false;
        }

        public int hashCode() {
            return this.launcherId.hashCode();
        }

        public int compareTo(Object o) {
            if (o instanceof LauncherBinding) {
                LauncherBinding other = (LauncherBinding)o;
                return this.launcherId.compareTo(other.launcherId);
            }
            return -1;
        }
    }

    private static class LauncherReorder {
        private final Set launchers;
        private final MapList idToLaunchers = new MapList();
        private final MapSet after = new MapSet.MapHashSet();

        LauncherReorder(Collection launchers) {
            this.launchers = new LinkedHashSet(launchers);
            for (Launcher launcher : launchers) {
                this.idToLaunchers.add((Object)launcher.getLauncherId(), (Object)launcher);
            }
            for (Launcher launcher : launchers) {
                for (String id : launcher.after) {
                    this.after.addAll((Object)launcher, (Collection)this.idToLaunchers.get((Object)id));
                }
                for (String id : launcher.before) {
                    for (Launcher l : this.idToLaunchers.get((Object)id)) {
                        this.after.add((Object)l, (Object)launcher);
                    }
                }
            }
        }

        List perform() {
            ArrayList<Launcher> result = new ArrayList<Launcher>(this.launchers.size());
            while (!this.launchers.isEmpty()) {
                Launcher launcher = this.getNext();
                result.add(launcher);
                this.launchers.remove(launcher);
            }
            return result;
        }

        private Launcher getNext() {
            assert (!this.launchers.isEmpty());
            for (Launcher launcher : this.launchers) {
                if (!this.allAfterAreDone(launcher)) continue;
                return launcher;
            }
            Launcher launcher = (Launcher)this.launchers.iterator().next();
            this.logCircularity(launcher, new LinkedList());
            return launcher;
        }

        private boolean logCircularity(Launcher launcher, LinkedList cycle) {
            cycle.addLast(launcher);
            for (Launcher l : this.after.get((Object)launcher)) {
                if (cycle.contains(l)) {
                    cycle.addLast(l);
                    while (!l.equals(cycle.getFirst())) {
                        cycle.removeFirst();
                    }
                    log.warningNoUid("Circular 'after' relationship in launchers: {0}", new Object[]{Util.toString((Collection)cycle, (Util.Formatter)new Util.Formatter(" -> "){

                        protected String format(Object object) {
                            return ((Launcher)object).getLauncherId();
                        }
                    })});
                    return true;
                }
                if (!this.logCircularity(l, cycle)) continue;
                return true;
            }
            cycle.removeLast();
            return false;
        }

        private boolean allAfterAreDone(Launcher launcher) {
            for (Launcher l : this.after.get((Object)launcher)) {
                if (!this.launchers.contains(l)) continue;
                return false;
            }
            return true;
        }
    }
}

