/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.dialogs;

import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.ui.CICImages;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DataLocationDialog
extends TitleAreaDialog {
    private Button browseButton;
    private Text locationText;
    private Image titleImage;

    public DataLocationDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.titleImage = CICImages.WIZ_INSTALL.createImage();
        this.setTitleImage(this.titleImage);
        this.verifyLocation();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(com.ibm.cic.agent.core.sharedUI.Messages.DataLocationDialog_Title);
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite comp = new Composite(parentComposite, 0);
        comp.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.widthHint = 500;
        comp.setLayoutData((Object)gridData);
        Composite group = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 15;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Label desLabel = new Label(group, 64);
        desLabel.setText(com.ibm.cic.agent.core.sharedUI.Messages.DataLocationDialog_Message);
        GridData desData = new GridData(4, 0x1000000, true, false);
        desData.horizontalSpan = 3;
        desLabel.setLayoutData((Object)desData);
        Label locationLabel = new Label(group, 0);
        locationLabel.setText(com.ibm.cic.agent.core.sharedUI.Messages.DataLocationDialog_Label);
        this.locationText = new Text(group, 2048);
        this.locationText.setLayoutData((Object)new GridData(1808));
        this.locationText.setText(TextProcessor.process((String)CicCommonSettings.getApplicationDataLocation()));
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataLocationDialog.this.verifyLocation();
            }
        });
        this.browseButton = new Button(group, 8);
        this.browseButton.setText(com.ibm.cic.common.ui.internal.Messages.AddRepositoryDialog_browseBtn);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path;
                File file;
                DirectoryDialog dlg = new DirectoryDialog(DataLocationDialog.this.getShell());
                dlg.setText(Messages.DataLocationDialog_DirectoryDialogTitle);
                dlg.setMessage(Messages.DataLocationDialog_DirectoryDialogMessage);
                String fullPathName = DataLocationDialog.this.locationText.getText().trim();
                if (fullPathName.length() != 0 && (file = new File(TextProcessor.deprocess((String)fullPathName))).isDirectory()) {
                    dlg.setFilterPath(file.getPath());
                }
                if ((path = dlg.open()) != null) {
                    DataLocationDialog.this.locationText.setText(TextProcessor.process((String)path));
                }
            }
        });
        return parentComposite;
    }

    private void verifyLocation() {
        String dataLocation = TextProcessor.deprocess((String)this.locationText.getText().trim());
        IStatus status = SharedUIUtils.verifyDataLocation((String)dataLocation);
        if (status.matches(4)) {
            this.setMessage(status.getMessage(), 3);
            this.getButton(0).setEnabled(false);
        } else if (status.matches(2)) {
            this.setMessage(status.getMessage(), 2);
            this.getButton(0).setEnabled(true);
        } else {
            this.setMessage(null, 0);
            this.getButton(0).setEnabled(true);
        }
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(com.ibm.cic.agent.core.sharedUI.Messages.DataLocationDialog_ShellTitle);
        super.configureShell(newShell);
    }

    public boolean close() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
            this.titleImage = null;
        }
        return super.close();
    }
}

