/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.publish;

import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.ProfileRegistry;
import com.ibm.cic.agent.publish.InstallPublicationXML;
import com.ibm.cic.common.core.definitions.ProfileArch;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.repository.RepositoryInfo;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IProblemResolved;
import com.ibm.cic.common.core.model.IProblemsResolved;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.MetaInfo;
import com.ibm.cic.common.core.utils.XMLWriter;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Version;

public class InstallPublication {
    private static final Logger log = Logger.getLogger(InstallPublication.class);
    private final InstallRegistry installRegistry;
    private final ProfileRegistry profileRegistry;

    public InstallPublication(InstallRegistry installRegistry, ProfileRegistry profileRegistry) {
        this.installRegistry = installRegistry;
        this.profileRegistry = profileRegistry;
    }

    public void publish() throws IOException {
        File xmlFile = new File(InstallPublication.getPublicationLocation(this.installRegistry), "installed.xml");
        new FileUtil.SafeUpdate(xmlFile){

            public void write(FileOutputStream stream) throws IOException {
                XMLWriter writer = new XMLWriter((OutputStream)stream, XML.getProcessingInstructions());
                XML.write(InstallPublication.this.installRegistry, InstallPublication.this.profileRegistry, writer);
                writer.flush();
                FileUtil.fdSync((FileDescriptor)stream.getFD());
                writer.close();
            }
        }.write();
    }

    public static File getPublicationLocation(InstallRegistry registry) {
        File directory = registry.getLocation().getParentFile();
        InstallPublication.ensureXSL(directory, "installed.xsl");
        InstallPublication.ensureXSD(directory, "installed.xsd");
        return directory;
    }

    public static void ensureXSL(File dir, String name) {
        InputStream input;
        File dstFile = new File(dir, name);
        dstFile.exists();
        ClassLoader loader = InstallPublication.class.getClassLoader();
        String resource = String.valueOf(InstallPublication.class.getPackage().getName().replace('.', '/')) + '/' + name;
        InputStream inputStream = input = loader == null ? ClassLoader.getSystemResourceAsStream(resource) : loader.getResourceAsStream(resource);
        if (input == null) {
            log.warning(Messages.FileLog_Failed_To_Find_Resource, new Object[]{resource});
            return;
        }
        String contents = null;
        try {
            try {
                contents = FileUtil.readStream((InputStream)input);
            }
            catch (IOException e) {
                log.warning(Messages.FileLog_Error_Reading_Resource, new Object[]{resource, e.getMessage()});
                try {
                    input.close();
                }
                catch (IOException e2) {
                    ExceptionUtil.debugLogToReview((Throwable)e2);
                }
                return;
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                ExceptionUtil.debugLogToReview((Throwable)e);
            }
        }
        contents = contents.replaceAll("%InstallPublication_Title", com.ibm.cic.agent.internal.core.Messages.InstallPublication_Title);
        contents = contents.replaceAll("%InstallPublication_Installation_Location", com.ibm.cic.agent.internal.core.Messages.InstallPublication_Installation_Location);
        contents = contents.replaceAll("%InstallPublication_SharedResourceDirectory", com.ibm.cic.agent.internal.core.Messages.InstallPublication_SharedResourceDirectory);
        contents = contents.replaceAll("%InstallPublication_AgentDirectory", com.ibm.cic.agent.internal.core.Messages.InstallPublication_AgentDirectory);
        contents = contents.replaceAll("%InstallPublication_Version", com.ibm.cic.agent.internal.core.Messages.InstallPublication_Version);
        contents = contents.replaceAll("%InstallPublication_Package_Group_Name", com.ibm.cic.agent.internal.core.Messages.InstallPublication_Package_Group_Name);
        contents = contents.replaceAll("%InstallPublication_Package_Group_Location", com.ibm.cic.agent.internal.core.Messages.InstallPublication_Package_Group_Location);
        contents = contents.replaceAll("%InstallPublication_Package_Group_Eclipse_IDE", com.ibm.cic.agent.internal.core.Messages.InstallPublication_Package_Group_Eclipse_IDE);
        contents = contents.replaceAll("%InstallPublication_Package_Group_Languages", com.ibm.cic.agent.internal.core.Messages.InstallPublication_Package_Group_Languages);
        contents = contents.replaceAll("%InstallPublication_Architecture_Xsl", InstallPublication.getPackageGroupArchXsl(com.ibm.cic.agent.internal.core.Messages.InstallPublication_Architecture));
        contents = contents.replaceAll("%InstallPublication_Package_Group_Arch_Xsl", InstallPublication.getPackageGroupArchXsl(com.ibm.cic.agent.internal.core.Messages.InstallPublication_Package_Group_Arch));
        contents = contents.replaceAll("%InstallPublication_Packages", com.ibm.cic.agent.internal.core.Messages.InstallPublication_Packages);
        contents = contents.replaceAll("%InstallPublication_Features", com.ibm.cic.agent.internal.core.Messages.InstallPublication_Features);
        contents = contents.replaceAll("%InstallPublication_Repository", com.ibm.cic.agent.internal.core.Messages.InstallPublication_Repository);
        contents = contents.replaceAll("%InstallPublication_Fixes", com.ibm.cic.agent.internal.core.Messages.InstallPublication_Fixes);
        try {
            FileUtil.writeFile((File)dstFile, (String)contents);
        }
        catch (IOException e) {
            log.warning(Messages.FileLog_Error_Writing, new Object[]{dstFile, e.getMessage()});
        }
    }

    public static void ensureXSD(File dir, String name) {
        InputStream input;
        File dstFile = new File(dir, name);
        ClassLoader loader = InstallPublication.class.getClassLoader();
        String resource = String.valueOf(InstallPublication.class.getPackage().getName().replace('.', '/')) + '/' + name;
        InputStream inputStream = input = loader == null ? ClassLoader.getSystemResourceAsStream(resource) : loader.getResourceAsStream(resource);
        if (input == null) {
            log.warning(Messages.FileLog_Failed_To_Find_Resource, new Object[]{resource});
            return;
        }
        String contents = null;
        try {
            try {
                contents = FileUtil.readStream((InputStream)input);
            }
            catch (IOException e) {
                log.warning(Messages.FileLog_Error_Reading_Resource, new Object[]{resource, e.getMessage()});
                try {
                    input.close();
                }
                catch (IOException e2) {
                    ExceptionUtil.debugLogToReview((Throwable)e2);
                }
                return;
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                ExceptionUtil.debugLogToReview((Throwable)e);
            }
        }
        try {
            FileUtil.writeFile((File)dstFile, (String)contents);
        }
        catch (IOException e) {
            log.warning(Messages.FileLog_Error_Writing, new Object[]{dstFile, e.getMessage()});
        }
    }

    private static String getPackageGroupArchXsl(String architectureName) {
        if (!BitModeUtils.isMultiBitModePlatform()) {
            return "";
        }
        StringWriter sw = new StringWriter(512);
        PrintWriter pw = new PrintWriter(sw);
        String indent = "                ";
        pw.println(String.valueOf(indent) + "<tr>");
        pw.println(String.valueOf(indent) + "    <th>" + architectureName + "</th>");
        pw.println(String.valueOf(indent) + "    <td>");
        pw.println(String.valueOf(indent) + "        <xsl:variable name='archi' select=\"./property[@name='cic.selector.arch']\"/>");
        pw.println(String.valueOf(indent) + "        <xsl:choose>");
        pw.println(String.valueOf(indent) + "            <xsl:when test=\"" + InstallPublication.getArchTest(ProfileArch.get64bitArchitectures()) + "\">");
        pw.println(String.valueOf(indent) + "                " + BitModeUtils.getBitModeText(64));
        pw.println(String.valueOf(indent) + "            </xsl:when>");
        pw.println(String.valueOf(indent) + "            <xsl:otherwise>");
        pw.println(String.valueOf(indent) + "                " + BitModeUtils.getBitModeText(32));
        pw.println(String.valueOf(indent) + "            </xsl:otherwise>");
        pw.println(String.valueOf(indent) + "        </xsl:choose>");
        pw.println(String.valueOf(indent) + "    </td>");
        pw.println(String.valueOf(indent) + "</tr>");
        pw.close();
        return sw.toString();
    }

    private static String getArchTest(Set<String> architectures) {
        StringBuilder sb = new StringBuilder();
        for (String arch : architectures) {
            if (sb.length() != 0) {
                sb.append(" or ");
            }
            sb.append("\\$archi[@value='");
            sb.append(arch);
            sb.append("']");
        }
        return sb.toString();
    }

    private static class XML
    implements InstallPublicationXML {
        private XML() {
        }

        public static XMLWriter.ProcessingInstruction[] getProcessingInstructions() {
            return new XMLWriter.ProcessingInstruction[]{new XMLWriter.ProcessingInstruction("installInfo", MetaInfo.formatVersion((Version)MetaInfo.INSTALL_PUBLICATION_VERSION)), new XMLWriter.ProcessingInstruction("xml-stylesheet", new String[]{"type", "href"}, new String[]{"text/xsl", "installed.xsl"})};
        }

        public static void write(InstallRegistry installRegistry, ProfileRegistry profileRegistry, XMLWriter writer) {
            writer.start("installInfo");
            writer.attribute("xmlns:xsi", (Object)"http://www.ibm.com/rational/com.ibm.cic.installed");
            writer.attribute("xmlns:installed", (Object)"http://www.ibm.com/rational/com.ibm.cic.installed");
            writer.attribute("xsi:schemaLocation", (Object)"http://www.ibm.com/rational/com.ibm.cic.installed");
            if (!InstallRegistry.getInstance().isEmpty()) {
                writer.write(profileRegistry.getProperties());
                if (installRegistry.getCacheLocation() != null) {
                    writer.writeProperty("cacheLocation", installRegistry.getCacheLocation());
                }
                InstallRegistry.ProfileInstallRegistry selfRegistry = null;
                for (InstallRegistry.ProfileInstallRegistry registry : installRegistry.getProfileInstallRegistries()) {
                    Profile profile = registry.getProfile();
                    if (profile == null) continue;
                    if (!profile.isAgentProfile()) {
                        XML.emit(registry, writer);
                        continue;
                    }
                    selfRegistry = registry;
                }
                if (selfRegistry != null) {
                    XML.emit(selfRegistry, writer);
                }
            } else {
                writer.attribute("empty", true);
            }
            writer.end("installInfo");
        }

        private static void emit(InstallRegistry.ProfileInstallRegistry registry, XMLWriter writer) {
            if (!registry.isEmpty()) {
                IOffering[] offerings;
                Profile profile = registry.getProfile();
                writer.start("location");
                writer.attribute("id", (Object)profile.getProfileId());
                writer.attribute("kind", (Object)profile.getProfileKind());
                writer.attribute("path", (Object)profile.getInstallLocation());
                LinkedProperties data = profile.getAllData();
                String[] stringArray = data.getPropertyKeys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    if (!profile.isSensitiveUserData(key)) {
                        writer.writeProperty(key, data.getProperty(key));
                    }
                    ++n2;
                }
                IOffering[] iOfferingArray = offerings = registry.getInstalledOfferings();
                int n3 = offerings.length;
                n = 0;
                while (n < n3) {
                    IOffering offering = iOfferingArray[n];
                    XML.emit(registry, offering, writer);
                    ++n;
                }
                writer.end("location");
            }
        }

        private static void emit(InstallRegistry.ProfileInstallRegistry registry, IOffering offering, XMLWriter writer) {
            IFix[] fixes;
            IFeature[] features;
            writer.start("package");
            writer.attribute("kind", (Object)"offering");
            writer.attribute("name", (Object)offering.getName());
            writer.attribute("id", (Object)offering.getIdentity());
            writer.attribute("version", (Object)offering.getVersion());
            XML.emit(offering.getInformation(), writer);
            String serializedRepInfo = registry.getInstalledRepositoryInfo((IOfferingOrFix)offering);
            if (serializedRepInfo != null) {
                RepositoryInfo repInfo = RepositoryInfo.deserialize((String)serializedRepInfo);
                String repLocation = repInfo.getLocationStr();
                writer.writeProperty("agent.sourceRepositoryLocation", repLocation);
            }
            offering.getProperties().setProperty("offering.license.type", LicenseUtils.getRuntimeLicenseKinds((IOffering)offering));
            offering.getProperties().setProperty("offering.license.expiration", LicenseUtils.getRuntimeLicenseExpiration((IOffering)offering));
            writer.write(offering.getProperties());
            XML.emitResolvedProblemsProperties(offering.getProblemsResolvedList(), writer);
            IFeature[] iFeatureArray = features = registry.getInstalledFeaturesAsArray(offering);
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                IFeature feature = iFeatureArray[n2];
                XML.emit(feature, writer);
                ++n2;
            }
            IFix[] iFixArray = fixes = registry.getInstalledFixes(offering);
            int n3 = fixes.length;
            n = 0;
            while (n < n3) {
                IFix fix = iFixArray[n];
                XML.emit(fix, writer);
                ++n;
            }
            writer.end("package");
        }

        private static void emit(IFeature feature, XMLWriter writer) {
            writer.start("package");
            writer.attribute("kind", (Object)"feature");
            writer.attribute("id", (Object)feature.getIdentity());
            XML.emit(feature.getInformation(), writer);
            XML.emitProperty("cic.feature.kind", feature.getKind().toString(), writer);
            writer.end("package");
        }

        private static void emit(IFix fix, XMLWriter writer) {
            writer.start("package");
            writer.attribute("kind", (Object)"fix");
            writer.attribute("name", (Object)fix.getName());
            writer.attribute("id", (Object)fix.getIdentity());
            writer.attribute("version", (Object)fix.getVersion());
            XML.emit(fix.getInformation(), writer);
            writer.write(fix.getProperties());
            XML.emitResolvedProblemsProperties(fix.getProblemsResolvedList(), writer);
            writer.end("package");
        }

        private static void emit(Information info, XMLWriter writer) {
            if (info != null) {
                XML.emitProperty("cic.info.name", info.getName(), writer);
                XML.emitProperty("cic.info.version", info.getVersion(), writer);
                XML.emitProperty("cic.info.provider", info.getProvider(), writer);
            }
        }

        private static void emitProperty(String key, String value, XMLWriter writer) {
            if (value != null) {
                writer.writeProperty(key, value);
            }
        }

        private static void emitResolvedProblemsProperties(List problemList, XMLWriter writer) {
            if (problemList.size() < 1) {
                return;
            }
            StringBuffer pIds = new StringBuffer(64);
            int i = 0;
            while (i < problemList.size()) {
                IProblemsResolved problems = (IProblemsResolved)problemList.get(i);
                List problemsList = problems.getProblems();
                int j = 0;
                while (j < problemsList.size()) {
                    IProblemResolved p = (IProblemResolved)problemsList.get(j);
                    String pid = p.getId();
                    pIds.append(pid);
                    if (j < problemsList.size() - 1) {
                        pIds.append(",");
                    }
                    writer.writeProperty("cic.fixed.problem.displayId_" + pid, p.getDisplayId());
                    String pDesc = p.getDescription();
                    if (pDesc != null && pDesc.length() > 0) {
                        writer.writeProperty("cic.fixed.problem.description_" + pid, pDesc);
                    }
                    ++j;
                }
                ++i;
            }
            if (pIds.length() > 0) {
                writer.writeProperty("cic.fixed.problems", pIds.toString());
            }
        }
    }
}

