/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.api.ILogEntry;
import com.ibm.cic.agent.core.api.ILogStackFilter;
import com.ibm.cic.agent.core.api.ILogger;
import com.ibm.cic.common.logging.ILogListener;
import com.ibm.cic.common.logging.LogEntry;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;

public class IMLoggerImpl
implements ILogger {
    private final Logger logger;

    public IMLoggerImpl(String name) {
        this(Logger.getLogger((String)name));
    }

    public IMLoggerImpl(Class clazz) {
        this(Logger.getLogger((Class)clazz));
    }

    public IMLoggerImpl() {
        this(Logger.getGlobalLogger());
    }

    public IMLoggerImpl(Class clazz, Plugin plugin) {
        this(Logger.getLogger((Class)clazz, (Plugin)plugin));
    }

    public IMLoggerImpl(String name, Plugin plugin) {
        this(Logger.getLogger((String)name, (Plugin)plugin));
    }

    public IMLoggerImpl(Class clazz, String debugOption) {
        this(Logger.getLogger((Class)clazz, (String)debugOption));
    }

    public IMLoggerImpl(String debugOptionOrName, boolean isDebugOption) {
        this(isDebugOption ? Logger.getLoggerUsingDebug((String)debugOptionOrName) : Logger.getLogger((String)debugOptionOrName));
    }

    private IMLoggerImpl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ILogEntry log(int level, String key) {
        return new IMLogEntry(this.logger.log(level, key));
    }

    @Override
    public ILogEntry log(int level, String key, Throwable exception) {
        return new IMLogEntry(this.logger.log(level, exception, key, new Object[0]));
    }

    @Override
    public ILogEntry log(int level, String key, Object[] args) {
        return new IMLogEntry(this.logger.log(level, null, key, args));
    }

    @Override
    public ILogEntry log(int level, String key, Object[] args, URL url) {
        return new IMLogEntry(this.logger.log(level, url.toString(), key, args));
    }

    @Override
    public File createExternalLogFile(String prefix, String suffix) {
        return LogManager.createExternalLogFile((String)prefix, (String)suffix);
    }

    @Override
    public ILogEntry debug(Object obj) {
        return new IMLogEntry(this.logger.debug(obj));
    }

    @Override
    public ILogEntry debug(Throwable e) {
        return new IMLogEntry(this.logger.debug(e));
    }

    @Override
    public ILogEntry debug(String key) {
        return new IMLogEntry(this.logger.debug(key));
    }

    @Override
    public ILogEntry debug(String key, Object[] args) {
        return new IMLogEntry(this.logger.debug(key, args));
    }

    @Override
    public ILogEntry debug(String key, Object arg) {
        return new IMLogEntry(this.logger.debug(key, new Object[]{arg}));
    }

    @Override
    public ILogEntry debug(String key, Object arg1, Object arg2) {
        return new IMLogEntry(this.logger.debug(key, new Object[]{arg1, arg2}));
    }

    @Override
    public ILogEntry debug(String key, Object arg1, Object arg2, Object arg3) {
        return new IMLogEntry(this.logger.debug(key, new Object[]{arg1, arg2, arg3}));
    }

    @Override
    public ILogEntry error(Object obj) {
        return new IMLogEntry(this.logger.error(obj.toString()));
    }

    @Override
    public ILogEntry error(Throwable e) {
        return new IMLogEntry(this.logger.error(e));
    }

    @Override
    public ILogEntry error(String key) {
        return new IMLogEntry(this.logger.error(key));
    }

    @Override
    public ILogEntry error(String key, Object[] args) {
        return new IMLogEntry(this.logger.error(key, args));
    }

    @Override
    public ILogEntry error(String key, Object arg) {
        return new IMLogEntry(this.logger.error(key, new Object[]{arg}));
    }

    @Override
    public ILogEntry error(String key, Object arg1, Object arg2) {
        return new IMLogEntry(this.logger.error(key, new Object[]{arg1, arg2}));
    }

    @Override
    public ILogEntry error(String key, Object arg1, Object arg2, Object arg3) {
        return new IMLogEntry(this.logger.error(key, new Object[]{arg1, arg2, arg3}));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public String getSimpleName() {
        return this.logger.getSimpleName();
    }

    @Override
    public ILogEntry info(Object obj) {
        return new IMLogEntry(this.logger.info(obj.toString()));
    }

    @Override
    public ILogEntry info(Throwable e) {
        return new IMLogEntry(this.logger.info(e));
    }

    @Override
    public ILogEntry info(String key) {
        return new IMLogEntry(this.logger.info(key));
    }

    @Override
    public ILogEntry info(String key, Object[] args) {
        return new IMLogEntry(this.logger.info(key, args));
    }

    @Override
    public ILogEntry info(String key, Object arg) {
        return new IMLogEntry(this.logger.info(key, new Object[]{arg}));
    }

    @Override
    public ILogEntry info(String key, Object arg1, Object arg2) {
        return new IMLogEntry(this.logger.info(key, new Object[]{arg1, arg2}));
    }

    @Override
    public ILogEntry info(String key, Object arg1, Object arg2, Object arg3) {
        return new IMLogEntry(this.logger.info(key, new Object[]{arg1, arg2, arg3}));
    }

    @Override
    public boolean isDebugLoggable() {
        return this.logger.isDebugLoggable();
    }

    @Override
    public boolean isErrorLoggable() {
        return this.logger.isErrorLoggable();
    }

    @Override
    public boolean isInfoLoggable() {
        return this.logger.isInfoLoggable();
    }

    @Override
    public boolean isLoggable(int level) {
        return this.logger.isLoggable(level);
    }

    @Override
    public boolean isNoteLoggable() {
        return this.logger.isNoteLoggable();
    }

    @Override
    public boolean isWarningLoggable() {
        return this.logger.isWarningLoggable();
    }

    @Override
    public ILogEntry log(int level, String key, Object[] args, String href) {
        return new IMLogEntry(this.logger.log(level, href, key, args));
    }

    @Override
    public ILogEntry note(Object obj) {
        return new IMLogEntry(this.logger.note(obj.toString(), new Object[0]));
    }

    @Override
    public ILogEntry note(Throwable e) {
        return new IMLogEntry(this.logger.note(e));
    }

    @Override
    public ILogEntry note(String key) {
        return new IMLogEntry(this.logger.note(key, new Object[0]));
    }

    @Override
    public ILogEntry note(String key, Object[] args) {
        return new IMLogEntry(this.logger.note(key, args));
    }

    @Override
    public ILogEntry note(String key, Object arg) {
        return new IMLogEntry(this.logger.note(key, new Object[]{arg}));
    }

    @Override
    public ILogEntry note(String key, Object arg1, Object arg2) {
        return new IMLogEntry(this.logger.note(key, new Object[]{arg1, arg2}));
    }

    @Override
    public ILogEntry note(String key, Object arg1, Object arg2, Object arg3) {
        return new IMLogEntry(this.logger.note(key, new Object[]{arg1, arg2, arg3}));
    }

    @Override
    public void setLevel(int level, final com.ibm.cic.agent.core.api.ILogListener listener) {
        this.logger.setLevel(level, new ILogListener(){

            public void close() {
                listener.close();
            }

            public void logEntry(LogEntry entry) {
                listener.logEntry(new IMLogEntry(entry));
            }
        });
    }

    @Override
    public void setMinLevel(int level) {
        this.logger.setMinLevel(level);
    }

    @Override
    public void setStackFilter(final ILogStackFilter stackFilter) {
        this.logger.setStackFilter(new Logger.LogStackFilter(){

            public boolean isLogger(StackTraceElement ste) {
                return stackFilter.isLogger(ste);
            }
        });
    }

    @Override
    public void start(ILogEntry entry) {
        this.logger.start(((IMLogEntry)entry).getLogEntry());
    }

    @Override
    public ILogEntry status(IStatus status) {
        return new IMLogEntry(this.logger.status(status));
    }

    @Override
    public ILogEntry status(String key, IStatus status) {
        return new IMLogEntry(this.logger.status(key, status));
    }

    @Override
    public ILogEntry statusNotOK(IStatus status) {
        return new IMLogEntry(this.logger.statusNotOK(status));
    }

    @Override
    public ILogEntry statusNotOK(String key, IStatus status) {
        return new IMLogEntry(this.logger.status(key, status));
    }

    @Override
    public void stop() {
        this.logger.stop();
    }

    @Override
    public ILogEntry warning(Object obj) {
        return new IMLogEntry(this.logger.warning(obj.toString()));
    }

    @Override
    public ILogEntry warning(Throwable e) {
        return new IMLogEntry(this.logger.warning(e));
    }

    @Override
    public ILogEntry warning(String key) {
        return new IMLogEntry(this.logger.warning(key));
    }

    @Override
    public ILogEntry warning(String key, Object[] args) {
        return new IMLogEntry(this.logger.warning(key, args));
    }

    @Override
    public ILogEntry warning(String key, Object arg) {
        return new IMLogEntry(this.logger.warning(key, new Object[]{arg}));
    }

    @Override
    public ILogEntry warning(String key, Object arg1, Object arg2) {
        return new IMLogEntry(this.logger.warning(key, new Object[]{arg1, arg2}));
    }

    @Override
    public ILogEntry warning(String key, Object arg1, Object arg2, Object arg3) {
        return new IMLogEntry(this.logger.warning(key, new Object[]{arg1, arg2, arg3}));
    }

    public String toString() {
        return this.logger.toString();
    }

    private static class IMLogEntry
    implements ILogEntry {
        private final LogEntry logEntry;

        IMLogEntry(LogEntry logEntry) {
            this.logEntry = logEntry;
        }

        @Override
        public String getFormattedMessage() {
            return this.logEntry.getFormattedMessage();
        }

        @Override
        public void setHref(String href) {
            this.logEntry.setHref(href);
        }

        public LogEntry getLogEntry() {
            return this.logEntry;
        }

        @Override
        public Object[] getArgs() {
            Object[] result = new Object[this.logEntry.getArgCount()];
            int i = 0;
            while (i < this.logEntry.getArgCount()) {
                result[i] = this.logEntry.getArg(i);
                ++i;
            }
            return result;
        }

        @Override
        public String getCallingClass() {
            return this.logEntry.getCallingClass();
        }

        @Override
        public String getCallingMethod() {
            return this.logEntry.getCallingMethod();
        }

        @Override
        public Throwable getException() {
            return this.logEntry.getException();
        }

        @Override
        public String getHref() {
            return this.logEntry.getHref();
        }

        @Override
        public int getLevel() {
            return this.logEntry.getLevel();
        }

        @Override
        public Logger getLogger() {
            return this.logEntry.getLogger();
        }

        @Override
        public String getLoggerName() {
            return this.logEntry.getLoggerName();
        }

        @Override
        public String getMessage() {
            return this.logEntry.getMessage();
        }

        @Override
        public int getNum() {
            return this.logEntry.getNum();
        }

        @Override
        public int getStartNum() {
            return this.logEntry.getStartNum();
        }

        @Override
        public String getThreadName() {
            return this.logEntry.getThreadName();
        }

        @Override
        public long getTime() {
            return this.logEntry.getTime();
        }
    }
}

