/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.sharedUI;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.RollbackJob;
import com.ibm.cic.agent.core.api.ICustomPanel;
import com.ibm.cic.agent.core.custompanel.api.TemplateCustomPanel;
import com.ibm.cic.agent.core.custompanel.api.TemplateRadioGroup;
import com.ibm.cic.agent.core.custompanel.api.TemplateSelectableWidget;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.sharedUI.CustomPanelJobPair;
import com.ibm.cic.agent.core.sharedUI.Messages;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.internal.core.history.IActivity;
import com.ibm.cic.common.core.model.ExtensionCategory;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.SliceUtils;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.eclipseAdapterData.EclipseAdapterData;
import com.ibm.cic.common.eclipseAdapterData.EclipseAgentBundleData;
import com.ibm.cic.common.eclipseAdapterData.IEclipseData;
import com.ibm.cic.common.logging.Level;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.parser.EntryRecord;
import com.ibm.cic.common.logging.parser.MessageRecord;
import com.ibm.cic.common.logging.parser.StackRecord;
import com.ibm.cic.common.logging.parser.ThrownRecord;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class SharedUIUtils {
    public static final String[] ACTIVITY_TYPE = new String[]{Messages.InstallHistory_ActivityType_Install, Messages.InstallHistory_ActivityType_Uninstall, Messages.InstallHistory_ActivityType_Rollback, Messages.InstallHistory_ActivityType_Update};
    public static final String ACTIVITY_STATUS_INCOMPLETE = Messages.InstallHistory_ActivityStatus_Incomplete;
    public static final String ACTIVITY_STATUS_SUCCESS = Messages.InstallHistory_ActivityStatus_Success;
    public static final String ACTIVITY_STATUS_FAILED = Messages.InstallHistory_ActivityStatus_Failed;

    public static boolean isHiddenAgentOffering(IOfferingOrFix offeringOrFix, boolean wizardMode) {
        Agent agent = Agent.getInstance();
        if (agent.isAgentOffering(offeringOrFix)) {
            if (!wizardMode) {
                if (agent.isAgentOfferingHidden() || !CacheLocationManager.getInstance().isCacheLocationChangeable() || agent.getAgentOffering() != null) {
                    return true;
                }
            } else {
                IOffering currentlyInstalledAgent = agent.getAgentOffering();
                if (currentlyInstalledAgent != null) {
                    IOffering offering = (IOffering)offeringOrFix;
                    return !agent.isAgentUpdate(offering, Statuses.ST.createMultiStatus());
                }
                return false;
            }
        }
        return false;
    }

    public static String getSimpleProductName() {
        String productName = "";
        IProduct product = Platform.getProduct();
        if (product != null) {
            productName = product.getName();
        }
        return productName;
    }

    public static String getFullProductName() {
        StringBuffer subTitle = null;
        if (CicCommonSettings.isBeta()) {
            subTitle = new StringBuffer(NLS.bind((String)Messages.AgentUIWorkbenchWindowAdvisor_BetaCaption, (Object)CicCommonSettings.getBetaProperty()));
        }
        if (CicCommonSettings.isBetaOverride()) {
            subTitle = new StringBuffer(Messages.AgentUIWorkbenchWindowAdvisor_BetaOverrideCaption);
        }
        if (Agent.getInstance().isSkipInstall()) {
            if (subTitle == null) {
                subTitle = new StringBuffer(Messages.AgentUIWorkbenchWindowAdvisor_SkipInstall);
            } else {
                if (subTitle.length() > 0) {
                    subTitle.append(", ");
                }
                subTitle.append(Messages.AgentUIWorkbenchWindowAdvisor_SkipInstall);
            }
        }
        if (Agent.getInstance().isRecordMode()) {
            if (subTitle == null) {
                subTitle = new StringBuffer(Messages.AgentUIWorkbenchWindowAdvisor_Recording);
            } else {
                if (subTitle.length() > 0) {
                    subTitle.append(", ");
                }
                subTitle.append(Messages.AgentUIWorkbenchWindowAdvisor_Recording);
            }
        }
        if (Agent.getInstance().isPortable()) {
            if (subTitle == null) {
                subTitle = new StringBuffer(Messages.AgentUIWorkbenchWindowAdvisor_Title_PortableInstall);
            } else {
                if (subTitle.length() > 0) {
                    subTitle.append(", ");
                }
                subTitle.append(Messages.AgentUIWorkbenchWindowAdvisor_Title_PortableInstall);
            }
        }
        if (AgentInput.getInstance().getMode() == 1 && (AgentInput.getInstance().getWizardSubMode() == 7 || AgentInput.getInstance().getWizardSubMode() == 8)) {
            if (subTitle == null) {
                subTitle = new StringBuffer(Messages.AgentUIWorkbenchWindowAdvisor_Title_ResponseFileGen);
            } else {
                if (subTitle.length() > 0) {
                    subTitle.append(", ");
                }
                subTitle.append(Messages.AgentUIWorkbenchWindowAdvisor_Title_ResponseFileGen);
            }
        }
        String simpleProductName = SharedUIUtils.getSimpleProductName();
        if (subTitle != null && subTitle.length() > 0) {
            return NLS.bind((String)Messages.AgentUIWorkbenchWindowAdvisor_Title_Subtitle, (Object)simpleProductName, (Object)subTitle.toString());
        }
        return simpleProductName;
    }

    public static IStatus prepareOfferingsAndFixes(List<? extends IOfferingOrFix> pkgs, IProgressMonitor monitor) {
        return SharedUIUtils.prepareOfferingsAndFixes(pkgs.toArray(new IOfferingOrFix[pkgs.size()]), monitor);
    }

    public static IStatus prepareOfferingsAndFixes(IOfferingOrFix[] offeringOrFix, IProgressMonitor monitor) {
        int[] weights = SharedUIUtils.getProgressWeightages(Arrays.asList(offeringOrFix));
        int work = 0;
        int[] nArray = weights;
        int n = weights.length;
        int n2 = 0;
        while (n2 < n) {
            int weight = nArray[n2];
            work += weight;
            ++n2;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)work);
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        int i = 0;
        while (i < offeringOrFix.length) {
            SubMonitor sm2 = sm.newChild(weights[i], 0);
            status.add(Agent.getInstance().prepare(offeringOrFix[i], ExtensionCategory.ALL, (IProgressMonitor)sm2, CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key())));
            ++i;
        }
        sm.done();
        return status;
    }

    public static int[] getProgressWeightages(List offeringsOrFixList) {
        int[] result = new int[offeringsOrFixList.size()];
        int index = 0;
        for (IOfferingOrFix offeringOrFix : offeringsOrFixList) {
            result[index++] = SharedUIUtils.getFeaturesCount(offeringOrFix);
        }
        return result;
    }

    private static int getFeaturesCount(IOfferingOrFix offering) {
        if (!(offering instanceof IOffering)) {
            return 0;
        }
        List allFeatures = ((IOffering)offering).getFilteredFeatures(new IOffering.FeatureFilter(){

            public boolean canAccept(IFeature feature) {
                return feature != null;
            }
        });
        return allFeatures.size();
    }

    public static IStatus prepareAndResolveSelectedJobs(List<AgentJob> jobs, IProgressMonitor monitor) {
        return SharedUIUtils.prepareAndResolveSelectedJobs(jobs, false, monitor);
    }

    private static IStatus prepareAndResolveSelectedJobs(List<AgentJob> jobs, boolean skipPrepare, IProgressMonitor monitor) {
        LinkedHashSet<Profile> profilesToPrepare = new LinkedHashSet<Profile>();
        ArrayList<IOfferingOrFix> pkgsToPrepare = new ArrayList<IOfferingOrFix>();
        for (AgentJob job : jobs) {
            if (!job.isSelected()) continue;
            IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
            pkgsToPrepare.add(offeringOrFix);
            Profile profile = job.getProfile();
            if (profile.isAgentProfile()) continue;
            profilesToPrepare.add(profile);
        }
        for (Profile profile : profilesToPrepare) {
            pkgsToPrepare.addAll(Arrays.asList(profile.getInstallRegistry().getInstalledOfferings()));
            pkgsToPrepare.addAll(Arrays.asList(profile.getInstallRegistry().getInstalledFixes()));
        }
        return SharedUIUtils.prepareAndResolveOfferingsAndFixes(pkgsToPrepare, skipPrepare, monitor);
    }

    public static IStatus prepareAndResolveOfferingsAndFixes(List<IOfferingOrFix> pkgsToPrepare, boolean skipPrepare, IProgressMonitor monitor) {
        IStatus return_value = Status.OK_STATUS;
        Agent agent = Agent.getInstance();
        int[] weights = SharedUIUtils.getProgressWeightages(pkgsToPrepare);
        int work = 0;
        int[] nArray = weights;
        int n = weights.length;
        int n2 = 0;
        while (n2 < n) {
            int weight = nArray[n2];
            work += weight;
            ++n2;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)work);
        Iterator<IOfferingOrFix> iterator = pkgsToPrepare.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            IStatus status;
            int ticks = weights[i++];
            SubMonitor sm2 = sm.newChild(ticks, 0);
            IOfferingOrFix offeringOrFix = iterator.next();
            if (!skipPrepare) {
                sm2.setWorkRemaining(2);
                boolean showInternalVersion = CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key());
                IStatus status2 = agent.prepare(offeringOrFix, ExtensionCategory.ALL, (IProgressMonitor)sm2.newChild(1, 0), showInternalVersion);
                if (status2.matches(8) || status2.matches(4)) {
                    return_value = status2;
                    break;
                }
            } else {
                sm2.setWorkRemaining(1);
            }
            if (!(status = agent.resolve(offeringOrFix, (IProgressMonitor)sm2.newChild(1, 0))).matches(8) && !status.matches(4)) continue;
            return_value = status;
            break;
        }
        if (sm != null) {
            sm.done();
        }
        return return_value;
    }

    public static boolean isPreferenceEditable(ICicPreferenceConstants.PreferenceTag tag) {
        CicPreferenceManager prefMan = CicPreferenceManager.getInstance();
        return prefMan.isEditable(tag) || Agent.getInstance().isCleanMode();
    }

    public static IStatus getAgentToleranceStatus(List<? extends AgentJob> jobs) {
        IStatus result = Status.OK_STATUS;
        for (AgentJob agentJob : jobs) {
            IStatus status = SharedUIUtils.getAgentToleranceStatus(agentJob);
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                return status;
            }
            if (!status.matches(2)) continue;
            result = status;
        }
        return result;
    }

    public static IStatus getAgentToleranceStatus(AgentJob job) {
        IStatus status = Agent.getInstance().checkAgentRequirement(job.getOfferingOrFix(), CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key()));
        return status;
    }

    public static IStatus getFeatureSetCheckStatus(List<RollbackJob> jobs) {
        ArrayList<IOffering> offeringsWithDifFeatureSet = new ArrayList<IOffering>();
        for (RollbackJob rollbackJob : jobs) {
            Set toFeatureSet;
            IOffering from = rollbackJob.getRollbackFromOffering();
            IOffering to = rollbackJob.getOffering();
            Profile profile = rollbackJob.getProfile();
            Set fromFeatureSet = Agent.getInstance().getInstalledFeatures(profile, from);
            if (fromFeatureSet.equals(toFeatureSet = Agent.getInstance().getInstalledFeatures(profile, to))) continue;
            offeringsWithDifFeatureSet.add(to);
        }
        if (!offeringsWithDifFeatureSet.isEmpty()) {
            StringBuilder offeringName = new StringBuilder();
            for (IOffering offering : offeringsWithDifFeatureSet) {
                offeringName.append(offering.getName()).append(',');
            }
            if (offeringName.length() > 0) {
                offeringName.setLength(offeringName.length() - 1);
            }
            return Statuses.WARNING.get(Messages.RollbackWizard_SummaryPage_FeatureSetWarning, new Object[]{offeringName});
        }
        return Status.OK_STATUS;
    }

    public static String getFeatureBaseLabel(IFeatureBase featureBase) {
        String featureName;
        Information info = featureBase.getInformation();
        if (info != null && (featureName = info.getName()) != null && featureName.trim().length() > 0) {
            return featureName.trim();
        }
        if (featureBase instanceof IFeature) {
            return ((IFeature)featureBase).getIdentity().getId();
        }
        return "";
    }

    public static String getLocalizedStatus(IActivity activity) {
        IStatus status = activity.getStatus();
        if (status == null) {
            return ACTIVITY_STATUS_INCOMPLETE;
        }
        if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
            return ACTIVITY_STATUS_SUCCESS;
        }
        return ACTIVITY_STATUS_FAILED;
    }

    public static String constructLogDescription(EntryRecord entryRecord) {
        MessageRecord msgRecord = entryRecord.getMessageRecord();
        String des = msgRecord.getMessage();
        List args = msgRecord.getArgs();
        if (!args.isEmpty()) {
            des = SharedUIUtils.getFormattedMessage(des, args);
        }
        return des;
    }

    private static String getFormattedMessage(String msg, List args) {
        String formattedMessage = "";
        Object[] stringArgs = new String[args.size()];
        int i = 0;
        while (i < args.size()) {
            stringArgs[i] = LogUtil.toString(args.get(i));
            ++i;
        }
        formattedMessage = NLS.bind((String)msg, (Object[])stringArgs);
        return formattedMessage;
    }

    public static String getLogSeverity(int levelNum) {
        if (levelNum == Level.ERROR) {
            return Messages.Severity_Error;
        }
        if (levelNum == Level.WARNING) {
            return Messages.Severity_Warning;
        }
        if (levelNum == Level.DEBUG) {
            return Messages.AgentLogView_Severity_Debug;
        }
        if (levelNum == Level.INFO) {
            return Messages.AgentLogView_Severity_Information;
        }
        if (levelNum == Level.NOTE) {
            return Messages.AgentLogView_Severity_Note;
        }
        return "";
    }

    public static String formatStackTrace(ThrownRecord thrownRecord) {
        StringBuffer buffer = new StringBuffer();
        if (thrownRecord == null) {
            buffer.append(Messages.LogViewDetails_noStackTrace);
        } else {
            String thrownMsg = thrownRecord.getThrown();
            if (thrownMsg != null && thrownMsg.length() > 0) {
                buffer.append(thrownMsg);
                List stacks = thrownRecord.getStacks();
                if (stacks != null && stacks.size() > 0) {
                    Iterator it = stacks.iterator();
                    while (it.hasNext()) {
                        buffer.append(LogUtil.NEWLINE);
                        buffer.append(((StackRecord)it.next()).getStack());
                    }
                }
            } else {
                List stacks = thrownRecord.getStacks();
                if (stacks != null && stacks.size() > 0) {
                    Iterator it = stacks.iterator();
                    while (it.hasNext()) {
                        buffer.append(LogUtil.NEWLINE);
                        buffer.append(((StackRecord)it.next()).getStack());
                    }
                } else {
                    buffer.append(Messages.LogViewDetails_noStackTrace);
                }
            }
        }
        return buffer.toString();
    }

    public static boolean displayStatckTrace(ThrownRecord thrownRecord) {
        if (thrownRecord == null) {
            return false;
        }
        String thrownMsg = thrownRecord.getThrown();
        if (thrownMsg == null || thrownMsg.length() == 0) {
            return false;
        }
        List stacks = thrownRecord.getStacks();
        return stacks != null && stacks.size() != 0;
    }

    public static IStatus checkBitModeArtifacts(List jobs, Profile profile) {
        StringBuilder offeringNames = new StringBuilder();
        int i = 0;
        while (i < jobs.size()) {
            IStatus status;
            AgentJob job = (AgentJob)jobs.get(i);
            IOffering offering = job.getOffering();
            if (offering != null && !(status = SliceUtils.checkPlatform((IOfferingOrFix)offering, (String)profile.getOS(), (String)profile.getArch())).isOK()) {
                offeringNames.append(OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offering)).append(", ");
            }
            ++i;
        }
        if (offeringNames.length() > 0) {
            offeringNames.setLength(offeringNames.length() - 2);
            return Statuses.ST.ERROR_STATUS.get(Messages.NoArtifactsForBitMode, new Object[]{offeringNames, BitModeUtils.getBitModeText(profile)});
        }
        return Status.OK_STATUS;
    }

    public static IStatus generateCustomPanelExceptionStatus(CustomPanelJobPair pair, Throwable e) {
        return SharedUIUtils.generateCustomPanelExceptionStatus(pair.getJob(), pair.getPanel(), e);
    }

    public static IStatus generateCustomPanelExceptionStatus(AgentJob job, ICustomPanel panel, Throwable e) {
        String panelId = panel.getPanelId();
        if (panelId == null) {
            panelId = panel.getClass().getSimpleName();
        }
        return SharedUIUtils.generateCustomPanelExceptionStatus(job, panelId, e);
    }

    public static IStatus generateCustomPanelExceptionStatus(AgentJob job, String panelName, Throwable e) {
        ICicStatus status = Statuses.ERROR.get(e, Messages.CommonCustomPanelException, new Object[]{panelName});
        if (job != null) {
            IOfferingOrFix offering = job.getOfferingOrFix();
            String offeringName = OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offering);
            status = Statuses.ERROR.get(e, Messages.CustomPanelException, new Object[]{panelName, offeringName});
        }
        return status;
    }

    public static IStatus generateCustomPanelExceptionStatus(TemplateCustomPanel panel, Throwable e) {
        return Statuses.ERROR.get(e, Messages.CommonCustomPanelException, new Object[]{panel.getPanelTitle()});
    }

    public static IStatus generateTemplateCustomPanelExceptionStatus(Throwable e) {
        return Statuses.ERROR.get(e, Messages.TemplateCustomPanelException, new Object[0]);
    }

    public static boolean haveInstalledOfferings() {
        Profile[] profiles;
        Profile[] profileArray = profiles = Agent.getInstance().getVisibleProfiles();
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering[] installedOfferings;
            Profile profile = profileArray[n2];
            String profileKind = profile.getProfileKind();
            if (!profileKind.equals("self") && !profileKind.equals("license") && (installedOfferings = Agent.getInstance().getInstalledOfferings(profile)).length > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static WizardType decideFlowType(AgentJob[] productJobs) {
        ArrayList<AgentJob> offeringJob = new ArrayList<AgentJob>();
        ArrayList<AgentJob> fixJob = new ArrayList<AgentJob>();
        AgentJob[] agentJobArray = productJobs;
        int n = productJobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOffering offering = job.getOffering();
            if (offering != null) {
                offeringJob.add(job);
            } else {
                IFix fix = job.getFix();
                if (fix != null) {
                    fixJob.add(job);
                }
            }
            ++n2;
        }
        if (!offeringJob.isEmpty()) {
            AgentJob firstJob = (AgentJob)offeringJob.get(0);
            if (firstJob.isInstall()) {
                return WizardType.INSTALL;
            }
            if (firstJob.isModify()) {
                return WizardType.MODIFY;
            }
            if (firstJob.isUpdate()) {
                return WizardType.UPDATE;
            }
            if (firstJob.isRollback()) {
                return WizardType.ROLLBACK;
            }
            return WizardType.UNINSTALL;
        }
        if (!fixJob.isEmpty()) {
            AgentJob firstFixJob = (AgentJob)fixJob.get(0);
            if (firstFixJob.isInstall()) {
                return WizardType.UPDATE;
            }
            if (firstFixJob.isUninstall()) {
                return WizardType.UNINSTALL;
            }
        }
        return null;
    }

    public static boolean nameIsInJobs(String name, AgentJob[] jobs) {
        return SharedUIUtils.nameIsInJobs(name, jobs, new String[0]);
    }

    public static boolean nameIsInJobs(String name, AgentJob[] jobs, String[] ignoreProjects) {
        return SharedUIUtils.getJobsThatIncludeIUName(name, jobs, ignoreProjects).size() > 0;
    }

    public static List<AgentJob> getJobsThatIncludeIUName(String name, AgentJob[] jobs) {
        return SharedUIUtils.getJobsThatIncludeIUName(name, jobs, new String[0]);
    }

    public static List<AgentJob> getJobsThatIncludeIUName(String name, AgentJob[] jobs, String[] ignoreProjects) {
        ArrayList<AgentJob> subJobs = new ArrayList<AgentJob>();
        boolean nameIsInIgnoreProjects = false;
        Object[] objectArray = ignoreProjects;
        int n = ignoreProjects.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = objectArray[n2];
            if (name.equals(projectName)) {
                nameIsInIgnoreProjects = true;
                break;
            }
            ++n2;
        }
        objectArray = jobs;
        n = jobs.length;
        n2 = 0;
        while (n2 < n) {
            Object job = objectArray[n2];
            IOfferingOrFix offeringOrFix = ((AgentJob)job).getOfferingOrFix();
            if (offeringOrFix != null && !Agent.getInstance().isAgentOffering(offeringOrFix) && !LicenseUtils.isPEKOffering((IOfferingOrFix)offeringOrFix)) {
                if (nameIsInIgnoreProjects && offeringOrFix.getProperty(name) != null) {
                    subJobs.add((AgentJob)job);
                } else {
                    List ius = offeringOrFix.getInstallableUnits();
                    for (IInstallableUnit iu : ius) {
                        IAdapterData adapterData;
                        if (!"eclipse".equals(iu.getAdapterId()) || !((adapterData = iu.getAdapterData()) instanceof EclipseAdapterData)) continue;
                        EclipseAdapterData data = (EclipseAdapterData)adapterData;
                        Collection dataElements = data.getDataElements();
                        for (IEclipseData element : dataElements) {
                            EclipseAgentBundleData agentBundleData;
                            if (!EclipseAgentBundleData.getKind().equals(element.getDataKind()) || !name.equals((agentBundleData = (EclipseAgentBundleData)element).getId())) continue;
                            subJobs.add((AgentJob)job);
                        }
                    }
                }
            }
            ++n2;
        }
        return subJobs;
    }

    public static AgentJob getJob(String offeringId, String offeringVersion, AgentJob[] jobs) {
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            if (CommonSharedUIUtils.offeringOrFixMatches((IOfferingOrFix)job.getOffering(), (String)offeringId, (String)offeringVersion)) {
                return job;
            }
            ++n2;
        }
        return null;
    }

    public static int getOfferingBundleNum(String bundleName, AgentJob job) {
        IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
        if (offeringOrFix == null || Agent.getInstance().isAgentOffering(offeringOrFix) || LicenseUtils.isPEKOffering((IOfferingOrFix)offeringOrFix)) {
            return 0;
        }
        List ius = offeringOrFix.getInstallableUnits();
        int i = 0;
        while (i < ius.size()) {
            IAdapterData adapterData;
            IInstallableUnit iu = (IInstallableUnit)ius.get(i);
            if ("eclipse".equals(iu.getAdapterId()) && (adapterData = iu.getAdapterData()) instanceof EclipseAdapterData) {
                EclipseAdapterData data = (EclipseAdapterData)adapterData;
                Collection dataElements = data.getDataElements();
                for (IEclipseData element : dataElements) {
                    EclipseAgentBundleData agentBundleData;
                    if (!EclipseAgentBundleData.getKind().equals(element.getDataKind()) || !bundleName.equals((agentBundleData = (EclipseAgentBundleData)element).getId())) continue;
                    return i + 1;
                }
            }
            ++i;
        }
        return 0;
    }

    public static boolean anyRadioButtonTriggerUpdate(TemplateRadioGroup group) {
        List<TemplateSelectableWidget> items = group.getItems();
        for (TemplateSelectableWidget item : items) {
            if (!item.getTriggerUpdate()) continue;
            return true;
        }
        return false;
    }

    public static void clearText(char[] chars) {
        Arrays.fill(chars, '\u0000');
    }

    public static void clearBytes(byte[] bytes) {
        Arrays.fill(bytes, (byte)0);
    }

    public static IStatus verifyDataLocation(String dataLocation) {
        if (dataLocation.length() == 0) {
            return Statuses.ERROR.get(Messages.DataLocationDialog_dataLocationEmpty, new Object[0]);
        }
        File file = new File(dataLocation);
        if (!file.isAbsolute()) {
            return Statuses.ERROR.get(Messages.DataLocationDialog_dataLocationIsNotAbsolute, new Object[0]);
        }
        if (file.exists() && !file.isDirectory()) {
            return Statuses.ERROR.get(Messages.DataLocationDialog_dataLocationIsNotDirectory, new Object[0]);
        }
        IStatus status = SharedUIUtils.verifyDataLocationCharsAreSupported(file);
        if (!status.isOK()) {
            return status;
        }
        status = SharedUIUtils.verifyDataLocationIsAccessible(file);
        if (!status.isOK()) {
            return status;
        }
        return AgentUtil.validateAndSetDataLocation(file.getPath());
    }

    private static IStatus verifyDataLocationIsAccessible(File dataLocation) {
        if (dataLocation.exists()) {
            IStatus status;
            File instRegFile;
            if (!FileUtil.canRead((File)dataLocation) || !FileUtil.canWrite((File)dataLocation)) {
                return Statuses.ERROR.get(Messages.DataLocationDialog_dataLocationIsNotAccessible, new Object[0]);
            }
            File agentPrefsDir = FileUtil.getCanonicalFile((File)CicCommonSettings.getApplicationPreferenceLocation((String)dataLocation.getPath()).toFile());
            if (agentPrefsDir.exists() && !FileUtil.directoryIsWriteable((String)agentPrefsDir.getPath())) {
                return Statuses.ERROR.get(Messages.DataLocationDialog_dataLocationSubdirNotAccessible, new Object[]{agentPrefsDir.getPath()});
            }
            File agentPrefs = new File(agentPrefsDir, String.valueOf(Agent.getBundleId()) + ".prefs");
            if (!(!agentPrefs.exists() || FileUtil.canRead((File)agentPrefs) && FileUtil.canWrite((File)agentPrefs))) {
                return Statuses.ERROR.get(Messages.DataLocationDialog_dataLocationSubfileNotAccessible, new Object[]{agentPrefs.getPath()});
            }
            if (CicCommonSettings.getAccessRightsMode().isGroupMode() && (instRegFile = new File(dataLocation, "installRegistry.xml")).exists() && !(status = AgentUtil.checkGroupId(instRegFile.getPath())).isOK()) {
                return status;
            }
        } else if (!FileUtil.directoryIsWriteable((String)dataLocation.getPath())) {
            return Statuses.ERROR.get(Messages.DataLocationDialog_dataLocationIsNotCreatable, new Object[0]);
        }
        return Status.OK_STATUS;
    }

    private static IStatus verifyDataLocationCharsAreSupported(File dataLocation) {
        File canonicalFile = FileUtil.getCanonicalFile((File)dataLocation);
        if (canonicalFile.getPath().contains("#")) {
            return Statuses.ERROR.get(Messages.DataLocationDialog_dataLocationHasUnsupportedChar, new Object[]{canonicalFile.getPath(), "#"});
        }
        return Status.OK_STATUS;
    }
}

