/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.sharedUI;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.sharedUI.IContainsFix;
import com.ibm.cic.agent.core.sharedUI.ProfileOffering;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import org.eclipse.core.runtime.IAdaptable;

public class ProfileOfferingFix
implements IContainsFix,
IAdaptable {
    private final ProfileOffering profileOffering;
    private final IFix fix;

    public ProfileOfferingFix(ProfileOffering profileOffering, IFix fix) {
        this.profileOffering = profileOffering;
        this.fix = fix;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IFix.class)) {
            return this.fix;
        }
        return this.fix.getAdapter(adapter);
    }

    public int hashCode() {
        return this.fix.getIdentity().hashCode() + this.fix.getVersion().hashCode() + this.profileOffering.getOffering().getIdentity().hashCode() + this.profileOffering.getOffering().getVersion().hashCode() + this.profileOffering.getProfile().getProfileId().hashCode();
    }

    public static ProfileOfferingFix[] getFixesFromProfileOffering(ProfileOffering profileOffering) {
        IFix[] fixes = Agent.getInstance().getInstalledFixes(profileOffering.getProfile(), profileOffering.getOffering());
        if (fixes != null && fixes.length > 0) {
            ProfileOfferingFix[] result = new ProfileOfferingFix[fixes.length];
            SortUtil.sortByNameAndVersion((IOfferingOrFix[])fixes);
            int i = 0;
            while (i < fixes.length) {
                result[i] = new ProfileOfferingFix(profileOffering, fixes[i]);
                ++i;
            }
            return result;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProfileOfferingFix) {
            if (obj == this) {
                return true;
            }
            ProfileOfferingFix other = (ProfileOfferingFix)obj;
            if (!other.getProfileOffering().getProfile().getProfileId().equals(this.profileOffering.getProfile().getProfileId())) {
                return false;
            }
            if (!other.getProfileOffering().getOffering().getIdentity().equals(this.profileOffering.getOffering().getIdentity())) {
                return false;
            }
            if (!other.getProfileOffering().getOffering().getVersion().equals((Object)this.profileOffering.getOffering().getVersion())) {
                return false;
            }
            if (!other.getFix().getIdentity().equals(this.fix.getIdentity())) {
                return false;
            }
            return other.getFix().getVersion().equals((Object)this.fix.getVersion());
        }
        return false;
    }

    public ProfileOffering getProfileOffering() {
        return this.profileOffering;
    }

    @Override
    public IFix getFix() {
        return this.fix;
    }
}

