/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.sharedUI;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.ICustomPanel;
import com.ibm.cic.common.core.model.IOffering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CustomPanelJobPair {
    private static final Comparator<IOffering> OFFERING_COMPARATOR = new Comparator<IOffering>(){

        @Override
        public int compare(IOffering offering1, IOffering offering2) {
            if (offering1 == offering2) {
                return 0;
            }
            if (offering1 == null) {
                return -1;
            }
            if (offering2 == null) {
                return 1;
            }
            return offering1.getIdentity().getId().compareTo(offering2.getIdentity().getId());
        }
    };
    private final ICustomPanel panel;
    private final AgentJob job;
    private Profile profile;

    public static Map<Profile, Map<IOffering, List<CustomPanelJobPair>>> groupCustomPanels(List<CustomPanelJobPair> panels) {
        LinkedHashMap<Profile, Map<IOffering, List<CustomPanelJobPair>>> result = new LinkedHashMap<Profile, Map<IOffering, List<CustomPanelJobPair>>>();
        for (CustomPanelJobPair panel : panels) {
            ArrayList<CustomPanelJobPair> list;
            Profile profile = panel.getProfile();
            AgentJob job = panel.getJob();
            IOffering offering = job == null ? null : job.getOffering();
            TreeMap<IOffering, ArrayList<CustomPanelJobPair>> map = (TreeMap<IOffering, ArrayList<CustomPanelJobPair>>)result.get(profile);
            if (map == null) {
                map = new TreeMap<IOffering, ArrayList<CustomPanelJobPair>>(OFFERING_COMPARATOR);
                result.put(profile, map);
            }
            if ((list = (ArrayList<CustomPanelJobPair>)map.get(offering)) == null) {
                list = new ArrayList<CustomPanelJobPair>();
                map.put(offering, list);
            }
            list.add(panel);
        }
        return result;
    }

    public CustomPanelJobPair(ICustomPanel panel, AgentJob job) {
        this.panel = panel;
        this.job = job;
    }

    public ICustomPanel getPanel() {
        return this.panel;
    }

    public AgentJob getJob() {
        return this.job;
    }

    public Profile getProfile() {
        if (this.job != null) {
            return this.job.getProfile();
        }
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }
}

