/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.sharedUI;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.CustomPanelData;
import com.ibm.cic.agent.core.api.ConCustomPanel;
import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.api.ICustomPanel;
import com.ibm.cic.agent.core.sharedUI.CustomPanelJobPair;
import com.ibm.cic.agent.core.sharedUI.CustomPanelOrderFactory;
import com.ibm.cic.agent.core.sharedUI.ICustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.NullCustomPanel;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public final class CustomPanelFactory
implements ICustomPanelFactory {
    private static final String TAG_CUSTOM_PANELS = "customPanels";
    private static final String TAG_PANEL = "panel";
    private static final ICustomPanelFactory INSTANCE = new CustomPanelFactory();

    public static ICustomPanelFactory getInstance() {
        return INSTANCE;
    }

    @Override
    @Deprecated
    public CustomPanelJobPair[] createCustomPanels(boolean consoleMode, Class<? extends ICustomPanel> panelClass, WizardType type, AgentJob[] allProductJobs) throws CoreException {
        return this.createCustomPanels(consoleMode, panelClass, type, allProductJobs, false);
    }

    @Override
    public CustomPanelJobPair[] createCustomPanels(boolean consoleMode, Class<? extends ICustomPanel> panelClass, WizardType type, AgentJob[] allProductJobs, boolean isMultipleProfile) throws CoreException {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.cic.agent.ui", TAG_CUSTOM_PANELS);
        if (extensionPoint == null) {
            return new CustomPanelJobPair[0];
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<Panel> panelExtensions = new ArrayList<Panel>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseDefinitions(extension, panelExtensions);
            ++n2;
        }
        if (panelExtensions.isEmpty()) {
            return new CustomPanelJobPair[0];
        }
        ArrayList<CustomPanelJobPair> result = new ArrayList<CustomPanelJobPair>();
        List<CustomPanelOrderFactory.JobPanelList> jobPanels = CustomPanelOrderFactory.getInstance().createCustomPanelOrder(type, allProductJobs);
        for (CustomPanelOrderFactory.JobPanelList jobPanelOrder : jobPanels) {
            AgentJob job = jobPanelOrder.getJob();
            List<String> panelIds = jobPanelOrder.getPanelIds();
            IAgentJob[] jobsInOneProfile = jobPanelOrder.getProfileJobs();
            for (String id : panelIds) {
                Panel panel = this.getPanelExtensionWithId(id, panelExtensions);
                if (panel == null) continue;
                ICustomPanel customPanel = panel.getPanel(consoleMode, panelClass, job);
                try {
                    CustomPanelData data = new CustomPanelData(allProductJobs, jobsInOneProfile);
                    customPanel.init(data);
                    customPanel.initCustomPanelData(data);
                    if (!customPanel.canAddPanel()) continue;
                    CustomPanelJobPair panelJob = new CustomPanelJobPair(customPanel, job);
                    result.add(panelJob);
                }
                catch (Exception e) {
                    IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus(job, customPanel, (Throwable)e);
                    throw new CoreException(status);
                }
            }
        }
        return result.toArray(new CustomPanelJobPair[result.size()]);
    }

    private Panel getPanelExtensionWithId(String id, List<Panel> panelExt) {
        for (Panel panel : panelExt) {
            if (!id.equals(panel.getPanelId())) continue;
            return panel;
        }
        return null;
    }

    private void parseDefinitions(IExtension extension, List<Panel> panelExt) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(TAG_PANEL)) {
                panelExt.add(new Panel(element));
            }
            ++n2;
        }
    }

    private static class Panel {
        private final IConfigurationElement element;

        public Panel(IConfigurationElement element) {
            this.element = element;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Panel for <").append(this.element.getName());
            String[] stringArray = this.element.getAttributeNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                sb.append(' ').append(attr).append("='").append(this.element.getAttribute(attr)).append('\'');
                ++n2;
            }
            sb.append('>');
            return sb.toString();
        }

        public String getPanelId() {
            return this.element.getAttribute("id");
        }

        public ICustomPanel getPanel(boolean consoleMode, Class<? extends ICustomPanel> clazz, AgentJob job) throws CoreException {
            String attr = consoleMode ? "textClass" : "class";
            Class<? extends ICustomPanel> classType = clazz;
            if (consoleMode) {
                attr = clazz.equals(ConCustomPanel.class) ? "conClass" : "textClass";
            }
            if (attr.equals("textClass") && this.element.getAttribute("conClass") != null) {
                return NullCustomPanel.INSTANCE;
            }
            if (this.element.getAttribute(attr) != null) {
                return this.createPanel(attr, classType);
            }
            Logger.getLogger().warning("No \"{0}\" attribute in \"{1}\" element of panel {2} in {3}", new Object[]{attr, this.element.getName(), this.element.getAttribute("id"), this.element.getContributor().getName()});
            return NullCustomPanel.INSTANCE;
        }

        private ICustomPanel createPanel(String attrName, Class<? extends ICustomPanel> clazz) throws CoreException {
            Object extn = this.element.createExecutableExtension(attrName);
            if (!clazz.isInstance(extn)) {
                throw new CoreException((IStatus)new Status(4, Agent.PI_AGENT, NLS.bind((String)"Class specified by \"{0}\" attribute of \"{1}\" element in {2} must be a subtype of {3}; actual type is {4}", (Object[])new Object[]{attrName, this.element.getName(), this.element.getContributor().getName(), clazz.getName(), extn.getClass().getName()})));
            }
            return (ICustomPanel)extn;
        }
    }
}

